



options nocenter nodate nonumber source symbolgen compress=yes;


libname library "/home/field005/2007cpstabs/pubuse2007/data";

proc format cntlin=library.fcpmar07;

/*
proc contents data=library.cpsmar07 varnum;
run;
*/


proc freq data=library.cpsmar07;
  weight marsupwt;
  tables p_stat a_exprrp hhdfmx /format=best10 nopercent;
  where hhdfmx ne 51;
%include "/home/field005/2007cpstabs/pubuse2007/formata.fmt";
run;

/**************************************************/
/* Create variable labels-add new variables etc.  */
/**************************************************/


data addspous (index=(perid));
 set library.cpsmar07;


/*variables of sort and merge*/

id=ph_seq;
id2=pf_seq*1;
idnum=id*1;
idfam=phf_seq*1;
idfg2=phf_seq;
idfm=pf_seq*1;
apar=a_parent*1;
testfm=idnum||idfm;
testid=idnum||idfam;
mrg_fg=idnum||idfam||apar;
mrg_fm=idnum||idfm||apar;
hhpar=idnum||apar;
fgid=ph_seq||phf_seq;

perid=ph_seq||a_lineno;



/*this code creates the non-white hispanic categoy*/

if pehspnon ='02' and prdtrace ='01'           then hisp='2'; 
       /*'White alone Non-Hisp'*/
  else if pehspnon ='01'                       then hisp='1'; 
       /*'Hispanic'*/
  else if pehspnon ='02' and prdtrace  ne '01' then hisp='3'; 
       /*'Other Non-Hisp'*/

/* RACE FOR TEXT TABLES     */

if      pehspnon = '02' and prdtrace = '01'         then race_eth ='1'; 
   /*'White alone Non-Hisp'*/
else if pehspnon = '02' and prdtrace = '02'         then race_eth ='2'; 
   /*'Black alone Non-Hisp'*/
else if pehspnon = '01'                             then race_eth ='3'; 
   /*'Hispanic'      */
else if pehspnon = '02' and prdtrace notin ('01','02') then race_eth ='4'; 
   /*'Other Non-Hisp'*/

run;

/*********************************************************/
/*  Attaching spouse information to each adult with      */
/*  a spouse, adding some basic spouse info.             */
/*********************************************************/

data spousfil (index=(perid)
               keep=perid ph_seq sphf_seq sa_age sa_martl sa_sex 
               sa_race shhdrel sxrrp shhdfmx sa_hga sparent sa_parnt 
               sa_linno sch_mc sch_hi sa_lfsr sa_wkst sa_fmtyp spf_seq 
               srac_eth sagemean sagehldr sone shisp sprrp sprracew 
               sprraceb sprracai sprracea srrrachp sprdtrac
               sprdthsp spehspno speorisp speoroto spuraceo);



set addspous;
perid   =ph_seq||a_spouse;

sphf_seq= phf_seq;
sa_age  =   a_age;
sa_martl=a_maritl;
sa_sex  =   a_sex;
sa_race =  prdtrace;
shhdrel =  hhdrel;
sprrp   =   perrp;
sxrrp   =a_exprrp;
shhdfmx =  hhdfmx;
sa_hga  =   a_hga;
sparent =  parent;
sa_parnt=a_parent;
sa_linno=a_lineno;
sch_mc  =   ch_mc;
sch_hi  =   ch_hi;
sa_lfsr =  a_lfsr;
sa_wkst =a_wkstat;
sa_fmtyp=a_famtyp;
spf_seq =  pf_seq;
srac_eth=race_eth;
sagemean= agemean;
sagehldr=agehhldr;
sone    =     one;
shisp   =    hisp;

sprracew= prracew;
sprraceb= prraceb;
sprracai=prraceai;
sprracea= prracea;
srrrachp=prracehp;
sprdtrac=prdtrace;
sprdthsp= prdthsp;
spehspno=pehspnon;
speorisp=peorispn;
speoroto=peorotsp;
spuraceo=puraceot;

run;

data makesibs;
merge addspous (in=inper) spousfil (in=inspous);
   if inper;
   by perid;
run;

/*********************************************************/
/*  the number of siblings a child has in household      */
/*  (siblings=own children - the child you have).        */
/*********************************************************/

proc sort data=makesibs force;
   by mrg_fg;
run;

data sibsdat (keep= mrg_fg sibs);
 set makesibs;
 by mrg_fg;

retain sibs;

if first.mrg_fg then
   do;
   sibs=-1;
end;

sibs=sibs+1;

if last.mrg_fg then output sibsdat;
run;

data flipwork;
merge makesibs (in=inper) sibsdat (in=insibs);
   if inper;
   by mrg_fg;
run;

proc sort data=flipwork;
  by mrg_fg a_lineno;
run;

/***************************************************************************/
/* Creating a household matrix for use in generating childrens' hhold      */
/* composition. This attaches info for everyone on everyone elses record.  */
/***************************************************************************/

/*********************************************************/
/*  presence of related and unrelated adults in the      */
/*  household. Proc Transpose to add info to all records.*/
/*  After the transposed hhlds are made the will be added*/
/*  back to the flipwork file by ph_seq.  Make addtrns   */
/*  file last. Relies on their being 16 max people in CPS*/
/*********************************************************/

data newindex (index=(ph_seq));
set flipwork;
    by ph_seq;

/* making a person line counter   */

retain pernum;

if first.ph_seq then
   do;
   pernum=0;
end;


pernum=pernum + 1;

run;

data flipnext (index=(ph_seq));
set newindex;
run;

/*********************************************************/
/*  */
/*  */
/*********************************************************/

/*********************************************************/
/*  Transpose - AGE                                      */
/*********************************************************/

proc transpose data=flipnext out=hhflip;
     by ph_seq;
     id pernum;
    var a_age;
   copy ph_seq;
run;

data ageflip (index=(ph_seq)
              rename=(_1=age_1     _2=age_2     _3=age_3     _4=age_4
                     _5=age_5     _6=age_6     _7=age_7     _8=age_8
                     _9=age_9    _10=age_10   _11=age_11   _12=age_12
                    _13=age_13   _14=age_14   _15=age_15   _16=age_16)
              );
set hhflip;

if _1 ne '';

run;

/*********************************************************/
/*  Transpose - SPOUSES AGE                              */
/*********************************************************/

proc transpose data=flipnext out=hhflip;
     by ph_seq;
     id pernum;
    var sa_age;
   copy ph_seq;
run;

data sageflip (index=(ph_seq)
              rename=(_1=sage_1     _2=sage_2     _3=sage_3     _4=sage_4
                     _5=sage_5     _6=sage_6     _7=sage_7     _8=sage_8
                     _9=sage_9    _10=sage_10   _11=sage_11   _12=sage_12
                    _13=sage_13   _14=sage_14   _15=sage_15   _16=sage_16)
              );
set hhflip;

if _1 ne '';

run;

/*********************************************************/
/*  Transpose - MARITAL STATUS                           */
/*********************************************************/

proc transpose data=flipnext out=hhflip;
     by ph_seq;
     id pernum;
    var a_maritl;
   copy ph_seq;
run;

data mstflip (index=(ph_seq)
              rename=(_1=mst_1     _2=mst_2     _3=mst_3     _4=mst_4
                     _5=mst_5     _6=mst_6     _7=mst_7     _8=mst_8
                     _9=mst_9    _10=mst_10   _11=mst_11   _12=mst_12
                    _13=mst_13   _14=mst_14   _15=mst_15   _16=mst_16)
              );
set hhflip;

if _1 ne '';

run;
/*
proc freq data = mstflip;
     tables mst_1     mst_2     mst_3     mst_4
            mst_5     mst_6     mst_7     mst_8
            mst_9     mst_10    mst_11    mst_12
            mst_13    mst_14    mst_15    mst_16;
run;
*/

/*
proc contents data=mstflip;
run;
*/
/*********************************************************/
/*  Transpose - SEX                                      */
/*********************************************************/

proc transpose data=flipnext out=hhflip;
     by ph_seq;
     id pernum;
    var a_sex;
   copy ph_seq;
run;

data sexflip (index=(ph_seq)
              rename=(_1=sex_1     _2=sex_2     _3=sex_3     _4=sex_4
                     _5=sex_5     _6=sex_6     _7=sex_7     _8=sex_8
                     _9=sex_9    _10=sex_10   _11=sex_11   _12=sex_12
                    _13=sex_13   _14=sex_14   _15=sex_15   _16=sex_16)
              );
set hhflip;

if _1 ne '';

run;
/*
proc freq data = sexflip;
     tables sex_1     sex_2     sex_3     sex_4
            sex_5     sex_6     sex_7     sex_8
            sex_9     sex_10    sex_11    sex_12
            sex_13    sex_14    sex_15    sex_16;
run;
*/
/*
proc contents data=sexflip;
run;
*/
/*********************************************************/
/*  Transpose - SPOUSES SEX                              */
/*********************************************************/

proc transpose data=flipnext out=hhflip;
     by ph_seq;
     id pernum;
    var sa_sex;
   copy ph_seq;
run;

data ssexflip (index=(ph_seq)
              rename=(_1=ssex_1     _2=ssex_2     _3=ssex_3     _4=ssex_4
                     _5=ssex_5     _6=ssex_6     _7=ssex_7     _8=ssex_8
                     _9=ssex_9    _10=ssex_10   _11=ssex_11   _12=ssex_12
                    _13=ssex_13   _14=ssex_14   _15=ssex_15   _16=ssex_16)
              );
set hhflip;

if _1 ne '';

run;
/*
proc freq data = ssexflip;
     tables ssex_1     ssex_2     ssex_3     ssex_4
            ssex_5     ssex_6     ssex_7     ssex_8
            ssex_9     ssex_10    ssex_11    ssex_12
            ssex_13    ssex_14    ssex_15    ssex_16;
run;
*/
/*
proc contents data=ssexflip;
run;
*/

/*********************************************************/
/*  Transpose - HISP                                     */
/*********************************************************/

proc transpose data=flipnext out=hhflip;
     by ph_seq;
     id pernum;
    var hisp;
   copy ph_seq;
run;

data hisflip (index=(ph_seq)
              rename=(_1=his_1     _2=his_2     _3=his_3     _4=his_4
                     _5=his_5     _6=his_6     _7=his_7     _8=his_8
                     _9=his_9    _10=his_10   _11=his_11   _12=his_12
                    _13=his_13   _14=his_14   _15=his_15   _16=his_16)
              );
set hhflip;

if _1 ne '';

run;
/*
proc contents data=hisflip;
run;
*/
/*********************************************************/
/*  Transpose - SPOUSES HISP                             */
/*********************************************************/

proc transpose data=flipnext out=hhflip;
     by ph_seq;
     id pernum;
    var shisp;
   copy ph_seq;
run;

data shisflip (index=(ph_seq)
              rename=(_1=shis_1     _2=shis_2     _3=shis_3     _4=shis_4
                     _5=shis_5     _6=shis_6     _7=shis_7     _8=shis_8
                     _9=shis_9    _10=shis_10   _11=shis_11   _12=shis_12
                    _13=shis_13   _14=shis_14   _15=shis_15   _16=shis_16)
              );
set hhflip;

if _1 ne '';

run;
/*
proc contents data=shisflip;
run;
*/

/*********************************************************/
/*  Transpose - DETAILED RACE                            */
/*********************************************************/

proc transpose data=flipnext out=hhflip;
     by ph_seq;
     id pernum;
    var prdtrace;
   copy ph_seq;
run;

data prdtflip (index=(ph_seq)
              rename=(_1=prdt_1     _2=prdt_2     _3=prdt_3     _4=prdt_4
                     _5=prdt_5     _6=prdt_6     _7=prdt_7     _8=prdt_8
                     _9=prdt_9    _10=prdt_10   _11=prdt_11   _12=prdt_12
                    _13=prdt_13   _14=prdt_14   _15=prdt_15   _16=prdt_16)
              );
set hhflip;

if _1 ne '';

run;
/*********************************************************/
/*  Transpose - SPOUSES DETAILED RACE                    */
/*********************************************************/

proc transpose data=flipnext out=hhflip;
     by ph_seq;
     id pernum;
    var sprdtrac;
   copy ph_seq;
run;

data sprdflip (index=(ph_seq)
              rename=(_1=sprd_1     _2=sprd_2     _3=sprd_3     _4=sprd_4
                     _5=sprd_5     _6=sprd_6     _7=sprd_7     _8=sprd_8
                     _9=sprd_9    _10=sprd_10   _11=sprd_11   _12=sprd_12
                    _13=sprd_13   _14=sprd_14   _15=sprd_15   _16=sprd_16)
              );
set hhflip;

if _1 ne '';

run;

/*********************************************************/
/*  Transpose - ASEC HISP                                */
/*********************************************************/

proc transpose data=flipnext out=hhflip;
     by ph_seq;
     id pernum;
    var pehspnon;
   copy ph_seq;
run;

data phspflip (index=(ph_seq)
              rename=(_1=phsp_1     _2=phsp_2     _3=phsp_3     _4=phsp_4
                     _5=phsp_5     _6=phsp_6     _7=phsp_7     _8=phsp_8
                     _9=phsp_9    _10=phsp_10   _11=phsp_11   _12=phsp_12
                    _13=phsp_13   _14=phsp_14   _15=phsp_15   _16=phsp_16)
              );
set hhflip;

if _1 ne '';

run;
/*********************************************************/
/*  Transpose - SPOUSES ASEC HISP                        */
/*********************************************************/

proc transpose data=flipnext out=hhflip;
     by ph_seq;
     id pernum;
    var spehspno;
   copy ph_seq;
run;

data shspflip (index=(ph_seq)
              rename=(_1=shsp_1     _2=shsp_2     _3=shsp_3     _4=shsp_4
                     _5=shsp_5     _6=shsp_6     _7=shsp_7     _8=shsp_8
                     _9=shsp_9    _10=shsp_10   _11=shsp_11   _12=shsp_12
                    _13=shsp_13   _14=shsp_14   _15=shsp_15   _16=shsp_16)
              );
set hhflip;

if _1 ne '';

run;


/*********************************************************/
/*  Transpose - HHDREL                                   */
/*********************************************************/

proc transpose data=flipnext out=hhflip;
     by ph_seq;
     id pernum;
    var hhdrel;
   copy ph_seq;
run;

data hdrlflip (index=(ph_seq)
              rename=(_1=hdrl_1     _2=hdrl_2     _3=hdrl_3     _4=hdrl_4
                     _5=hdrl_5     _6=hdrl_6     _7=hdrl_7     _8=hdrl_8
                     _9=hdrl_9    _10=hdrl_10   _11=hdrl_11   _12=hdrl_12
                    _13=hdrl_13   _14=hdrl_14   _15=hdrl_15   _16=hdrl_16)
              );
set hhflip;

if _1 ne '';

run;
/*
proc contents data=hdrlflip;
run;
*/
/*********************************************************/
/*  Transpose - PERRP                                    */
/*********************************************************/

proc transpose data=flipnext out=hhflip;
     by ph_seq;
     id pernum;
    var perrp;
   copy ph_seq;
run;

data prrpflip (index=(ph_seq)
              rename=(_1=prrp_1     _2=prrp_2     _3=prrp_3     _4=prrp_4
                     _5=prrp_5     _6=prrp_6     _7=prrp_7     _8=prrp_8
                     _9=prrp_9    _10=prrp_10   _11=prrp_11   _12=prrp_12
                    _13=prrp_13   _14=prrp_14   _15=prrp_15   _16=prrp_16)
              );
set hhflip;

if _1 ne '';

run;
/*
proc contents data=prrpflip;
run;
*/
/*********************************************************/
/*  Transpose - SPOUSES perrp                            */
/*********************************************************/

proc transpose data=flipnext out=hhflip;
     by ph_seq;
     id pernum;
    var sprrp;
   copy ph_seq;
run;

data sprpflip (index=(ph_seq)
              rename=(_1=sprp_1     _2=sprp_2     _3=sprp_3     _4=sprp_4
                     _5=sprp_5     _6=sprp_6     _7=sprp_7     _8=sprp_8
                     _9=sprp_9    _10=sprp_10   _11=sprp_11   _12=sprp_12
                    _13=sprp_13   _14=sprp_14   _15=sprp_15   _16=sprp_16)
              );
set hhflip;

if _1 ne '';

run;
/*
proc contents data=sprpflip;
run;
*/

/*********************************************************/
/*  Transpose - A_EXPRRP                                 */
/*********************************************************/

proc transpose data=flipnext out=hhflip;
     by ph_seq;
     id pernum;
    var a_exprrp;
   copy ph_seq;
run;

data rrpflip (index=(ph_seq)
              rename=(_1=rrp_1     _2=rrp_2     _3=rrp_3     _4=rrp_4
                     _5=rrp_5     _6=rrp_6     _7=rrp_7     _8=rrp_8
                     _9=rrp_9    _10=rrp_10   _11=rrp_11   _12=rrp_12
                    _13=rrp_13   _14=rrp_14   _15=rrp_15   _16=rrp_16)
              );
set hhflip;

if _1 ne '';

run;
/*
proc contents data=rrpflip;
run;
*/
/*********************************************************/
/*  Transpose - SPOUSES a_exprrp                         */
/*********************************************************/

proc transpose data=flipnext out=hhflip;
     by ph_seq;
     id pernum;
    var sxrrp;
   copy ph_seq;
run;

data srrpflip (index=(ph_seq)
              rename=(_1=srrp_1     _2=srrp_2     _3=srrp_3     _4=srrp_4
                     _5=srrp_5     _6=srrp_6     _7=srrp_7     _8=srrp_8
                     _9=srrp_9    _10=srrp_10   _11=srrp_11   _12=srrp_12
                    _13=srrp_13   _14=srrp_14   _15=srrp_15   _16=srrp_16)
              );
set hhflip;

if _1 ne '';

run;
/*
proc contents data=srrpflip;
run;
*/

/*********************************************************/
/*  Transpose - HHDFMX                                   */
/*********************************************************/

proc transpose data=flipnext out=hhflip;
     by ph_seq;
     id pernum;
    var hhdfmx;
   copy ph_seq;
run;

data hdfxflip (index=(ph_seq)
              rename=(_1=hdfx_1     _2=hdfx_2     _3=hdfx_3     _4=hdfx_4
                     _5=hdfx_5     _6=hdfx_6     _7=hdfx_7     _8=hdfx_8
                     _9=hdfx_9    _10=hdfx_10   _11=hdfx_11   _12=hdfx_12
                    _13=hdfx_13   _14=hdfx_14   _15=hdfx_15   _16=hdfx_16)
              );
set hhflip;

if _1 ne '';

run;
/*
proc contents data=hdfxflip;
run;
*/
/*********************************************************/
/*  Transpose - SPOUSES HHDFMX                           */
/*********************************************************/

proc transpose data=flipnext out=hhflip;
     by ph_seq;
     id pernum;
    var shhdfmx;
   copy ph_seq;
run;

data shdfflip (index=(ph_seq)
              rename=(_1=shdf_1     _2=shdf_2     _3=shdf_3     _4=shdf_4
                     _5=shdf_5     _6=shdf_6     _7=shdf_7     _8=shdf_8
                     _9=shdf_9    _10=shdf_10   _11=shdf_11   _12=shdf_12
                    _13=shdf_13   _14=shdf_14   _15=shdf_15   _16=shdf_16)
              );
set hhflip;

if _1 ne '';

run;
/*
proc contents data=shdfflip;
run;
*/
/*********************************************************/
/*  Transpose - EDUCATIONAL ATTAINMENT - A_HGA           */
/*********************************************************/

proc transpose data=flipnext out=hhflip;
     by ph_seq;
     id pernum;
    var a_hga;
   copy ph_seq;
run;

data hgaflip (index=(ph_seq)
              rename=(_1=hga_1     _2=hga_2     _3=hga_3     _4=hga_4
                     _5=hga_5     _6=hga_6     _7=hga_7     _8=hga_8
                     _9=hga_9    _10=hga_10   _11=hga_11   _12=hga_12
                    _13=hga_13   _14=hga_14   _15=hga_15   _16=hga_16)
              );
set hhflip;

if _1 ne '';

run;
/*
proc contents data=hgaflip;
run;
*/
/*********************************************************/
/*  Transpose - SPOUSES EDUCATIONAL ATTAINMENT - A_HGA   */
/*********************************************************/

proc transpose data=flipnext out=hhflip;
     by ph_seq;
     id pernum;
    var sa_hga;
   copy ph_seq;
run;

data shgaflip (index=(ph_seq)
              rename=(_1=shga_1     _2=shga_2     _3=shga_3     _4=shga_4
                     _5=shga_5     _6=shga_6     _7=shga_7     _8=shga_8
                     _9=shga_9    _10=shga_10   _11=shga_11   _12=shga_12
                    _13=shga_13   _14=shga_14   _15=shga_15   _16=shga_16)
              );
set hhflip;

if _1 ne '';

run;
/*
proc contents data=shgaflip;
run;
*/
/*********************************************************/
/*  Transpose - A_PARENT                                 */
/*********************************************************/

proc transpose data=flipnext out=hhflip;
     by ph_seq;
     id pernum;
    var a_parent;
   copy ph_seq;
run;

data parflip (index=(ph_seq)
              rename=(_1=par_1     _2=par_2     _3=par_3     _4=par_4
                     _5=par_5     _6=par_6     _7=par_7     _8=par_8
                     _9=par_9    _10=par_10   _11=par_11   _12=par_12
                    _13=par_13   _14=par_14   _15=par_15   _16=par_16)
              );
set hhflip;

if _1 ne '';

run;
/*
proc freq data = parflip;
     tables par_1     par_2     par_3     par_4
            par_5     par_6     par_7     par_8
            par_9     par_10    par_11    par_12
            par_13    par_14    par_15    par_16;
run;
*/
/*
proc contents data=parflip;
run;
*/
/*********************************************************/
/*  Transpose - SPOUSES A_PARENT POINTER                 */
/*********************************************************/

proc transpose data=flipnext out=hhflip;
     by ph_seq;
     id pernum;
    var sa_parnt;
   copy ph_seq;
run;

data sprnflip (index=(ph_seq)
              rename=(_1=sprn_1     _2=sprn_2     _3=sprn_3     _4=sprn_4
                     _5=sprn_5     _6=sprn_6     _7=sprn_7     _8=sprn_8
                     _9=sprn_9    _10=sprn_10   _11=sprn_11   _12=sprn_12
                    _13=sprn_13   _14=sprn_14   _15=sprn_15   _16=sprn_16)
              );
set hhflip;

if _1 ne '';

run;
/*
proc contents data=sprnflip;
run;
*/
/*********************************************************/
/*  Transpose - PELNMOM pointer */
/*********************************************************/

proc transpose data=flipnext out=hhflip;
     by ph_seq;
     id pernum;
    var pelnmom;
   copy ph_seq;
run;

data momflip (index=(ph_seq)
              rename=(_1=mom_1     _2=mom_2     _3=mom_3     _4=mom_4
                     _5=mom_5     _6=mom_6     _7=mom_7     _8=mom_8
                     _9=mom_9    _10=mom_10   _11=mom_11   _12=mom_12
                    _13=mom_13   _14=mom_14   _15=mom_15   _16=mom_16)
              );
set hhflip;

if _1 ne '';

run;
/*
proc freq data = momflip;
     tables mom_1     mom_2     mom_3     mom_4
            mom_5     mom_6     mom_7     mom_8
            mom_9     mom_10    mom_11    mom_12
            mom_13    mom_14    mom_15    mom_16;
run;
*/
/*
proc contents data=momflip;
run;
*/
/*********************************************************/
/*  Transpose - PELNDAD pointer */
/*********************************************************/

proc transpose data=flipnext out=hhflip;
     by ph_seq;
     id pernum;
    var pelndad;
   copy ph_seq;
run;

data dadflip (index=(ph_seq)
              rename=(_1=dad_1     _2=dad_2     _3=dad_3     _4=dad_4
                     _5=dad_5     _6=dad_6     _7=dad_7     _8=dad_8
                     _9=dad_9    _10=dad_10   _11=dad_11   _12=dad_12
                    _13=dad_13   _14=dad_14   _15=dad_15   _16=dad_16)
              );
set hhflip;

if _1 ne '';

run;
/*
proc freq data = dadflip;
     tables dad_1     dad_2     dad_3     dad_4
            dad_5     dad_6     dad_7     dad_8
            dad_9     dad_10    dad_11    dad_12
            dad_13    dad_14    dad_15    dad_16;
run;
*/
/*
proc contents data=dadflip;
run;
*/
/*********************************************************/
/*  Transpose - PEMOMTYP Type Mom */
/*********************************************************/

proc transpose data=flipnext out=hhflip;
     by ph_seq;
     id pernum;
    var pemomtyp;
   copy ph_seq;
run;

data momtyflip (index=(ph_seq)
              rename=(_1=momty_1     _2=momty_2     _3=momty_3     _4=momty_4
                     _5=momty_5     _6=momty_6     _7=momty_7     _8=momty_8
                     _9=momty_9    _10=momty_10   _11=momty_11   _12=momty_12
                    _13=momty_13   _14=momty_14   _15=momty_15   _16=momty_16)
              );
set hhflip;

if _1 ne '';

run;
/*
proc freq data = momtyflip;
     tables momty_1     momty_2     momty_3     momty_4
            momty_5     momty_6     momty_7     momty_8
            momty_9     momty_10    momty_11    momty_12
            momty_13    momty_14    momty_15    momty_16;
run;
*/
/*
proc contents data=momtyflip;
run;
*/
/*********************************************************/
/*  Transpose - PEDADTYP Type Dad */
/*********************************************************/

proc transpose data=flipnext out=hhflip;
     by ph_seq;
     id pernum;
    var pedadtyp;
   copy ph_seq;
run;

data dadtyflip (index=(ph_seq)
              rename=(_1=dadty_1     _2=dadty_2     _3=dadty_3     _4=dadty_4
                     _5=dadty_5     _6=dadty_6     _7=dadty_7     _8=dadty_8
                     _9=dadty_9    _10=dadty_10   _11=dadty_11   _12=dadty_12
                    _13=dadty_13   _14=dadty_14   _15=dadty_15   _16=dadty_16)
              );
set hhflip;

if _1 ne '';

run;
/*
proc freq data = dadtyflip;
     tables dadty_1     dadty_2     dadty_3     dadty_4
            dadty_5     dadty_6     dadty_7     dadty_8
            dadty_9     dadty_10    dadty_11    dadty_12
            dadty_13    dadty_14    dadty_15    dadty_16;
run;
*/
/*
proc contents data=dadtyflip;
run;
*/
/*********************************************************/
/*  Transpose - a_lineno                                 */
/*********************************************************/

proc transpose data=flipnext out=hhflip;
     by ph_seq;
     id pernum;
    var a_lineno;
   copy ph_seq;
run;

data linflip (index=(ph_seq)
              rename=(_1=lin_1     _2=lin_2     _3=lin_3     _4=lin_4
                     _5=lin_5     _6=lin_6     _7=lin_7     _8=lin_8
                     _9=lin_9    _10=lin_10   _11=lin_11   _12=lin_12
                    _13=lin_13   _14=lin_14   _15=lin_15   _16=lin_16)
              );
set hhflip;

if _1 ne '';

run;
/*
proc freq data = linflip;
     tables lin_1     lin_2     lin_3     lin_4
            lin_5     lin_6     lin_7     lin_8
            lin_9     lin_10    lin_11    lin_12
            lin_13    lin_14    lin_15    lin_16;
run;
*/
/*
proc contents data=linflip;
run;
*/
/*********************************************************/
/*  Transpose - SPOUSES A_LINENO POINTER                 */
/*********************************************************/

proc transpose data=flipnext out=hhflip;
     by ph_seq;
     id pernum;
    var sa_linno;
   copy ph_seq;
run;

data slinflip (index=(ph_seq)
              rename=(_1=slin_1     _2=slin_2     _3=slin_3     _4=slin_4
                     _5=slin_5     _6=slin_6     _7=slin_7     _8=slin_8
                     _9=slin_9    _10=slin_10   _11=slin_11   _12=slin_12
                    _13=slin_13   _14=slin_14   _15=slin_15   _16=slin_16)
              );
set hhflip;

if _1 ne '';

run;
/*
proc contents data=slinflip;
run;
*/
/*********************************************************/
/*  Transpose - PECOHAB record holder's cohab partner    */
/*********************************************************/

proc transpose data=flipnext out=hhflip;
     by ph_seq;
     id pernum;
    var pecohab;
   copy ph_seq;
run;

data cohflip (index=(ph_seq)
              rename=(_1=coh_1     _2=coh_2     _3=coh_3     _4=coh_4
                     _5=coh_5     _6=coh_6     _7=coh_7     _8=coh_8
                     _9=coh_9    _10=coh_10   _11=coh_11   _12=coh_12
                    _13=coh_13   _14=coh_14   _15=coh_15   _16=coh_16)
              );
set hhflip;

if _1 ne '';

run;
/*********************************************************/
/*  Transpose - ch_mc                                    */
/*********************************************************/

proc transpose data=flipnext out=hhflip;
     by ph_seq;
     id pernum;
    var ch_mc;
   copy ph_seq;
run;

data cmcflip (index=(ph_seq)
              rename=(_1=cmc_1     _2=cmc_2     _3=cmc_3     _4=cmc_4
                     _5=cmc_5     _6=cmc_6     _7=cmc_7     _8=cmc_8
                     _9=cmc_9    _10=cmc_10   _11=cmc_11   _12=cmc_12
                    _13=cmc_13   _14=cmc_14   _15=cmc_15   _16=cmc_16)
              );
set hhflip;

if _1 ne '';

run;
/*
proc contents data=cmcflip;
run;
*/
/*********************************************************/
/*  Transpose - ch_hi                                    */
/*********************************************************/

proc transpose data=flipnext out=hhflip;
     by ph_seq;
     id pernum;
    var ch_hi;
   copy ph_seq;
run;

data chiflip (index=(ph_seq)
              rename=(_1=chi_1     _2=chi_2     _3=chi_3     _4=chi_4
                     _5=chi_5     _6=chi_6     _7=chi_7     _8=chi_8
                     _9=chi_9    _10=chi_10   _11=chi_11   _12=chi_12
                    _13=chi_13   _14=chi_14   _15=chi_15   _16=chi_16)
              );
set hhflip;

if _1 ne '';

run;
/*
proc contents data=chiflip;
run;
*/
/*********************************************************/
/*  Transpose - a_lfsr                                   */
/*********************************************************/

proc transpose data=flipnext out=hhflip;
     by ph_seq;
     id pernum;
    var a_lfsr;
   copy ph_seq;
run;

data lfsflip (index=(ph_seq)
              rename=(_1=lfs_1     _2=lfs_2     _3=lfs_3     _4=lfs_4
                     _5=lfs_5     _6=lfs_6     _7=lfs_7     _8=lfs_8
                     _9=lfs_9    _10=lfs_10   _11=lfs_11   _12=lfs_12
                    _13=lfs_13   _14=lfs_14   _15=lfs_15   _16=lfs_16)
              );
set hhflip;

if _1 ne '';

run;
/*
proc contents data=lfsflip;
run;
*/
/*********************************************************/
/*  Transpose - SPOUSES A_LFSR                           */
/*********************************************************/

proc transpose data=flipnext out=hhflip;
     by ph_seq;
     id pernum;
    var sa_lfsr;
   copy ph_seq;
run;

data slfsflip (index=(ph_seq)
              rename=(_1=slfs_1     _2=slfs_2     _3=slfs_3     _4=slfs_4
                     _5=slfs_5     _6=slfs_6     _7=slfs_7     _8=slfs_8
                     _9=slfs_9    _10=slfs_10   _11=slfs_11   _12=slfs_12
                    _13=slfs_13   _14=slfs_14   _15=slfs_15   _16=slfs_16)
              );
set hhflip;

if _1 ne '';

run;
/*
proc contents data=slfsflip;
run;
*/
/*********************************************************/
/*  Transpose - a_wkstat                                 */
/*********************************************************/

proc transpose data=flipnext out=hhflip;
     by ph_seq;
     id pernum;
    var a_wkstat;
   copy ph_seq;
run;

data wrkflip (index=(ph_seq)
              rename=(_1=wrk_1     _2=wrk_2     _3=wrk_3     _4=wrk_4
                     _5=wrk_5     _6=wrk_6     _7=wrk_7     _8=wrk_8
                     _9=wrk_9    _10=wrk_10   _11=wrk_11   _12=wrk_12
                    _13=wrk_13   _14=wrk_14   _15=wrk_15   _16=wrk_16)
              );
set hhflip;

if _1 ne '';

run;
/*
proc contents data=wrkflip;
run;
*/
/*********************************************************/
/*  Transpose - SPOUSES A_WKSTAT                         */
/*********************************************************/

proc transpose data=flipnext out=hhflip;
     by ph_seq;
     id pernum;
    var sa_wkst;
   copy ph_seq;
run;

data swrkflip (index=(ph_seq)
              rename=(_1=swrk_1     _2=swrk_2     _3=swrk_3     _4=swrk_4
                     _5=swrk_5     _6=swrk_6     _7=swrk_7     _8=swrk_8
                     _9=swrk_9    _10=swrk_10   _11=swrk_11   _12=swrk_12
                    _13=swrk_13   _14=swrk_14   _15=swrk_15   _16=swrk_16)
              );
set hhflip;

if _1 ne '';

run;
/*
proc contents data=swrkflip;
run;
*/
/*********************************************************/
/*  Transpose - a_famtyp                                 */
/*********************************************************/

proc transpose data=flipnext out=hhflip;
     by ph_seq;
     id pernum;
    var a_famtyp;
   copy ph_seq;
run;

data ftyflip (index=(ph_seq)
              rename=(_1=fty_1     _2=fty_2     _3=fty_3     _4=fty_4
                     _5=fty_5     _6=fty_6     _7=fty_7     _8=fty_8
                     _9=fty_9    _10=fty_10   _11=fty_11   _12=fty_12
                    _13=fty_13   _14=fty_14   _15=fty_15   _16=fty_16)
              );
set hhflip;

if _1 ne '';

run;
/*
proc contents data=ftyflip;
run;
*/
/*********************************************************/
/*  Transpose - a_famrel                                 */
/*********************************************************/

proc transpose data=flipnext out=hhflip;
     by ph_seq;
     id pernum;
    var a_famrel;
   copy ph_seq;
run;

data frlflip (index=(ph_seq)
              rename=(_1=frl_1     _2=frl_2     _3=frl_3     _4=frl_4
                     _5=frl_5     _6=frl_6     _7=frl_7     _8=frl_8
                     _9=frl_9    _10=frl_10   _11=frl_11   _12=frl_12
                    _13=frl_13   _14=frl_14   _15=frl_15   _16=frl_16)
              );
set hhflip;

if _1 ne '';

run;
/*
proc contents data=frlflip;
run;
*/
/*********************************************************/
/*  Transpose - a_famnum                                 */
/*********************************************************/

proc transpose data=flipnext out=hhflip;
     by ph_seq;
     id pernum;
    var a_famnum;
   copy ph_seq;
run;

data fnmflip (index=(ph_seq)
              rename=(_1=fnm_1     _2=fnm_2     _3=fnm_3     _4=fnm_4
                     _5=fnm_5     _6=fnm_6     _7=fnm_7     _8=fnm_8
                     _9=fnm_9    _10=fnm_10   _11=fnm_11   _12=fnm_12
                    _13=fnm_13   _14=fnm_14   _15=fnm_15   _16=fnm_16)
              );
set hhflip;

if _1 ne '';

run;
/*
proc contents data=fnmflip;
run;
*/
/*********************************************************/
/*  Transpose - race_eth                                 */
/*********************************************************/

proc transpose data=flipnext out=hhflip;
     by ph_seq;
     id pernum;
    var race_eth;
   copy ph_seq;
run;

data ethflip (index=(ph_seq)
              rename=(_1=eth_1     _2=eth_2     _3=eth_3     _4=eth_4
                     _5=eth_5     _6=eth_6     _7=eth_7     _8=eth_8
                     _9=eth_9    _10=eth_10   _11=eth_11   _12=eth_12
                    _13=eth_13   _14=eth_14   _15=eth_15   _16=eth_16)
              );
set hhflip;

if _1 ne '';

run;
/*
proc contents data=ethflip;
run;
*/
/*********************************************************/
/*  Transpose - SPOUSES RACE_ETH                         */
/*********************************************************/

proc transpose data=flipnext out=hhflip;
     by ph_seq;
     id pernum;
    var srac_eth;
   copy ph_seq;
run;

data sethflip (index=(ph_seq)
              rename=(_1=seth_1     _2=seth_2     _3=seth_3     _4=seth_4
                     _5=seth_5     _6=seth_6     _7=seth_7     _8=seth_8
                     _9=seth_9    _10=seth_10   _11=seth_11   _12=seth_12
                    _13=seth_13   _14=seth_14   _15=seth_15   _16=seth_16)
              );
set hhflip;

if _1 ne '';

run;
/*
proc contents data=sethflip;
run;
*/
/*********************************************************/
/*  Transpose - pf_seq                                   */
/*********************************************************/

proc transpose data=flipnext out=hhflip;
     by ph_seq;
     id pernum;
    var pf_seq;
   copy ph_seq;
run;

data pf_flip (index=(ph_seq)
              rename=(_1=pf_1     _2=pf_2     _3=pf_3     _4=pf_4
                     _5=pf_5     _6=pf_6     _7=pf_7     _8=pf_8
                     _9=pf_9    _10=pf_10   _11=pf_11   _12=pf_12
                    _13=pf_13   _14=pf_14   _15=pf_15   _16=pf_16)
              );
set hhflip;

if _1 ne '';

run;
/*
proc contents data=pf_flip;
run;
*/
/*********************************************************/
/*  Transpose - phf_seq                                  */
/*********************************************************/

proc transpose data=flipnext out=hhflip;
     by ph_seq;
     id pernum;
    var phf_seq;
   copy ph_seq;
run;

data phfflip (index=(ph_seq)
              rename=(_1=phf_1     _2=phf_2     _3=phf_3     _4=phf_4
                     _5=phf_5     _6=phf_6     _7=phf_7     _8=phf_8
                     _9=phf_9    _10=phf_10   _11=phf_11   _12=phf_12
                    _13=phf_13   _14=phf_14   _15=phf_15   _16=phf_16)
              );
set hhflip;

if _1 ne '';

run;
/*
proc freq data = phfflip;
     tables phf_1     phf_2     phf_3     phf_4
            phf_5     phf_6     phf_7     phf_8
            phf_9     phf_10    phf_11    phf_12
            phf_13    phf_14    phf_15    phf_16;
run;
*/
/*
proc contents data=phfflip;
run;
*/
/*********************************************************/
/*  Transpose - a_spouse                                 */
/*********************************************************/

proc transpose data=flipnext out=hhflip;
     by ph_seq;
     id pernum;
    var a_spouse;
   copy ph_seq;
run;

data spoflip (index=(ph_seq)
              rename=(_1=spo_1     _2=spo_2     _3=spo_3     _4=spo_4
                     _5=spo_5     _6=spo_6     _7=spo_7     _8=spo_8
                     _9=spo_9    _10=spo_10   _11=spo_11   _12=spo_12
                    _13=spo_13   _14=spo_14   _15=spo_15   _16=spo_16)
              );
set hhflip;

if _1 ne '';

run;
/*
proc contents data=spoflip;
run;
*/
/*********************************************************/
/*  Transpose - prcitshp                                 */
/*********************************************************/

proc transpose data=flipnext out=hhflip;
     by ph_seq;
     id pernum;
    var prcitshp;
   copy ph_seq;
run;

data citflip (index=(ph_seq)
              rename=(_1=cit_1     _2=cit_2     _3=cit_3     _4=cit_4
                     _5=cit_5     _6=cit_6     _7=cit_7     _8=cit_8
                     _9=cit_9    _10=cit_10   _11=cit_11   _12=cit_12
                    _13=cit_13   _14=cit_14   _15=cit_15   _16=cit_16)
              );
set hhflip;

if _1 ne '';

run;
/*
proc contents data=citflip;
run;
*/
/*********************************************************/
/*  Transpose - penatvty                                 */
/*********************************************************/

proc transpose data=flipnext out=hhflip;
     by ph_seq;
     id pernum;
    var penatvty;
   copy ph_seq;
run;

data natflip (index=(ph_seq)
              rename=(_1=nat_1     _2=nat_2     _3=nat_3     _4=nat_4
                     _5=nat_5     _6=nat_6     _7=nat_7     _8=nat_8
                     _9=nat_9    _10=nat_10   _11=nat_11   _12=nat_12
                    _13=nat_13   _14=nat_14   _15=nat_15   _16=nat_16)
              );
set hhflip;

if _1 ne '';

run;
/*
proc contents data=natflip;
run;
*/
/*********************************************************/
/*  Transpose - pemntvty                                 */
/*********************************************************/

proc transpose data=flipnext out=hhflip;
     by ph_seq;
     id pernum;
    var pemntvty;
   copy ph_seq;
run;

data mnvflip (index=(ph_seq)
              rename=(_1=mnv_1     _2=mnv_2     _3=mnv_3     _4=mnv_4
                     _5=mnv_5     _6=mnv_6     _7=mnv_7     _8=mnv_8
                     _9=mnv_9    _10=mnv_10   _11=mnv_11   _12=mnv_12
                    _13=mnv_13   _14=mnv_14   _15=mnv_15   _16=mnv_16)
              );
set hhflip;

if _1 ne '';

run;
/*
proc contents data=mnvflip;
run;
*/
/*********************************************************/
/*  Transpose - pefntvty                                 */
/*********************************************************/

proc transpose data=flipnext out=hhflip;
     by ph_seq;
     id pernum;
    var pefntvty;
   copy ph_seq;
run;

data fnvflip (index=(ph_seq)
              rename=(_1=fnv_1     _2=fnv_2     _3=fnv_3     _4=fnv_4
                     _5=fnv_5     _6=fnv_6     _7=fnv_7     _8=fnv_8
                     _9=fnv_9    _10=fnv_10   _11=fnv_11   _12=fnv_12
                    _13=fnv_13   _14=fnv_14   _15=fnv_15   _16=fnv_16)
              );
set hhflip;

if _1 ne '';

run;
/*
proc contents data=fnvflip;
run;
*/

/*********************************************************/
/*  Transpose - paw_typ                                  */
/*********************************************************/

proc transpose data=flipnext out=hhflip;
     by ph_seq;
     id pernum;
    var paw_typ;
   copy ph_seq;
run;

data pwtflip (index=(ph_seq)
              rename=(_1=pwt_1     _2=pwt_2     _3=pwt_3     _4=pwt_4
                     _5=pwt_5     _6=pwt_6     _7=pwt_7     _8=pwt_8
                     _9=pwt_9    _10=pwt_10   _11=pwt_11   _12=pwt_12
                    _13=pwt_13   _14=pwt_14   _15=pwt_15   _16=pwt_16)
              );
set hhflip;

if _1 ne '';

run;
/*
proc contents data=pwtflip;
run;
*/

/*********************************************************/
/*  Transpose - paw_mon                                  */
/*********************************************************/

proc transpose data=flipnext out=hhflip;
     by ph_seq;
     id pernum;
    var paw_mon;
   copy ph_seq;
run;

data pwmflip (index=(ph_seq)
              rename=(_1=pwm_1     _2=pwm_2     _3=pwm_3     _4=pwm_4
                     _5=pwm_5     _6=pwm_6     _7=pwm_7     _8=pwm_8
                     _9=pwm_9    _10=pwm_10   _11=pwm_11   _12=pwm_12
                    _13=pwm_13   _14=pwm_14   _15=pwm_15   _16=pwm_16)
              );
set hhflip;

if _1 ne '';

run;
/*
proc contents data=pwmflip;
run;
*/

/*********************************************************/
/*  Transpose - csp_yn                                   */
/*********************************************************/

proc transpose data=flipnext out=hhflip;
     by ph_seq;
     id pernum;
    var csp_yn;
   copy ph_seq;
run;

data cspflip (index=(ph_seq)
              rename=(_1=csp_1     _2=csp_2     _3=csp_3     _4=csp_4
                     _5=csp_5     _6=csp_6     _7=csp_7     _8=csp_8
                     _9=csp_9    _10=csp_10   _11=csp_11   _12=csp_12
                    _13=csp_13   _14=csp_14   _15=csp_15   _16=csp_16)
              );
set hhflip;

if _1 ne '';

run;
/*
proc contents data=cspflip;
run;
*/

/*********************************************************/
/*  Transpose - rsnnotw                                  */
/*********************************************************/

proc transpose data=flipnext out=hhflip;
     by ph_seq;
     id pernum;
    var rsnnotw;
   copy ph_seq;
run;

data rnwflip (index=(ph_seq)
              rename=(_1=rnw_1     _2=rnw_2     _3=rnw_3     _4=rnw_4
                     _5=rnw_5     _6=rnw_6     _7=rnw_7     _8=rnw_8
                     _9=rnw_9    _10=rnw_10   _11=rnw_11   _12=rnw_12
                    _13=rnw_13   _14=rnw_14   _15=rnw_15   _16=rnw_16)
              );
set hhflip;

if _1 ne '';

run;
/*
proc contents data=rnwflip;
run;
*/

/*********************************************************/
/*  Transpose - pyrsn                                    */
/*********************************************************/

proc transpose data=flipnext out=hhflip;
     by ph_seq;
     id pernum;
    var pyrsn;
   copy ph_seq;
run;

data pynflip (index=(ph_seq)
              rename=(_1=pyn_1     _2=pyn_2     _3=pyn_3     _4=pyn_4
                     _5=pyn_5     _6=pyn_6     _7=pyn_7     _8=pyn_8
                     _9=pyn_9    _10=pyn_10   _11=pyn_11   _12=pyn_12
                    _13=pyn_13   _14=pyn_14   _15=pyn_15   _16=pyn_16)
              );
set hhflip;

if _1 ne '';

run;
/*
proc contents data=pynflip;
run;
*/


/*********************************************************/
/*  Transpose - workyn                                   */
/*********************************************************/

proc transpose data=flipnext out=hhflip;
     by ph_seq;
     id pernum;
    var workyn;
   copy ph_seq;
run;

data wynflip (index=(ph_seq)
              rename=(_1=wyn_1     _2=wyn_2     _3=wyn_3     _4=wyn_4
                     _5=wyn_5     _6=wyn_6     _7=wyn_7     _8=wyn_8
                     _9=wyn_9    _10=wyn_10   _11=wyn_11   _12=wyn_12
                    _13=wyn_13   _14=wyn_14   _15=wyn_15   _16=wyn_16)
              );
set hhflip;

if _1 ne '';

run;
/*
proc contents data=wynflip;
run;
*/


/*********************************************************/
/*  Transpose - wkswork                                  */
/*********************************************************/

proc transpose data=flipnext out=hhflip;
     by ph_seq;
     id pernum;
    var wkswork;
   copy ph_seq;
run;

data wkwflip (index=(ph_seq)
              rename=(_1=wkw_1     _2=wkw_2     _3=wkw_3     _4=wkw_4
                      _5=wkw_5     _6=wkw_6     _7=wkw_7     _8=wkw_8
                      _9=wkw_9    _10=wkw_10   _11=wkw_11   _12=wkw_12
                     _13=wkw_13   _14=wkw_14   _15=wkw_15   _16=wkw_16)
              );
set hhflip;

if _1 ne '';

run;
/*
proc contents data=wkwflip;
run;
*/

/*********************************************************/
/*  Transpose - lkweeks                                  */
/*********************************************************/

proc transpose data=flipnext out=hhflip;
     by ph_seq;
     id pernum;
    var lkweeks;
   copy ph_seq;
run;

data lkwflip (index=(ph_seq)
              rename=(_1=lkw_1     _2=lkw_2     _3=lkw_3     _4=lkw_4
                      _5=lkw_5     _6=lkw_6     _7=lkw_7     _8=lkw_8
                      _9=lkw_9    _10=lkw_10   _11=lkw_11   _12=lkw_12
                     _13=lkw_13   _14=lkw_14   _15=lkw_15   _16=lkw_16)
              );
set hhflip;

if _1 ne '';

run;
/*
proc contents data=lkwflip;
run;
*/


/*********************************************************/
/*  Transpose - wsal_val                                 */
/*********************************************************/

proc transpose data=flipnext out=hhflip;
     by ph_seq;
     id pernum;
    var wsal_val;
   copy ph_seq;
run;

data wsvflip (index=(ph_seq)
              rename=(_1=wsv_1     _2=wsv_2     _3=wsv_3     _4=wsv_4
                      _5=wsv_5     _6=wsv_6     _7=wsv_7     _8=wsv_8
                      _9=wsv_9    _10=wsv_10   _11=wsv_11   _12=wsv_12
                     _13=wsv_13   _14=wsv_14   _15=wsv_15   _16=wsv_16)
              );
set hhflip;

if _1 ne '';

run;
/*
proc contents data=wsvflip;
run;
*/

/*********************************************************/
/*  Transpose - pearnval                                  */
/*********************************************************/

proc transpose data=flipnext out=hhflip;
     by ph_seq;
     id pernum;
    var pearnval;
   copy ph_seq;
run;

data pearnflip (index=(ph_seq)
              rename=(_1=pearn_1     _2=pearn_2     _3=pearn_3     _4=pearn_4
                      _5=pearn_5     _6=pearn_6     _7=pearn_7     _8=pearn_8
                      _9=pearn_9    _10=pearn_10   _11=pearn_11   _12=pearn_12
                     _13=pearn_13   _14=pearn_14   _15=pearn_15   _16=pearn_16)
              );
set hhflip;

if _1 ne '';

run;
/*
proc contents data=pearnflip;
run;
*/

/*********************************************************/
/*  Transpose - ern_val                                  */
/*********************************************************/

proc transpose data=flipnext out=hhflip;
     by ph_seq;
     id pernum;
    var ern_val;
   copy ph_seq;
run;

data ervflip (index=(ph_seq)
              rename=(_1=erv_1     _2=erv_2     _3=erv_3     _4=erv_4
                      _5=erv_5     _6=erv_6     _7=erv_7     _8=erv_8
                      _9=erv_9    _10=erv_10   _11=erv_11   _12=erv_12
                     _13=erv_13   _14=erv_14   _15=erv_15   _16=erv_16)
              );
set hhflip;

if _1 ne '';

run;
/*
proc contents data=ervflip;
run;
*/


/*********************************************************/
/*  Transpose - ern_yn                                   */
/*********************************************************/

proc transpose data=flipnext out=hhflip;
     by ph_seq;
     id pernum;
    var ern_yn;
   copy ph_seq;
run;

data eynflip (index=(ph_seq)
              rename=(_1=eyn_1     _2=eyn_2     _3=eyn_3     _4=eyn_4
                      _5=eyn_5     _6=eyn_6     _7=eyn_7     _8=eyn_8
                      _9=eyn_9    _10=eyn_10   _11=eyn_11   _12=eyn_12
                     _13=eyn_13   _14=eyn_14   _15=eyn_15   _16=eyn_16)
              );
set hhflip;

if _1 ne '';

run;
/*
proc contents data=eynflip;
run;
*/



/*********************************************************/
/*  END Transpose - BEGIN MERGING FILES ONTO ORIGINAL    */
/*********************************************************/

data addtrns (index=(ph_seq));
merge flipnext (in=inper) ageflip (in=inmod) sageflip mstflip sexflip
	ssexflip hisflip shisflip prdtflip sprdflip 
        phspflip shspflip hdrlflip prrpflip sprpflip 
        rrpflip srrpflip hdfxflip shdfflip hgaflip shgaflip parflip 
        momflip dadflip momtyflip dadtyflip sprnflip linflip slinflip 
        cohflip cmcflip chiflip lfsflip slfsflip wrkflip swrkflip
        ftyflip frlflip fnmflip ethflip sethflip pf_flip phfflip spoflip 
        citflip natflip mnvflip fnvflip pwtflip pwmflip cspflip rnwflip 
        pynflip wkwflip lkwflip wynflip eynflip ervflip wsvflip pearnflip;
      by ph_seq;
      if inper;
run;

/******************************************************************************/
/* Identify households that are unmarried partner, posslq, or pssslq hhlds    */
/******************************************************************************/

/***************************************************/
/*                                                 */
/*       sorting the person file extract           */
/*                                                 */
/***************************************************/

proc sort data=addtrns force;
     by id id2;
run;

data library.cps07max;
set addtrns;
run;

proc contents data=library.cps07max varnum;
run;

proc freq data=library.cps07max;
  weight marsupwt;
  tables p_stat a_exprrp hhdfmx /format=best10 nopercent;
  tables pedadtyp*pemomtyp /format=best10;
  where hhdfmx ne 51;
%include "/home/field005/2007cpstabs/pubuse2007/formata.fmt";
run;

endsas;


