

/*------------------------------------------------
  by Jean Roth	Tue Aug 28 11:09:27 EDT 2007
  Report errors to jroth@nber.org
  This program is distributed under the GNU GPL.
  See end of this file and
  http://www.gnu.org/licenses/ for details.
 ----------------------------------------------- */


*  The following line should contain the directory
   where the SAS file is to be stored  ;

libname library "/home/field005/2007cpstabs/pubuse2007/data";

*  The following line should contain
   the complete path and name of the raw data file.
   On a PC, use backslashes in paths as in C:\	 ;

filename datafile "/home/field005/2007cpstabs/pubuse2007/cpsmar07.dat";

*  The following line should contain the name of the SAS dataset ;

%let dataset = cpsmar07 ;

/*------------------------------------------------

   The raw data ( as described in the 
   'File Structure' section of the 'Overview' in
   the PDF documentation )  is a *long-shape* , 
   hierarchical data file with three record types:  
   household, family, and person.
   This program produces a *wide-shape* data set 
   of person records with their respective 
   household and family variables appended.

 ----------------------------------------------- */

DATA library.&dataset ;

INFILE datafile LRECL = 2300 ;

/*----------------------------------------------*/

*options nocenter ;
*options compress=yes;
*Choose compress=yes to save space ;
*Choose compress=no if converting to another package using transfer software ;
options nocenter nodate nonumber source symbolgen compress=yes;
options pagesize=59 linesize=72;

/*----------------------------------------------

   A -1 means Blank; Not in Universe; or In Universe, Met No Conditions;
   Sometimes, -1 is present but not described in the codebook.
   If the variable has a decimal, it will be resolved as -1/# of decimals.
   These are usually 'Not in Universe' values also.

   The following changes in variable names have been made, if necessary:
	'$' to 'd';		'-' to '_';	     '%' to 'p';
	($ = unedited data;	- = edited data;     % = allocated data)

  ----------------------------------------------*/


RETAIN

hrecord
h_seq
hhpos
hunits
hufaminc
h_respnm
h_year
h_hhtype
h_numper
hnumfam
h_type
h_month
h_mis
h_hhnum
h_livqrt
h_typebc
h_tenure
h_telhhd
h_telavl
h_telint
gereg
gestcen
gestfips
gtcbsa
gtco
gtcbsast
gtmetsta
gtindvpc
gtcbsasz
gtcsa
hunder15
hcmcare
hcmceno
hchi
hchino
hchinrh
hchinno
hh5to18
hhotlun
hhotno
hflunch
hflunno
hpublic
hlorent
hfoodsp
hfoodno
hfoodmo
hfdval
hengast
hengval
hinc_ws
hwsval
hinc_se
hseval
hinc_fr
hfrval
hinc_uc
hucval
hinc_wc
hwcval
hss_yn
hssval
hssi_yn
hssival
hpaw_yn
hpawval
hvet_yn
hvetval
hsur_yn
hsurval
hdis_yn
hdisval
hret_yn
hretval
hint_yn
hintval
hdiv_yn
hdivval
hrnt_yn
hrntval
hed_yn
hedval
hcsp_yn
hcspval
halm_yn
halmval
hfin_yn
hfinval
hoi_yn
hoival
htotval
hearnval
hothval
hhinc
hmcare
hmcaid
hchamp
hhi_yn
hhstatus
hunder18
htop5pct
hpctcut
hsup_wgt
h1tenure
h1livqrt
h1telhhd
h1telavl
h1telint
i_hhotlu
i_hhotno
i_hflunc
i_hflunn
i_hpubli
i_hloren
i_hfoods
i_hfdval
i_hfoodn
i_hfoodm
i_hengas
i_hengva
h_idnum2
prop_tax
housret
hrhtype
h_idnum1
i_hunits
hrtayn
hrnumta
hrccayn
hrnumcc
hrpaidcc
hrcmsryn
hrjcyn
hrjryn
hrjtyn
hrnumcsv
hrnumjc
hrnumjr
hrnumjt
hrnumsc
hrnumwic
hrschlyn
hrwicyn
frecord
fh_seq
ffpos
fkind
ftype
fpersons
fheadidx
fwifeidx
fhusbidx
fspouidx
flastidx
fmlasidx
fownu6
fownu18
frelu6
frelu18
fpctcut
fpovcut
famlis
povll
frspov
frsppct
finc_ws
fwsval
finc_se
fseval
finc_fr
ffrval
finc_uc
fucval
finc_wc
fwcval
finc_ss
fssval
finc_ssi
fssival
finc_paw
fpawval
finc_vet
fvetval
finc_sur
fsurval
finc_dis
fdisval
finc_ret
fretval
finc_int
fintval
finc_div
fdivval
finc_rnt
frntval
finc_ed
fedval
finc_csp
fcspval
finc_alm
falmval
finc_fin
ffinval
finc_oi
foival
ftotval
fearnval
fothval
ftot_r
fspanish
fsup_wgt
ffposold
f_mv_fs
f_mv_sl
ffngcare
ffngcaid
fhoussub
ffoodreq
fhousreq
;

attrib  hrecord      length=3     label="";                                     
attrib  h_seq        length=4     label="Household sequence number";            
attrib  hhpos        length=3     label="Trailer portion of unique household";  
attrib  hunits       length=3     label="Item 78 - How many units in the";      
attrib  hufaminc     length=3     label="Family income";                        
attrib  h_respnm     length=3     label="Line number of household";             
attrib  h_year       length=4     label="Year of survey";                       
attrib  h_hhtype     length=3     label="Type of household";                    
attrib  h_numper     length=3     label="Number of persons in household";       
attrib  hnumfam      length=3     label="Number of families in household";      
attrib  h_type       length=3     label="Household type";                       
attrib  h_month      length=3     label="Month of survey";                      
attrib  h_mis        length=3     label="Month in sample";                      
attrib  h_hhnum      length=3     label="Household number";                     
attrib  h_livqrt     length=3     label="Item 4 - Type of living quarters (";   
attrib  h_typebc     length=3     label="Item 15 - Type B/C";                   
attrib  h_tenure     length=3     label="Tenure";                               
attrib  h_telhhd     length=3     label="Telephone in household";               
attrib  h_telavl     length=3     label="Telephone available";                  
attrib  h_telint     length=3     label="Telephone interview acceptable";       
attrib  gereg        length=3     label="Region";                               
attrib  gestcen      length=3     label="1960 Census State Code";               
attrib  gestfips     length=3     label="State FIPS code";                      
attrib  gtcbsa       length=4     label="Metropolitan CBSA FIPS CODE";          
attrib  gtco         length=3     label="FIPS County Code";                     
attrib  gtcbsast     length=3     label="Principal city/Balance status";        
attrib  gtmetsta     length=3     label="Metropolitan status";                  
attrib  gtindvpc     length=3     label="Individual Pricipal City Code";        
attrib  gtcbsasz     length=3     label="Metropolitan area (CBSA) size";        
attrib  gtcsa        length=3     label="Consolidated Statistical Area (CSA)";  
attrib  hunder15     length=3     label="Recode";                               
attrib  hcmcare      length=3     label="Item 80 - During 20.. how many of the";
attrib  hcmceno      length=3     label="Item 80 - Number of children in";      
attrib  hchi         length=3     label="Item 81 - during 20.. how";            
attrib  hchino       length=3     label="Item 81 - Number of";                  
attrib  hchinrh      length=3     label="Item 81a - During 20.. how many of the";
attrib  hchinno      length=3     label="Item 81a - During 20..";               
attrib  hh5to18      length=3     label="Recode";                               
attrib  hhotlun      length=3     label="Item 83 - During 20.. how many of the";
attrib  hhotno       length=3     label="Item 83 - Number of children in";      
attrib  hflunch      length=3     label="Item 86 - During 20.. how many of the";
attrib  hflunno      length=3     label="Item 86 - Number receiving free lunch";
attrib  hpublic      length=3     label="Item 88 - Is this a public housing";   
attrib  hlorent      length=3     label="Item 89 - Are you paying lower rent";  
attrib  hfoodsp      length=3     label="Item 90 - Did anyone in this household";
attrib  hfoodno      length=3     label="Item 91 - Number of children covered"; 
attrib  hfoodmo      length=3     label="Item 92 - Number months covered by";   
attrib  hfdval       length=4     label="Item 93 - What was the value of all";  
attrib  hengast      length=3     label="Item 94 - Since october 1, 20.., has"; 
attrib  hengval      length=4     label="Item 95 - Altogether, how much energy";
attrib  hinc_ws      length=3     label="Recode - Wage and Salary";             
attrib  hwsval       length=5     label="Recode - HHLD income - Wages and";     
attrib  hinc_se      length=3     label="";                                     
attrib  hseval       length=5     label="Recode - HHLD income - self employment";
attrib  hinc_fr      length=3     label="Recode - Farm self-employment";        
attrib  hfrval       length=5     label="Recode - HHLD income - Farm income";   
attrib  hinc_uc      length=3     label="Recode - Unemployment compensation";   
attrib  hucval       length=5     label="Recode - HHLD income - Unemployment";  
attrib  hinc_wc      length=3     label="Recode - Worker's compensation";       
attrib  hwcval       length=5     label="Recode - HHLD income - Worker's";      
attrib  hss_yn       length=3     label="Recode - Social Security payments";    
attrib  hssval       length=5     label="Recode - HHLD income - Social Security";
attrib  hssi_yn      length=3     label="Recode - Supplemental Security benefit";
attrib  hssival      length=4     label="Recode - HHLD income - Supplemental";  
attrib  hpaw_yn      length=3     label="Recode - Public Assistance";           
attrib  hpawval      length=4     label="Recode - HHLD income - Public";        
attrib  hvet_yn      length=3     label="Recode - Veterans' Payments";          
attrib  hvetval      length=5     label="Recode - HHLD income - Veteran Payment";
attrib  hsur_yn      length=3     label="Recode - Survivor Benefits";           
attrib  hsurval      length=5     label="Recode - HHLD income - survivor income";
attrib  hdis_yn      length=3     label="Recode - Disability benefits";         
attrib  hdisval      length=5     label="Recode - HHLD income - Disability inco";
attrib  hret_yn      length=3     label="";                                     
attrib  hretval      length=5     label="Recode - HHLD income - Retirement";    
attrib  hint_yn      length=3     label="Recode -interest payments";            
attrib  hintval      length=5     label="Recode - HHLD income - Interest income";
attrib  hdiv_yn      length=3     label="Recode - Dividend payments";           
attrib  hdivval      length=5     label="Recode - HHLD income - dividend income";
attrib  hrnt_yn      length=3     label="Recode - Rental payments";             
attrib  hrntval      length=5     label="Recode - HHLD income - Rent income";   
attrib  hed_yn       length=3     label="Recode - Educational assistance";      
attrib  hedval       length=5     label="Recode - HHLD income - Education incom";
attrib  hcsp_yn      length=3     label="Recode - Child support payments";      
attrib  hcspval      length=5     label="Recode - HHLD income - child support"; 
attrib  halm_yn      length=3     label="Recode - Alimony payments";            
attrib  halmval      length=5     label="Recode - HHLD income - alimony";       
attrib  hfin_yn      length=3     label="Recode - Financial assistance payments";
attrib  hfinval      length=5     label="Recode - HHLD income - Financial";     
attrib  hoi_yn       length=3     label="Other income payments";                
attrib  hoival       length=5     label="Recode - HHLD income - Other income";  
attrib  htotval      length=5     label="Recode - Total household income";      
attrib  hearnval     length=5     label="Recode - Total household earnings";    
attrib  hothval      length=5     label="All other types of income except";     
attrib  hhinc        length=3     label="";                                     
attrib  hmcare       length=3     label="Anyone in HHLD covered by Medicare";   
attrib  hmcaid       length=3     label="Anyone in HHLD covered by Medicaid";   
attrib  hchamp       length=3     label="CHAMPUS, VA, or military health care"; 
attrib  hhi_yn       length=3     label="Anyone in HHLD have health insurance"; 
attrib  hhstatus     length=3     label="Recode - Household status";            
attrib  hunder18     length=3     label="Recode - Number of persons in HHLD";   
attrib  htop5pct     length=3     label="Recode - Household income percentiles";
attrib  hpctcut      length=3     label="Recode - HHLD income percentiles -";   
attrib  hsup_wgt     length=8     label="Final weight (2 implied decimal places";
attrib  h1tenure     length=3     label="";                                     
attrib  h1livqrt     length=3     label="";                                     
attrib  h1telhhd     length=3     label="";                                     
attrib  h1telavl     length=3     label="";                                     
attrib  h1telint     length=3     label="";                                     
attrib  i_hhotlu     length=3     label="";                                     
attrib  i_hhotno     length=3     label="";                                     
attrib  i_hflunc     length=3     label="";                                     
attrib  i_hflunn     length=3     label="";                                     
attrib  i_hpubli     length=3     label="";                                     
attrib  i_hloren     length=3     label="";                                     
attrib  i_hfoods     length=3     label="";                                     
attrib  i_hfdval     length=3     label="";                                     
attrib  i_hfoodn     length=3     label="";                                     
attrib  i_hfoodm     length=3     label="";                                     
attrib  i_hengas     length=3     label="";                                     
attrib  i_hengva     length=3     label="";                                     
attrib  h_idnum2     length=$5    label="Second part of household id number.";  
attrib  prop_tax     length=4     label="Annual property taxes";                
attrib  housret      length=4     label="Return to home equity";                
attrib  hrhtype      length=3     label="Household type";                       
attrib  h_idnum1     length=$15   label="First part of household id number.  Sa";
attrib  i_hunits     length=3     label="Allocation flag for HUNITS";           
attrib  hrtayn       length=3     label="AT ANY TIME DURING 20.. DID";          
attrib  hrnumta      length=3     label="NUMBER OF PEOPLE IN THIS HOUSEHOLD";   
attrib  hrccayn      length=3     label="AT ANY TIME DURING 20.. DID";          
attrib  hrnumcc      length=3     label="NUMBER OF PEOPLE IN THIS HOUSEHOLD";   
attrib  hrpaidcc     length=3     label="DID (YOU/ANYONE IN THIS HOUSEHOLD) PAY";
attrib  hrcmsryn     length=3     label="AT ANY TIME LAST YEAR, DID (YOU/ANYONE";
attrib  hrjcyn       length=3     label="AT ANY TIME LAST YEAR, DID (YOU/ANYONE";
attrib  hrjryn       length=3     label="AT ANY TIME LAST YEAR, DID (YOU/ANYONE";
attrib  hrjtyn       length=3     label="AT ANY TIME LAST YEAR, DID (YOU/ANYONE";
attrib  hrnumcsv     length=3     label="NUMBER OF PEOPLE IN THE HOUSEHOLD";    
attrib  hrnumjc      length=3     label="NUMBER OF PEOPLE IN THE HOUSEHOLD";    
attrib  hrnumjr      length=3     label="NUMBER OF PEOPLE IN THE HOUSEHOLD WHO";
attrib  hrnumjt      length=3     label="NUMBER OF PEOPLE IN THE HOUSEHOLD WHO";
attrib  hrnumsc      length=3     label="NUMBER OF PEOPLE IN THE HOUSEHOLD WHO";
attrib  hrnumwic     length=3     label="NUMBER OF PEOPLE IN THE HOUSEHOLD";    
attrib  hrschlyn     length=3     label="AT ANY TIME LAST YEAR, DID (YOU/ANYONE";
attrib  hrwicyn      length=3     label="AT ANY TIME LAST YEAR, (WERE YOU/WAS"; 
attrib  frecord      length=3     label="";                                     
attrib  fh_seq       length=4     label="Household sequence number";            
attrib  ffpos        length=3     label="Unique family identifier";             
attrib  fkind        length=3     label="Kind of family";                       
attrib  ftype        length=3     label="Family type";                          
attrib  fpersons     length=3     label="Number of persons in family";          
attrib  fheadidx     length=3     label="Index to person record of family head";
attrib  fwifeidx     length=3     label="Index to person record of family wife";
attrib  fhusbidx     length=3     label="Index to person record of family";     
attrib  fspouidx     length=3     label="Index to person record of family spous";
attrib  flastidx     length=3     label="Index to person record of last";       
attrib  fmlasidx     length=3     label="Index to person record of last";       
attrib  fownu6       length=3     label="Own children in family under 6";       
attrib  fownu18      length=3     label="Number of own never married children"; 
attrib  frelu6       length=3     label="Related persons in family under 6";    
attrib  frelu18      length=3     label="Related persons in family under 18";   
attrib  fpctcut      length=3     label="Income percentiles";                   
attrib  fpovcut      length=4     label="Low income cutoff dollar amount";      
attrib  famlis       length=3     label="Ratio of family income to low-income"; 
attrib  povll        length=3     label="Ratio of family income to low-income"; 
attrib  frspov       length=3     label="Ratio of related subfamily income to"; 
attrib  frsppct      length=4     label="Low income cutoff dollar amount of";   
attrib  finc_ws      length=3     label="Wage and salary";                      
attrib  fwsval       length=5     label="Family income - wages and salaries";   
attrib  finc_se      length=3     label="Own business self-employment";         
attrib  fseval       length=5     label="Family income - self employment income";
attrib  finc_fr      length=3     label="Farm self-employment";                 
attrib  ffrval       length=5     label="Family income - Farm income";          
attrib  finc_uc      length=3     label="Unemployment compensation";            
attrib  fucval       length=5     label="Family income - Unemployment";         
attrib  finc_wc      length=3     label="Worker's compensation";                
attrib  fwcval       length=5     label="Family income - Worker's compensation";
attrib  finc_ss      length=3     label="Social Security Benefits";             
attrib  fssval       length=5     label="Family income - Social Security";      
attrib  finc_ssi     length=3     label="Supplemental Security Benefits";       
attrib  fssival      length=4     label="Family income - Supplemental Security";
attrib  finc_paw     length=3     label="Public assistance or welfare benefits";
attrib  fpawval      length=4     label="Family income - public assistance";    
attrib  finc_vet     length=3     label="Veterans' Benefits";                   
attrib  fvetval      length=5     label="Family income - veteran payments";     
attrib  finc_sur     length=3     label="Survivor's payments";                  
attrib  fsurval      length=5     label="Family income - Survivor income";      
attrib  finc_dis     length=3     label="Disability payments";                  
attrib  fdisval      length=5     label="Family income - Disability income";    
attrib  finc_ret     length=3     label="Retirement payments";                  
attrib  fretval      length=5     label="Family income - Retirement income";    
attrib  finc_int     length=3     label="Interest payments";                    
attrib  fintval      length=5     label="Family income - Interest income";      
attrib  finc_div     length=3     label="Dividend payments";                    
attrib  fdivval      length=5     label="Family income - Dividend income";      
attrib  finc_rnt     length=3     label="Rental payments";                      
attrib  frntval      length=5     label="Family income - Rental income";        
attrib  finc_ed      length=3     label="Education benefits";                   
attrib  fedval       length=5     label="Family income - Education income";     
attrib  finc_csp     length=3     label="Child support payments";               
attrib  fcspval      length=5     label="Family income - Child support";        
attrib  finc_alm     length=3     label="Alimony payments";                     
attrib  falmval      length=5     label="Family income - Alimony";              
attrib  finc_fin     length=3     label="Financial assistance payments";        
attrib  ffinval      length=5     label="Family income - Financial assistance"; 
attrib  finc_oi      length=3     label="Other income payments";                
attrib  foival       length=5     label="Family income - Other income";         
attrib  ftotval      length=5     label="Total family income";                  
attrib  fearnval     length=5     label="Total family earnings";                
attrib  fothval      length=5     label="Total other family income";            
attrib  ftot_r       length=3     label="Total family income recode";           
attrib  fspanish     length=3     label="Reference person or spouse of Spanish";
attrib  fsup_wgt     length=8     label="Householder or reference person weight";
attrib  ffposold     length=3     label="Trailer portion of unique household ID";
attrib  f_mv_fs      length=4     label="Family market value of food stamps";   
attrib  f_mv_sl      length=4     label="Family market value of school lunch";  
attrib  ffngcare     length=4     label="Family fungible value of medicare";    
attrib  ffngcaid     length=4     label="Family fungible value of medicaid";    
attrib  fhoussub     length=3     label="Family market value of housing subsidy";
attrib  ffoodreq     length=4     label="Based on USDA figures";                
attrib  fhousreq     length=4     label="Used to compute fungible value of";    
attrib  precord      length=3     label="";                                     
attrib  ph_seq       length=4     label="Household seq number";                 
attrib  pppos        length=3     label="Trailer portion of unique household ID";
attrib  a_lineno     length=3     label="Item 18a - Line number";               
attrib  a_parent     length=3     label="Item 18c - Parent's line number";      
attrib  a_exprrp     length=3     label="Expanded relationship code";           
attrib  a_age        length=3     label="Item 18d - Age";                       
attrib  a_maritl     length=3     label="Item 18e - Marital status";            
attrib  a_spouse     length=3     label="Item 18f - Spouse's line number";      
attrib  a_sex        length=3     label="Item 18g - Sex";                       
attrib  a_hga        length=3     label="Item 18h - Educational attainment";    
attrib  prdtrace     length=3     label="Race";                                 
attrib  p_stat       length=3     label="Status of person identifier";          
attrib  pehspnon     length=3     label="Are you Spanish, Hispanic, or Latino?";
attrib  prdthsp      length=3     label="Detailed Hispanic recode";             
attrib  a_famnum     length=3     label="Family number";                        
attrib  a_famtyp     length=3     label="Family type";                          
attrib  a_famrel     length=3     label="Family relationship";                  
attrib  a_pfrel      length=3     label="Primary family relationship";          
attrib  hhdrel       length=3     label="Detailed household summary";           
attrib  famrel       length=3     label="Family relationship";                  
attrib  hhdfmx       length=3     label="Detailed household and family status"; 
attrib  parent       length=3     label="Family members under 18 (excludes";    
attrib  age1         length=3     label="Age recode - Persons 15+ years";       
attrib  phf_seq      length=3     label="Pointer to the sequence number of own";
attrib  pf_seq       length=3     label="Pointer to the sequence number of fami";
attrib  prnt_ptr     length=3     label="Sequence number of parent in hhld";    
attrib  a_fnlwgt     length=8     label="Final weight (2 implied decimal places";
attrib  a_ernlwt     length=8     label="Earnings/not in labor force weight";   
attrib  marsupwt     length=8     label="Supplement final weight (2 implied";   
attrib  a_hrs1       length=3     label="How many hrs did ... work last week";  
attrib  a_uslft      length=3     label="Does ... usually work 35 hrs or more a";
attrib  a_whyabs     length=3     label="Why was ... absent from work last week";
attrib  a_payabs     length=3     label="Is ... receiving wages or salary for"; 
attrib  peioind      length=4     label="Industry";                             
attrib  peioocc      length=4     label="Occupation";                           
attrib  a_wkslk      length=3     label="Duration of unemployment";             
attrib  a_whenlj     length=3     label="When did ... last work?";              
attrib  a_clswkr     length=3     label="Class of worker";                      
attrib  ppposold     length=3     label="Trailer portion of unique household id";
attrib  a_nlflj      length=3     label="When did ... last work for pay at a";  
attrib  a_wantjb     length=3     label="Does ... want a regular job now,";     
attrib  peafever     length=3     label="Did you ever serve on active duty in"; 
attrib  peafwhn1     length=3     label="When did you serve?";                  
attrib  peafwhn2     length=3     label="When did you serve?";                  
attrib  peafwhn3     length=3     label="When did you serve?";                  
attrib  peafwhn4     length=3     label="When did you serve?";                  
attrib  a_uslhrs     length=3     label="How many hrs per week does ...";       
attrib  a_hrlywk     length=3     label="Is ... paid by the hour on this job?"; 
attrib  a_hrspay     length=8     label="How much does ... earn per hour?";     
attrib  a_grswk      length=4     label="How much does ... usually earn per";   
attrib  a_unmem      length=3     label="On this job, is ... a member of a";    
attrib  a_uncov      length=3     label="On this job, is ... covered by a union";
attrib  a_enrlw      length=3     label="Last week was ... attending or";       
attrib  a_hscol      length=3     label="";                                     
attrib  a_ftpt       length=3     label="Is ... enrolled in school as a full-"; 
attrib  a_lfsr       length=3     label="Labor force status recode";            
attrib  a_untype     length=3     label="Reason for unemployment";              
attrib  a_wkstat     length=3     label="Full/part-time status";                
attrib  a_explf      length=3     label="Experienced labor force employment";   
attrib  a_wksch      length=3     label="Labor force by time worked or lost";   
attrib  a_civlf      length=3     label="Civilian labor force";                 
attrib  a_ftlf       length=3     label="Full/time labor force";                
attrib  a_mjind      length=3     label="Major industry code";                  
attrib  a_dtind      length=3     label="Detailed industry recode";             
attrib  mjocc        length=3     label="Major occupation recode";              
attrib  a_dtocc      length=3     label="Detailed occupation recode";           
attrib  prerelg      length=3     label="Earnings eligibility flag";            
attrib  workyn       length=3     label="Item 29a - Did ... work at a job or";  
attrib  wtemp        length=3     label="Item 29b - Did ... do any temporary,"; 
attrib  nwlook       length=3     label="Item 30 - Even though ... did not work";
attrib  nwlkwk       length=3     label="Item 31 - How may different weeks";    
attrib  rsnnotw      length=3     label="Item 32 - What was the main";          
attrib  wkswork      length=3     label="Item 33 - During 20.. in how many week";
attrib  wkcheck      length=3     label="Item 34 - Interviewer check item -";   
attrib  losewks      length=3     label="Item 35 Did ... lose any full weeks of";
attrib  lknone       length=3     label="Item 36 -  You said... worked about";  
attrib  lkweeks      length=3     label="Item 36 - Weeks was ... looking for";  
attrib  lkstrch      length=3     label="Item 37 - Were the (entry in item 36)";
attrib  pyrsn        length=3     label="Item 38 - What was the main reason ...";
attrib  phmemprs     length=3     label="Item 39 - For how many employers did .";
attrib  hrswk        length=3     label="Item 41 - In the weeks that ... worked";
attrib  hrcheck      length=3     label="Item 41 - Interviewer check item -";   
attrib  ptyn         length=3     label="Item 43 - Did ... work less than";     
attrib  ptweeks      length=3     label="Item 44 - How many weeks did ... work";
attrib  ptrsn        length=3     label="Item 45 - What was the main reason ...";
attrib  ljcw         length=3     label="Item 46e - Class of worker";           
attrib  wexp         length=3     label="Recode -  Worker/nonworker recode -";  
attrib  wewkrs       length=3     label="Recode -  Worker/nonworker recode -";  
attrib  welknw       length=3     label="Recode -  Worker/nonworker recode -";  
attrib  weuemp       length=3     label="Recode - Worker/nonworker recode - Par";
attrib  earner       length=3     label="Recode - Earner status";               
attrib  clwk         length=3     label="Recode - Longest job class of worker"; 
attrib  weclw        length=3     label="Recode - Longest job class of worker"; 
attrib  poccu2       length=3     label="Recode - Occupation of longest job by";
attrib  wemocg       length=3     label="Recode - Occupation of longest job by";
attrib  weind        length=3     label="Recode - Industry of longest job by";  
attrib  wemind       length=3     label="Recode - Industry of longest job by";  
attrib  mig_cbst     length=3     label="Item 55a - Metropolitan statistical ar";
attrib  migsame      length=3     label="Was ... living in this house (apt.) 1";
attrib  mig_reg      length=3     label="Recode - Region of previous residence";
attrib  mig_st       length=3     label="Recode - FIPS State code of previous"; 
attrib  mig_dscp     length=3     label="Recode - CBSA status of residence 1 ye";
attrib  gediv        length=3     label="Recode - Census division of current";  
attrib  mig_div      length=3     label="Recode - Census division of previous"; 
attrib  mig_mtr1     length=3     label="";                                     
attrib  mig_mtr3     length=3     label="";                                     
attrib  mig_mtr4     length=3     label="";                                     
attrib  noemp        length=3     label="Item 47 - Counting all locations where";
attrib  ern_yn       length=3     label="Earnings from longest job recode";     
attrib  ern_val      length=4     label="Item 48a &  b - How much did ... earn";
attrib  ern_srce     length=3     label="Earnings  recode";                     
attrib  ern_otr      length=3     label="Item 49a - Did ... earn money from oth";
attrib  wageotr      length=3     label="Item 49b -Other wage and salary earnin";
attrib  prswkxpns    length=4     label="Recode";                               
attrib  wsal_yn      length=3     label="Recode";                               
attrib  wsal_val     length=4     label="Recode - Total wage and salary earning";
attrib  seotr        length=3     label="Item 49b - Other work - Own business"; 
attrib  semp_yn      length=3     label="Recode - Any own business self-";      
attrib  semp_val     length=4     label="ERN-YN = 1 or SEOTR = 1";              
attrib  frmotr       length=3     label="Item 49b- Farm self-employment";       
attrib  frse_yn      length=3     label="Any own farm self-employment in ERN-YN";
attrib  frse_val     length=4     label="Recode - Total amount of farm self-";  
attrib  uc_yn        length=3     label="Item 52a - At any time during 20..";   
attrib  subuc        length=3     label="Item 52a - At any time during 20..";   
attrib  strkuc       length=3     label="Item 52a -At any time during 20..";    
attrib  uc_val       length=4     label="Item 52b - How much did ... receive in";
attrib  wc_yn        length=3     label="Item 53a - During 20.. did ... receive";
attrib  wc_type      length=3     label="Item 53b";                             
attrib  wc_val       length=4     label="Item 53c - How much compensation did"; 
attrib  ss_yn        length=3     label="Item 56b - Did ... receive s.s.?";     
attrib  ss_val       length=4     label="Item 56c - How much did ... receive in";
attrib  ssi_yn       length=3     label="Item 57b - Did ... receive SSI?";      
attrib  paw_yn       length=3     label="Item 59b - Did ... receive public";    
attrib  paw_typ      length=3     label="Item 59c - Did ... receive tanf/AFDC o";
attrib  paw_mon      length=3     label="Item 59d - In how many months of 20..";
attrib  paw_val      length=4     label="Item 59e - How much did ... receive in";
attrib  vet_yn       length=3     label="Item 60b - Did ... receive veterans'"; 
attrib  vet_typ1     length=3     label="Item 60c - Disability compensation";   
attrib  vet_typ2     length=3     label="Item 60c - Survivor benefits";         
attrib  vet_typ3     length=3     label="Item 60c - Veterans' pension";         
attrib  vet_typ4     length=3     label="Item 60c - Education assistance";      
attrib  vet_typ5     length=3     label="Item 60c - Other veterans' payments";  
attrib  vet_qva      length=3     label="Item 60d - Is ... required to fill out";
attrib  vet_val      length=4     label="Item 60e - How much did ... receive fr";
attrib  sur_yn       length=3     label="Item 61b - Other than social security";
attrib  sur_sc1      length=3     label="Item 61c - What was the source of this";
attrib  sur_sc2      length=3     label="Item 61d - Any other pension or";      
attrib  sur_val1     length=4     label="Item 61e - how much did ... receive fr";
attrib  sur_val2     length=4     label="Item 61g - How much did ... receive";  
attrib  srvs_val     length=4     label="Recode total amount of survivor's inco";
attrib  dis_hp       length=3     label="Item 62b -  Does ... have a health";   
attrib  dis_cs       length=3     label="Item 62c - Did ... retire or leave a j";
attrib  dis_yn       length=3     label="Item 64b - Other than social security ";
attrib  dis_sc1      length=3     label="Item 64c - What was the source of inco";
attrib  dis_sc2      length=3     label="Item 64c - Any other disability income";
attrib  dis_val1     length=4     label="Item 64e - How much did ... receive fr";
attrib  dis_val2     length=4     label="Item 64g - How much did ... receive fr";
attrib  dsab_val     length=4     label="Recode total amount of disability inco";
attrib  ret_yn       length=3     label="Item 65b - Other than social security";
attrib  ret_sc1      length=3     label="Item 65c - What was the source of";    
attrib  ret_sc2      length=3     label="Item 65c - Any other retirement income";
attrib  ret_val1     length=4     label="Item 65e - How much did ... receive fr";
attrib  ret_val2     length=4     label="Item 65g - How much did ... receive fr";
attrib  rtm_val      length=4     label="Recode total amount of retirement inco";
attrib  int_yn       length=3     label="Item 66b - Did... own any interest";   
attrib  int_val      length=4     label="Item 66c - How much did ... receive in";
attrib  div_yn       length=3     label="Item 67b - Did ... own any shares of"; 
attrib  div_non      length=3     label="Item 67c - No dividends received";     
attrib  div_val      length=4     label="Item 67c - How much did ... receive in";
attrib  rnt_yn       length=3     label="Item 68b - Did ... own any land,";     
attrib  rnt_val      length=4     label="Item 68c - How much did ... receive in";
attrib  ed_yn        length=3     label="Item 69c - Did ... receive educational";
attrib  oed_typ1     length=3     label="Item 69d(1) &  (2) - Source of";       
attrib  oed_typ2     length=3     label="Item 69d(3) - Source of educational";  
attrib  oed_typ3     length=3     label="Item 69d(4)- Source of educational";   
attrib  ed_val       length=4     label="Item 69h - Total amount of educational";
attrib  csp_yn       length=3     label="Item 70b - Did ... receive child suppo";
attrib  csp_val      length=4     label="Item 70c - How much did ... receive in";
attrib  alm_yn       length=3     label="Item 71b - Did .. rec'v alimony paymnt";
attrib  alm_val      length=4     label="Item 71c - How much did ... receive in";
attrib  fin_yn       length=3     label="Item 72b - Did ... receive financial"; 
attrib  fin_val      length=4     label="Item 72c - How much did ... receive in";
attrib  oi_off       length=3     label="Item 73c";                             
attrib  oi_yn        length=3     label="Item 73b - Did ... receive other incom";
attrib  oi_val       length=4     label="Item 73d - How much did ... receive in";
attrib  ptotval      length=5     label="Recode - Total persons income";        
attrib  pearnval     length=5     label="Recode - Total persons earnings";      
attrib  pothval      length=5     label="Recode - Total other persons income";  
attrib  fl_665       length=3     label="";                                     
attrib  ptot_r       length=3     label="Recode - Total person income recode";  
attrib  perlis       length=3     label="Recode - Low-income level of persons"; 
attrib  mcare        length=3     label="Item 74b - Was ... covered by medicare";
attrib  mcaid        length=3     label="Item 74d - Was ... covered by medicaid";
attrib  champ        length=3     label="Item 74f - Was ... covered by CHAMPUS,";
attrib  hi_yn        length=3     label="Item 75b - Was ... covered by private";
attrib  hiown        length=3     label="Item 75c - Was this health insurance"; 
attrib  hiemp        length=3     label="Item 75d - Was this health insurance"; 
attrib  hipaid       length=3     label="Item 75e - Did ...'s employer or union";
attrib  wrk_ck       length=3     label="Item 76 - Interviewer check item worke";
attrib  penplan      length=3     label="Item 76a - Other than social security";
attrib  penincl      length=3     label="Item 76b - Was ... included in that";  
attrib  cov_gh       length=3     label="Recode - Includes dependents included";
attrib  cov_hi       length=3     label="Recode - Includes dependents covered b";
attrib  ch_mc        length=3     label="A-AGE less than 15";                   
attrib  ch_hi        length=3     label="A-AGE less than 15";                   
attrib  a1rrp        length=3     label="Relationship to reference person";     
attrib  a1parent     length=3     label="Parent's line number allocation flag"; 
attrib  a1age        length=3     label="Age allocation flag";                  
attrib  a1maritl     length=3     label="Marital status allocation flag";       
attrib  a1spouse     length=3     label="Spouse's line number allocation flag"; 
attrib  a1sex        length=3     label="Sex allocation flag";                  
attrib  a1hga        length=3     label="Highest grade attended allocation flag";
attrib  a1lfsr       length=3     label="Labor force status recode allocation"; 
attrib  a1hrs        length=3     label="";                                     
attrib  pxafever     length=3     label="Allocation flag for PEAFEVER";         
attrib  pxafwhn1     length=3     label="Allocation flag for PEAFWHN1";         
attrib  a1whyabs     length=3     label="";                                     
attrib  a1payabs     length=3     label="";                                     
attrib  a1clswkr     length=3     label="";                                     
attrib  a1nlflj      length=3     label="";                                     
attrib  a1uslhrs     length=3     label="";                                     
attrib  a1hrlywk     length=3     label="";                                     
attrib  prwernal     length=3     label="";                                     
attrib  prhernal     length=3     label="";                                     
attrib  a1unmem      length=3     label="";                                     
attrib  a1uncov      length=3     label="";                                     
attrib  a1enrlw      length=3     label="";                                     
attrib  a1hscol      length=3     label="";                                     
attrib  a1ftpt       length=3     label="";                                     
attrib  i_ernyn      length=3     label="";                                     
attrib  i_ernval     length=3     label="";                                     
attrib  i_wsyn       length=3     label="";                                     
attrib  i_wsval      length=3     label="";                                     
attrib  i_seyn       length=3     label="";                                     
attrib  i_seval      length=3     label="";                                     
attrib  i_frmyn      length=3     label="";                                     
attrib  i_frmval     length=3     label="";                                     
attrib  i_ucyn       length=3     label="";                                     
attrib  i_ucval      length=3     label="";                                     
attrib  i_wcyn       length=3     label="";                                     
attrib  i_wctyp      length=3     label="";                                     
attrib  i_wcval      length=3     label="";                                     
attrib  i_ssyn       length=3     label="";                                     
attrib  i_ssval      length=3     label="";                                     
attrib  i_ssiyn      length=3     label="";                                     
attrib  i_ssival     length=3     label="";                                     
attrib  i_pawyn      length=3     label="";                                     
attrib  i_pawtyp     length=3     label="";                                     
attrib  i_pawval     length=3     label="";                                     
attrib  i_pawmo      length=3     label="";                                     
attrib  i_vetyn      length=3     label="";                                     
attrib  i_vettyp     length=3     label="";                                     
attrib  i_vetval     length=3     label="";                                     
attrib  i_vetqva     length=3     label="";                                     
attrib  i_suryn      length=3     label="";                                     
attrib  i_sursc1     length=3     label="";                                     
attrib  i_sursc2     length=3     label="";                                     
attrib  i_survl1     length=3     label="";                                     
attrib  i_survl2     length=3     label="";                                     
attrib  i_dissc1     length=3     label="";                                     
attrib  i_dissc2     length=3     label="";                                     
attrib  i_dishp      length=3     label="";                                     
attrib  i_discs      length=3     label="";                                     
attrib  i_disyn      length=3     label="";                                     
attrib  toi_val      length=3     label="Other income";                         
attrib  i_disvl1     length=3     label="";                                     
attrib  i_disvl2     length=3     label="";                                     
attrib  i_retyn      length=3     label="";                                     
attrib  i_retsc1     length=3     label="";                                     
attrib  i_retsc2     length=3     label="";                                     
attrib  i_retvl1     length=3     label="";                                     
attrib  i_retvl2     length=3     label="";                                     
attrib  i_intyn      length=3     label="";                                     
attrib  i_intval     length=3     label="";                                     
attrib  i_divyn      length=3     label="";                                     
attrib  i_divval     length=3     label="";                                     
attrib  i_rntyn      length=3     label="";                                     
attrib  i_rntval     length=3     label="";                                     
attrib  i_edyn       length=3     label="";                                     
attrib  i_edtyp1     length=3     label="";                                     
attrib  i_edtyp2     length=3     label="";                                     
attrib  i_oedval     length=3     label="";                                     
attrib  i_cspyn      length=3     label="";                                     
attrib  i_cspval     length=3     label="";                                     
attrib  i_almyn      length=3     label="";                                     
attrib  i_almval     length=3     label="";                                     
attrib  i_finyn      length=3     label="";                                     
attrib  i_finval     length=3     label="";                                     
attrib  i_oival      length=3     label="";                                     
attrib  i_nwlook     length=3     label="";                                     
attrib  i_nwlkwk     length=3     label="";                                     
attrib  i_rsnnot     length=3     label="";                                     
attrib  i_losewk     length=3     label="";                                     
attrib  i_lkweek     length=3     label="";                                     
attrib  i_lkstr      length=3     label="";                                     
attrib  i_pyrsn      length=3     label="";                                     
attrib  i_phmemp     length=3     label="";                                     
attrib  i_hrswk      length=3     label="";                                     
attrib  i_hrchk      length=3     label="";                                     
attrib  i_ptyn       length=3     label="";                                     
attrib  i_ptwks      length=3     label="";                                     
attrib  i_ptrsn      length=3     label="";                                     
attrib  i_ljcw       length=3     label="";                                     
attrib  i_indus      length=3     label="";                                     
attrib  i_occup      length=3     label="";                                     
attrib  i_workyn     length=3     label="";                                     
attrib  i_wtemp      length=3     label="";                                     
attrib  i_wkswk      length=3     label="";                                     
attrib  i_wkchk      length=3     label="";                                     
attrib  i_ernsrc     length=3     label="";                                     
attrib  i_noemp      length=3     label="";                                     
attrib  i_mig2       length=3     label="MIG-ST imputation flag.";              
attrib  i_penpla     length=3     label="";                                     
attrib  i_peninc     length=3     label="";                                     
attrib  i_mig1       length=3     label="MIGSAME imputation flag.";             
attrib  tcernval     length=3     label="Earnings from employer or self-";      
attrib  tcwsval      length=3     label="Wage and salary income topcoded flag"; 
attrib  tcseval      length=3     label="Nonfarm self employment income";       
attrib  tcffmval     length=3     label="Farm self employment income topcoded"; 
attrib  a_werntf     length=3     label="Current earnings - Weekly pay";        
attrib  a_herntf     length=3     label="Current earnings - Hourly pay";        
attrib  p_mvcare     length=4     label="Person market value of medicare";      
attrib  p_mvcaid     length=4     label="Person market value of medicaid";      
attrib  emcontrb     length=4     label="Employer contribution for health";     
attrib  filestat     length=3     label="Tax Filer status";                     
attrib  dep_stat     length=3     label="Dependency status pointer";            
attrib  ctc_crd      length=4     label="Child Tax Credit";                     
attrib  eit_cred     length=4     label="Earn income tax credit";               
attrib  actc_crd     length=4     label="Additional Child tax credit";          
attrib  fica         length=4     label="Social security retirement payroll";   
attrib  fed_ret      length=4     label="Federal retirement payroll deduction"; 
attrib  agi          length=4     label="Adjusted gross income";                
attrib  cap_gain     length=4     label="Amount of capital gains";              
attrib  cap_loss     length=4     label="Amount of capital losses";             
attrib  tax_inc      length=4     label="Taxable income amount";                
attrib  marg_tax     length=3     label="Federal Income Marginal tax rate";     
attrib  pemlr        length=3     label="Major labor force recode";             
attrib  pruntype     length=3     label="Reason for unemployment";              
attrib  prwkstat     length=3     label="Full/part-time work status";           
attrib  prptrea      length=3     label="Detailed reason for part-time";        
attrib  prdisc       length=3     label="Discouraged worker recode";            
attrib  prcow1       length=3     label="Class of worker recode-job 1";         
attrib  prpertyp     length=3     label="Type of person record recode";         
attrib  peabsrsn     length=3     label="What was the main reason...was absent";
attrib  peio1cow     length=3     label="Individual class of worker on first jo";
attrib  prnlfsch     length=3     label="NLF activity in school or not in schoo";
attrib  pehruslt     length=3     label="Hours usually worked last week";       
attrib  penatvty     length=3     label="In what country were you born?";       
attrib  pemntvty     length=3     label="In what country was your mother born?";
attrib  pefntvty     length=3     label="In what country was your father born?";
attrib  peinusyr     length=3     label="When did you come to the U.S. to stay?";
attrib  prcitshp     length=3     label="";                                     
attrib  pxnatvty     length=3     label="Allocation flag for PENATVTY";         
attrib  pxmntvty     length=3     label="Allocation flag for PEMNTVTY";         
attrib  pxfntvty     length=3     label="Allocation flag for PEFNTVTY";         
attrib  pxinusyr     length=3     label="Allocation flag for PEINUSYR";         
attrib  perrp        length=3     label="Expanded relationship categories";     
attrib  i_mig3       length=3     label="Imputation flag.";                     
attrib  hi           length=3     label="Covered by a health plan provided";    
attrib  hityp        length=3     label="Health insurance plan type.";          
attrib  dephi        length=3     label="Covered by a health plan through";     
attrib  hilin1       length=3     label="Line number of policyholder of health";
attrib  hilin2       length=3     label="Line number of policyholder of health";
attrib  paid         length=3     label="Did ...'s former or current employer o";
attrib  hiout        length=3     label="Employer or union plan covered someone";
attrib  priv         length=3     label="Covered by a plan that they purchased";
attrib  prityp       length=3     label="Private health insurance plan type.";  
attrib  depriv       length=3     label="Covered by private plan not related to";
attrib  pilin1       length=3     label="Line number of first policyholder of"; 
attrib  pilin2       length=3     label="Line number of second policyholder of";
attrib  pout         length=3     label="Private plan covered someone outside t";
attrib  out          length=3     label="Covered by the health plan of someone";
attrib  care         length=3     label="Covered by medicare, the health";      
attrib  caid         length=3     label="Covered by (medicaid/local name), the";
attrib  mon          length=3     label="Number of months covered by medicaid (";
attrib  oth          length=3     label="Covered by any other kind of health";  
attrib  otyp_1       length=3     label="Covered by TRICARE, CHAMPUS, or milita";
attrib  otyp_2       length=3     label="Covered by CHAMPVA.";                  
attrib  otyp_3       length=3     label="Covered by VA.";                       
attrib  otyp_4       length=3     label="Covered by Indian health.";            
attrib  otyp_5       length=3     label="Covered by other.";                    
attrib  othstper     length=3     label="Covered by other type of health";      
attrib  othstyp1     length=3     label="Other type of health insurance include";
attrib  othstyp2     length=3     label="";                                     
attrib  othstyp3     length=3     label="";                                     
attrib  othstyp4     length=3     label="";                                     
attrib  othstyp5     length=3     label="";                                     
attrib  othstyp6     length=3     label="";                                     
attrib  hea          length=3     label="Would you say ...'s health in general";
attrib  i_hi         length=3     label="Imputation item: HI";                  
attrib  i_dephi      length=3     label="Imputation item: DEPHI";               
attrib  i_paid       length=3     label="Imputation item: PAID";                
attrib  i_hiout      length=3     label="Imputation item: HIOUT";               
attrib  i_priv       length=3     label="Imputation item: PRIV";                
attrib  i_depriv     length=3     label="Imputation item: DEPRIV";              
attrib  i_pout       length=3     label="Imputation item: POUT";                
attrib  i_out        length=3     label="Imputation item: OUT";                 
attrib  i_care       length=3     label="Imputation item: CARE";                
attrib  i_caid       length=3     label="Imputation item: CAID";                
attrib  i_mon        length=3     label="Imputation item: MON";                 
attrib  i_oth        length=3     label="Imputation item: oth";                 
attrib  i_otyp       length=3     label="Imputation items: OTYP-1, ..., OTYP-5.";
attrib  i_ostper     length=3     label="Imputation item: OTHSTPER";            
attrib  i_ostyp      length=3     label="Imputation items: OTHSTYP1, ...,";     
attrib  i_hea        length=3     label="Imputation item: HEA";                 
attrib  ssi_val      length=4     label="Item 57c - How much did ... receive in";
attrib  ws_val       length=4     label="Item 49b - Other wage and salary";     
attrib  se_val       length=4     label="Item 49b - Other work - Own business"; 
attrib  ihsflg       length=3     label="Recode:  Covered by Indian Health";    
attrib  tsurval1     length=3     label="Survivors income, source 1,";          
attrib  tsurval2     length=3     label="Survivors income, source 2,";          
attrib  tdisval1     length=3     label="Disability income, source 1,";         
attrib  tdisval2     length=3     label="Disability income, source 2,";         
attrib  tretval1     length=3     label="Retirement income, source 1,";         
attrib  tretval2     length=3     label="Retirement income, source 2,";         
attrib  tint_val     length=3     label="Interest income";                      
attrib  tdiv_val     length=3     label="Dividend income";                      
attrib  trnt_val     length=3     label="Rent income";                          
attrib  ted_val      length=3     label="Education assistance";                 
attrib  tcsp_val     length=3     label="Child support payments";               
attrib  talm_val     length=3     label="Alimony payments";                     
attrib  tfin_val     length=3     label="Financial assistance";                 
attrib  nxtres       length=3     label="What was ... main reason for moving?"; 
attrib  i_nxtres     length=3     label="Imputation flag";                      
attrib  frm_val      length=4     label="Item 49b - Farm self-employment earnin";
attrib  tranyn       length=3     label="Received transportation assistance?";  
attrib  tranyna      length=3     label="TRANSPORTATION ASSISTANCE ALLOCATION"; 
attrib  ccayn        length=3     label="Receive child care services?";         
attrib  ccayna       length=3     label="Child care assistance allocation flag.";
attrib  paidccyn     length=3     label="Which children needed paid-care while";
attrib  paidcyna     length=3     label="PAIDCCYN allocation flag.";            
attrib  ahiper       length=3     label="Does person with no coverage reported";
attrib  iahiper      length=3     label="AHIPER allocation flag.";              
attrib  ahityp1      length=3     label="";                                     
attrib  ahityp2      length=3     label="";                                     
attrib  ahityp3      length=3     label="";                                     
attrib  ahityp4      length=3     label="";                                     
attrib  ahityp5      length=3     label="";                                     
attrib  ahityp6      length=3     label="What type of insurance (was/were)";    
attrib  iahityp      length=3     label="AHITYP allocation flag.";              
attrib  pchip        length=3     label="Was child under age 19 and with no";   
attrib  i_pchip      length=3     label="PCHIP allocation flag.";               
attrib  resnss1      length=3     label="What were the reasons (you/name)";     
attrib  resnss2      length=3     label="What were the reasons (you/name)";     
attrib  resnssa      length=3     label="RESNSS1-2 allocation flag";            
attrib  resnssi1     length=3     label="What were the reasons (you/name)";     
attrib  resnssi2     length=3     label="What were the reasons (you/name)";     
attrib  resnssia     length=3     label="RESNSSI1-2 allocation flag";           
attrib  ssikidyn     length=3     label="Which children under age 18 were";     
attrib  ssikdyna     length=3     label="SSIKIDYN allocation flag";             
attrib  sskidyn      length=3     label="Which children under age 19 were";     
attrib  sskidyna     length=3     label="SSKIDYN allocation flag";              
attrib  jcyn         length=3     label="Who attended a job search program or"; 
attrib  jcyna        length=3     label="JCYN allocation flag";                 
attrib  jryn         length=3     label="Who attended job readiness training to";
attrib  jryna        length=3     label="JRYN allocation flag";                 
attrib  jtyn         length=3     label="Who attended a training program to";   
attrib  jtyna        length=3     label="JTYN allocation flag";                 
attrib  schoolyn     length=3     label="Who attended GED classes or received"; 
attrib  scholyna     length=3     label="SCHOOLYN allocation flag";             
attrib  wicyn        length=3     label="Who received WIC?";                    
attrib  wicyna       length=3     label="WICYN allocation flag";                
attrib  comsrvyn     length=3     label="Who participated in work programs such";
attrib  cmsrvyna     length=3     label="COMSRVYN allocation flag";             
attrib  industry     length=4     label="Industry of longest job";              
attrib  occup        length=4     label="Occupation of longest job";            
attrib  peridnum     length=$22   label="22 digit Unique Person identifier";    
attrib  fedtax_bc    length=4     label="Federal income tax liability, before"; 
attrib  fedtax_ac    length=4     label="Federal income tax liability, after";  
attrib  statetax_bc  length=4     label="State income tax liability, before";   
attrib  statetax_ac  length=4     label="State income tax liability, after";    
attrib  pecohab      length=3     label="Demographics line number of cohabiting";
attrib  pelnmom      length=3     label="Demographics line number of Mother";   
attrib  pelndad      length=3     label="Demographics line number of Father";   
attrib  pemomtyp     length=3     label="Demographics type of Mother";          
attrib  pedadtyp     length=3     label="Demographics type of Father";          
attrib  pxcohab      length=3     label="Demographics allocation flag for PECOH";
attrib  pxlnmom      length=3     label="Demographics  Allocation flag for";    
attrib  pxlndad      length=3     label="Demographics  Allocation flag for";    
attrib  pxmomtyp     length=3     label="Demographics  Allocation flag for";    
attrib  pxdadtyp     length=3     label="Demographics  Allocation flag for";    


INPUT @1 rectype 1. @;        /* Hold the data line */
if rectype = 1 then do;       /* HOUSEHOLD RECORDS  */

INPUT
@1    hrecord          1. 
@2    h_seq            5. 
@7    hhpos            2. 
@9    hunits           1. 
@10   hufaminc         2. 
@12   h_respnm         2. 
@14   h_year           4. 
@20   h_hhtype         1. 
@21   h_numper         2. 
@23   hnumfam          2. 
@25   h_type           1. 
@26   h_month          2. 
@29   h_mis            1. 
@30   h_hhnum          1. 
@31   h_livqrt         2. 
@33   h_typebc         2. 
@35   h_tenure         1. 
@36   h_telhhd         1. 
@37   h_telavl         1. 
@38   h_telint         1. 
@39   gereg            1. 
@40   gestcen          2. 
@42   gestfips         2. 
@44   gtcbsa           5. 
@49   gtco             3. 
@52   gtcbsast         1. 
@53   gtmetsta         1. 
@54   gtindvpc         1. 
@55   gtcbsasz         1. 
@56   gtcsa            3. 
@60   hunder15         2. 
@62   hcmcare          1. 
@63   hcmceno          1. 
@64   hchi             1. 
@65   hchino           1. 
@66   hchinrh          1. 
@67   hchinno          1. 
@68   hh5to18          2. 
@70   hhotlun          1. 
@71   hhotno           1. 
@72   hflunch          1. 
@73   hflunno          1. 
@74   hpublic          1. 
@75   hlorent          1. 
@76   hfoodsp          1. 
@77   hfoodno          1. 
@79   hfoodmo          2. 
@81   hfdval           4. 
@85   hengast          1. 
@86   hengval          4. 
@90   hinc_ws          1. 
@91   hwsval           7. 
@98   hinc_se          1. 
@99   hseval           7. 
@106  hinc_fr          1. 
@107  hfrval           7. 
@114  hinc_uc          1. 
@115  hucval           7. 
@122  hinc_wc          1. 
@123  hwcval           7. 
@130  hss_yn           1. 
@131  hssval           7. 
@138  hssi_yn          1. 
@139  hssival          6. 
@145  hpaw_yn          1. 
@146  hpawval          6. 
@152  hvet_yn          1. 
@153  hvetval          7. 
@160  hsur_yn          1. 
@161  hsurval          7. 
@168  hdis_yn          1. 
@169  hdisval          7. 
@176  hret_yn          1. 
@177  hretval          7. 
@184  hint_yn          1. 
@185  hintval          7. 
@192  hdiv_yn          1. 
@193  hdivval          7. 
@200  hrnt_yn          1. 
@201  hrntval          7. 
@208  hed_yn           1. 
@209  hedval           7. 
@216  hcsp_yn          1. 
@217  hcspval          7. 
@224  halm_yn          1. 
@225  halmval          7. 
@232  hfin_yn          1. 
@233  hfinval          7. 
@240  hoi_yn           1. 
@241  hoival           7. 
@248  htotval          8. 
@256  hearnval         8. 
@264  hothval          8. 
@272  hhinc            2. 
@274  hmcare           1. 
@275  hmcaid           1. 
@276  hchamp           1. 
@277  hhi_yn           1. 
@278  hhstatus         1. 
@279  hunder18         2. 
@281  htop5pct         1. 
@282  hpctcut          2. 
@287  hsup_wgt        8.2 
@295  h1tenure         1. 
@297  h1livqrt         1. 
@299  h1telhhd         1. 
@300  h1telavl         1. 
@301  h1telint         1. 
@308  i_hhotlu         1. 
@309  i_hhotno         1. 
@310  i_hflunc         1. 
@311  i_hflunn         1. 
@312  i_hpubli         1. 
@313  i_hloren         1. 
@314  i_hfoods         1. 
@315  i_hfdval         1. 
@316  i_hfoodn         1. 
@317  i_hfoodm         1. 
@318  i_hengas         1. 
@319  i_hengva         1. 
@320  h_idnum2        $5. 
@332  prop_tax         5. 
@337  housret          5. 
@342  hrhtype          2. 
@344  h_idnum1       $15. 
@359  i_hunits         1. 
@361  hrtayn           1. 
@362  hrnumta          2. 
@364  hrccayn          1. 
@365  hrnumcc          2. 
@367  hrpaidcc         1. 
@369  hrcmsryn         1. 
@370  hrjcyn           1. 
@371  hrjryn           1. 
@372  hrjtyn           1. 
@373  hrnumcsv         2. 
@375  hrnumjc          2. 
@377  hrnumjr          2. 
@379  hrnumjt          2. 
@381  hrnumsc          2. 
@383  hrnumwic         2. 
@385  hrschlyn         1. 
@386  hrwicyn          1. 

;
end;
else if rectype = 2 then do;  /* FAMILY RECORDS */

INPUT
@1    frecord          1. 
@2    fh_seq           5. 
@7    ffpos            2. 
@9    fkind            1. 
@10   ftype            1. 
@11   fpersons         2. 
@13   fheadidx         2. 
@15   fwifeidx         2. 
@17   fhusbidx         2. 
@19   fspouidx         2. 
@21   flastidx         2. 
@23   fmlasidx         2. 
@25   fownu6           1. 
@27   fownu18          1. 
@28   frelu6           1. 
@29   frelu18          1. 
@30   fpctcut          2. 
@32   fpovcut          5. 
@37   famlis           1. 
@38   povll            2. 
@40   frspov           2. 
@42   frsppct          5. 
@47   finc_ws          1. 
@48   fwsval           7. 
@55   finc_se          1. 
@56   fseval           7. 
@63   finc_fr          1. 
@64   ffrval           7. 
@71   finc_uc          1. 
@72   fucval           7. 
@79   finc_wc          1. 
@80   fwcval           7. 
@87   finc_ss          1. 
@88   fssval           7. 
@95   finc_ssi         1. 
@96   fssival          6. 
@102  finc_paw         1. 
@103  fpawval          6. 
@109  finc_vet         1. 
@110  fvetval          7. 
@117  finc_sur         1. 
@118  fsurval          7. 
@125  finc_dis         1. 
@126  fdisval          7. 
@133  finc_ret         1. 
@134  fretval          7. 
@141  finc_int         1. 
@142  fintval          7. 
@149  finc_div         1. 
@150  fdivval          7. 
@157  finc_rnt         1. 
@158  frntval          7. 
@165  finc_ed          1. 
@166  fedval           7. 
@173  finc_csp         1. 
@174  fcspval          7. 
@181  finc_alm         1. 
@182  falmval          7. 
@189  finc_fin         1. 
@190  ffinval          7. 
@197  finc_oi          1. 
@198  foival           7. 
@205  ftotval          8. 
@213  fearnval         8. 
@221  fothval          8. 
@229  ftot_r           2. 
@231  fspanish         1. 
@233  fsup_wgt        8.2 
@241  ffposold         2. 
@243  f_mv_fs          4. 
@247  f_mv_sl          4. 
@251  ffngcare         5. 
@256  ffngcaid         5. 
@261  fhoussub         3. 
@264  ffoodreq         4. 
@268  fhousreq         4. 


;
end ;

else if rectype = 3 then do;  /* PERSON RECORDS */

INPUT
@1    precord          1. 
@2    ph_seq           5. 
@7    pppos            2. 
@9    a_lineno         2. 
@11   a_parent         2. 
@13   a_exprrp         2. 
@15   a_age            2. 
@17   a_maritl         1. 
@18   a_spouse         2. 
@20   a_sex            1. 
@22   a_hga            2. 
@24   prdtrace         2. 
@26   p_stat           1. 
@27   pehspnon         1. 
@28   prdthsp          1. 
@29   a_famnum         2. 
@31   a_famtyp         1. 
@32   a_famrel         1. 
@33   a_pfrel          1. 
@34   hhdrel           1. 
@35   famrel           2. 
@37   hhdfmx           2. 
@39   parent           1. 
@40   age1             2. 
@44   phf_seq          2. 
@46   pf_seq           2. 
@48   prnt_ptr         2. 
@50   a_fnlwgt        8.2 
@58   a_ernlwt        8.2 
@66   marsupwt        8.2 
@76   a_hrs1           2. 
@79   a_uslft          1. 
@85   a_whyabs         1. 
@86   a_payabs         1. 
@87   peioind          4. 
@91   peioocc          4. 
@96   a_wkslk          3. 
@102  a_whenlj         1. 
@109  a_clswkr         1. 
@110  ppposold         2. 
@112  a_nlflj          1. 
@114  a_wantjb         1. 
@118  peafever         2. 
@120  peafwhn1         2. 
@122  peafwhn2         2. 
@124  peafwhn3         2. 
@126  peafwhn4         2. 
@128  a_uslhrs         2. 
@130  a_hrlywk         1. 
@131  a_hrspay        4.2 
@135  a_grswk          4. 
@139  a_unmem          1. 
@140  a_uncov          1. 
@142  a_enrlw          1. 
@143  a_hscol          1. 
@144  a_ftpt           1. 
@145  a_lfsr           1. 
@146  a_untype         1. 
@149  a_wkstat         1. 
@150  a_explf          1. 
@151  a_wksch          1. 
@152  a_civlf          1. 
@153  a_ftlf           1. 
@155  a_mjind          2. 
@157  a_dtind          2. 
@159  mjocc            2. 
@161  a_dtocc          2. 
@163  prerelg          1. 
@165  workyn           1. 
@166  wtemp            1. 
@167  nwlook           1. 
@168  nwlkwk           2. 
@170  rsnnotw          1. 
@171  wkswork          2. 
@173  wkcheck          1. 
@174  losewks          1. 
@175  lknone           1. 
@176  lkweeks          2. 
@178  lkstrch          1. 
@179  pyrsn            1. 
@180  phmemprs         1. 
@181  hrswk            2. 
@183  hrcheck          1. 
@184  ptyn             1. 
@185  ptweeks          2. 
@187  ptrsn            1. 
@189  ljcw             1. 
@196  wexp             2. 
@198  wewkrs           1. 
@199  welknw           1. 
@200  weuemp           1. 
@201  earner           1. 
@202  clwk             1. 
@203  weclw            1. 
@204  poccu2           2. 
@206  wemocg           2. 
@208  weind            2. 
@210  wemind           2. 
@213  mig_cbst         1. 
@214  migsame          1. 
@215  mig_reg          1. 
@216  mig_st           2. 
@218  mig_dscp         1. 
@219  gediv            1. 
@220  mig_div          2. 
@222  mig_mtr1         2. 
@224  mig_mtr3         1. 
@225  mig_mtr4         1. 
@226  noemp            1. 
@227  ern_yn           1. 
@228  ern_val          6. 
@234  ern_srce         1. 
@235  ern_otr          1. 
@236  wageotr          1. 
@237  prswkxpns        4. 
@242  wsal_yn          1. 
@243  wsal_val         6. 
@249  seotr            1. 
@255  semp_yn          1. 
@256  semp_val         6. 
@262  frmotr           1. 
@268  frse_yn          1. 
@269  frse_val         6. 
@275  uc_yn            1. 
@276  subuc            1. 
@277  strkuc           1. 
@278  uc_val           5. 
@283  wc_yn            1. 
@284  wc_type          1. 
@285  wc_val           5. 
@290  ss_yn            1. 
@291  ss_val           5. 
@296  ssi_yn           1. 
@301  paw_yn           1. 
@302  paw_typ          1. 
@303  paw_mon          2. 
@305  paw_val          5. 
@310  vet_yn           1. 
@311  vet_typ1         1. 
@312  vet_typ2         1. 
@313  vet_typ3         1. 
@314  vet_typ4         1. 
@315  vet_typ5         1. 
@316  vet_qva          1. 
@317  vet_val          5. 
@322  sur_yn           1. 
@323  sur_sc1          2. 
@325  sur_sc2          2. 
@327  sur_val1         5. 
@332  sur_val2         5. 
@337  srvs_val         6. 
@343  dis_hp           1. 
@344  dis_cs           1. 
@345  dis_yn           1. 
@346  dis_sc1          2. 
@348  dis_sc2          2. 
@350  dis_val1         5. 
@355  dis_val2         5. 
@360  dsab_val         6. 
@366  ret_yn           1. 
@367  ret_sc1          1. 
@368  ret_sc2          1. 
@369  ret_val1         5. 
@374  ret_val2         5. 
@379  rtm_val          6. 
@385  int_yn           1. 
@386  int_val          5. 
@391  div_yn           1. 
@392  div_non          1. 
@393  div_val          5. 
@398  rnt_yn           1. 
@399  rnt_val          5. 
@404  ed_yn            1. 
@405  oed_typ1         1. 
@406  oed_typ2         1. 
@407  oed_typ3         1. 
@408  ed_val           5. 
@414  csp_yn           1. 
@415  csp_val          5. 
@420  alm_yn           1. 
@421  alm_val          5. 
@426  fin_yn           1. 
@427  fin_val          5. 
@432  oi_off           2. 
@434  oi_yn            1. 
@435  oi_val           5. 
@440  ptotval          8. 
@448  pearnval         8. 
@457  pothval          8. 
@465  fl_665           1. 
@466  ptot_r           2. 
@468  perlis           1. 
@469  mcare            1. 
@470  mcaid            1. 
@471  champ            1. 
@472  hi_yn            1. 
@473  hiown            1. 
@474  hiemp            1. 
@475  hipaid           1. 
@481  wrk_ck           1. 
@482  penplan          1. 
@483  penincl          1. 
@484  cov_gh           1. 
@485  cov_hi           1. 
@486  ch_mc            1. 
@487  ch_hi            1. 
@489  a1rrp            1. 
@490  a1parent         1. 
@491  a1age            1. 
@492  a1maritl         1. 
@493  a1spouse         1. 
@494  a1sex            1. 
@496  a1hga            1. 
@500  a1lfsr           1. 
@503  a1hrs            1. 
@506  pxafever         2. 
@508  pxafwhn1         2. 
@510  a1whyabs         1. 
@511  a1payabs         1. 
@523  a1clswkr         1. 
@526  a1nlflj          1. 
@532  a1uslhrs         1. 
@533  a1hrlywk         1. 
@534  prwernal         1. 
@535  prhernal         1. 
@536  a1unmem          1. 
@537  a1uncov          1. 
@539  a1enrlw          1. 
@540  a1hscol          1. 
@541  a1ftpt           1. 
@542  i_ernyn          1. 
@543  i_ernval         1. 
@544  i_wsyn           1. 
@545  i_wsval          1. 
@546  i_seyn           1. 
@547  i_seval          1. 
@548  i_frmyn          1. 
@549  i_frmval         1. 
@550  i_ucyn           1. 
@551  i_ucval          1. 
@552  i_wcyn           1. 
@553  i_wctyp          1. 
@554  i_wcval          1. 
@555  i_ssyn           1. 
@556  i_ssval          1. 
@557  i_ssiyn          1. 
@558  i_ssival         1. 
@559  i_pawyn          1. 
@560  i_pawtyp         1. 
@561  i_pawval         1. 
@562  i_pawmo          1. 
@563  i_vetyn          1. 
@564  i_vettyp         1. 
@565  i_vetval         1. 
@566  i_vetqva         1. 
@567  i_suryn          1. 
@569  i_sursc1         1. 
@570  i_sursc2         1. 
@571  i_survl1         1. 
@572  i_survl2         1. 
@573  i_dissc1         1. 
@574  i_dissc2         1. 
@575  i_dishp          1. 
@576  i_discs          1. 
@577  i_disyn          1. 
@578  toi_val          1. 
@579  i_disvl1         1. 
@580  i_disvl2         1. 
@581  i_retyn          1. 
@582  i_retsc1         1. 
@583  i_retsc2         1. 
@584  i_retvl1         1. 
@585  i_retvl2         1. 
@586  i_intyn          1. 
@587  i_intval         1. 
@588  i_divyn          1. 
@589  i_divval         1. 
@590  i_rntyn          1. 
@591  i_rntval         1. 
@592  i_edyn           1. 
@593  i_edtyp1         1. 
@594  i_edtyp2         1. 
@595  i_oedval         1. 
@596  i_cspyn          1. 
@597  i_cspval         1. 
@598  i_almyn          1. 
@599  i_almval         1. 
@600  i_finyn          1. 
@601  i_finval         1. 
@602  i_oival          1. 
@603  i_nwlook         1. 
@604  i_nwlkwk         1. 
@605  i_rsnnot         1. 
@606  i_losewk         1. 
@607  i_lkweek         1. 
@608  i_lkstr          1. 
@609  i_pyrsn          1. 
@610  i_phmemp         1. 
@611  i_hrswk          1. 
@612  i_hrchk          1. 
@613  i_ptyn           1. 
@614  i_ptwks          1. 
@615  i_ptrsn          1. 
@616  i_ljcw           1. 
@617  i_indus          1. 
@618  i_occup          1. 
@619  i_workyn         1. 
@620  i_wtemp          1. 
@621  i_wkswk          1. 
@622  i_wkchk          1. 
@623  i_ernsrc         1. 
@624  i_noemp          1. 
@631  i_mig2           2. 
@633  i_penpla         1. 
@634  i_peninc         1. 
@635  i_mig1           1. 
@637  tcernval         1. 
@638  tcwsval          1. 
@639  tcseval          1. 
@640  tcffmval         1. 
@641  a_werntf         1. 
@642  a_herntf         1. 
@643  p_mvcare         5. 
@648  p_mvcaid         5. 
@653  emcontrb         4. 
@657  filestat         1. 
@658  dep_stat         2. 
@660  ctc_crd          4. 
@665  eit_cred         4. 
@669  actc_crd         4. 
@674  fica             5. 
@679  fed_ret          5. 
@684  agi              5. 
@689  cap_gain         5. 
@694  cap_loss         4. 
@698  tax_inc          5. 
@703  marg_tax         2. 
@705  pemlr            1. 
@706  pruntype         1. 
@707  prwkstat         2. 
@709  prptrea          2. 
@711  prdisc           1. 
@712  prcow1           1. 
@713  prpertyp         1. 
@714  peabsrsn         2. 
@716  peio1cow         2. 
@718  prnlfsch         1. 
@719  pehruslt         3. 
@722  penatvty         3. 
@725  pemntvty         3. 
@728  pefntvty         3. 
@731  peinusyr         2. 
@733  prcitshp         1. 
@734  pxnatvty         2. 
@736  pxmntvty         2. 
@738  pxfntvty         2. 
@740  pxinusyr         2. 
@742  perrp            2. 
@747  i_mig3           1. 
@748  hi               1. 
@749  hityp            1. 
@750  dephi            1. 
@751  hilin1           2. 
@753  hilin2           2. 
@755  paid             1. 
@756  hiout            1. 
@757  priv             1. 
@758  prityp           1. 
@759  depriv           1. 
@760  pilin1           2. 
@762  pilin2           2. 
@764  pout             1. 
@765  out              1. 
@766  care             1. 
@767  caid             1. 
@768  mon              2. 
@770  oth              1. 
@771  otyp_1           1. 
@772  otyp_2           1. 
@773  otyp_3           1. 
@774  otyp_4           1. 
@775  otyp_5           1. 
@776  othstper         1. 
@777  othstyp1         2. 
@779  othstyp2         2. 
@781  othstyp3         2. 
@783  othstyp4         2. 
@785  othstyp5         2. 
@787  othstyp6         2. 
@800  hea              1. 
@801  i_hi             1. 
@802  i_dephi          1. 
@803  i_paid           1. 
@804  i_hiout          1. 
@805  i_priv           1. 
@806  i_depriv         1. 
@807  i_pout           1. 
@808  i_out            1. 
@809  i_care           1. 
@810  i_caid           1. 
@811  i_mon            1. 
@812  i_oth            1. 
@813  i_otyp           1. 
@814  i_ostper         1. 
@815  i_ostyp          1. 
@818  i_hea            1. 
@819  ssi_val          5. 
@824  ws_val           6. 
@830  se_val           6. 
@836  ihsflg           1. 
@837  tsurval1         1. 
@838  tsurval2         1. 
@839  tdisval1         1. 
@840  tdisval2         1. 
@841  tretval1         1. 
@842  tretval2         1. 
@843  tint_val         1. 
@844  tdiv_val         1. 
@845  trnt_val         1. 
@846  ted_val          1. 
@847  tcsp_val         1. 
@848  talm_val         1. 
@849  tfin_val         1. 
@8       1. 
      length=====00  heacyn         length===       13al      length=
@836  ihsriv       length=h===       in1       length=h===       i1        length=h===       i2a       length=h===       i3cyn     length=h===       i4yna     length=h===       i5r       length=h===       i6er      length=h===       i7p1      length=====00  heac_crd     length=====00  heap_1       length=====00  heap3p4      length=====00  heap5p5      length=====00  heap7p1      6ength=====00  heap9yp      length=h===       emprs     length=h===       e1ip      length=h===       e2s1      length=h===       e3s2      length=h===       e4sa      length=h===       e5si1     length=h===       e6si2     length=h===       e7sia     length=h===       e8dyn     length=h===       e9yna     length=h===       yn       length=h====       y1yna     length=====       y2        length=====       y3        length=====       y4        length=====       y5        length=====       y6        length=====       y7        length=====       y8lyn     length=====       y9yna     length=====      9emp  ic   length=h===      9i         length=h===      9i2vyn     length=h===      9i3yna     length=h===      9i4try     length=====0   hinc8        length=====0   hin12num     length=  $2    a_ltval c    length=====5   a_lt9x_ac    length=====5   a_lv_vax_bc  length======5   a_lv9tax_ac  length======5   a_l54ab      length=====    a_l56om      length=====    a_l58ad      length=====    a_lin1       length=====    a_li2typ     length=====    a_li4ab      length=====    a_li6om      length=====    a_li8ad      length=====    a_l70typ     length=====    a_l72typ     length=====    ase if   put
else ifdrope = 3 th;
end LABELend 	         5= usuaseof";   ques/weof Fat" length===== d 	          = uTreasor ;
alongestuerson huaseof";"== d 	        1.= ub - F78much dider k      in
attrh===== d 	          = uF   le, sourc" length===== length===== d 	          = umber of second huaseof";"== ength===== d 	          = uY    one"   ey" length===== length=====d 	          = uThealth iuaseof";"== ength===== th=====d 	          = uof months         in
iuaseof";"== engthd 	          = uof months     lie  in
iuaseof";"== engtd 	        1.= usuaseof";     " length===== length=====d 	          = uM     one"   ey" length===== length====d 	   i      = uM     o";
ampl " length===== length====d 	     lengt= usuaseof"; of Fat" length===== ength====d 	          = ub - F4mucThealth    gramquart    ("engtd 	      bc  = ub - FstyucThealB/C" length===== ength==d 	          = uT     " length===== length===== ength==d 	          = uT l       in
iuaseof";"== ength ength==d 	          = uT l       aveasabl " length===== lengthd 	          = uT l       int?"; ew acceptabl " length=d 	          = uReglon" length===== length===== ength==d 	          = u1lin1Census ncome C    gth===== ength==d 	          = uncome FIPS c    gth===== ength==ength==d 	          = uMetropo
attn CBSA FIPS CODE"th==ength==d 	       1. = uFIPS Cwas y C    gth===== ength==ngth==d 	      s   = uPr soips of   /Balas/we      "h==ngth==d 	          = uMetropo
attn       "h==ngth==th==ngth==d 	          = ubnd incus oPr oips oCi y C    gth===== d 	      sz  = uMetropo
attn a    (CBSA) siz  gth===== d 	    length= uC   o
ad workncomistie), A    (CSA)"== d 	          = uRec    gth===== ength==ength==gth===== d 	          = ub - Femp- Durgram20..
iudider kth attrhd 	         2= ub - Femp- of months n under ain"== engtd 	          = ub - Fe1p- durgram20..
iud" length===== d 	          = ub - Fe1p- of months" length===== lengthd 	          = ub - Fe1ap- Durgram20..
iudider kth attrd 	         2= ub - Fe1ap- Durgram20.."== ength ength==d 	          = uRec    gth===== ength==ength==gth===== d 	          = ub - Fe3p- Durgram20..
iudider kth attrhd 	        1.= ub - Fe3p- of months n under ain"== engtd 	          = ub - Fe6p- Durgram20..
iudider kth attrhd 	          = ub - Fe6p- of montd WIC?gramfree      rhd 	          = ub - Fe8mucIs ati  a        iuasattrengtd 	          = ub - Fe9mucA  y ...paygramlowontd nt"== d 	          = ub - F9mp- Didher     in
ati  iuaseof";"d 	          = ub - F91p- of months n under a by med"= d 	     m    = ub - F92p- of montcovered by medicarengtd 	        1.= ub - F93p- s ... maia li   ualth all"== d 	          = ub - F94mucSis/weoctomont1,m20.., has"= d 	         1= ub - F9tyucAltoge    ,
iudid ...;
agyrhd 	          = uRec   p- s salary"S     
gth==gth===== d 	         1= uRec   p- HHLD tax lia- s saslary"===== d 	         1= uRec   p- HHLD tax lia- ploy ent earnin"d 	          = uRec   p- lf-employment earnin gth===== d 	          = uRec   p- HHLD tax lia- lf-em sourc" lend 	     uc   = uRec   p- Unent earnin"ourpenslag f" lend 	         1= uRec   p- HHLD tax lia- Unent earnin"lend 	     wc   = uRec   p- Worker's"ourpenslag f" len=== d 	         1= uRec   p- HHLD tax lia- Worker's"== engtd 	          = uRec   p- SosistaSecu    ts";       engtd 	         1= uRec   p- HHLD tax lia- SosistaSecu    "d 	          = uRec   p- Suppl     staSecu    tb;
fit"d 	         1= uRec   p- HHLD tax lia- Suppl     st"lend 	          = uRec   p- P      Ace";      h==gth===== d 	         1= uRec   p- HHLD tax lia- P      gth===== d 	          = uRec   p- Vet?"ans' P";       engt===== d 	         1= uRec   p- HHLD tax lia- Vet?"an P";    "d 	          = uRec   p- Su incom B;
fits h==gth===== d 	          = uRec   p- HHLD tax lia- pu incom  sourc"d 	          = uRec   p- ity income,b;
fits h==gth====d 	          = uRec   p- HHLD tax lia- ity income, sou"d 	 r       1= uRec   p- HHLD tax lia- ent income  engtd 	          = uRec   p-i income"p";       engt===== gtd 	         1= uRec   p- HHLD tax lia- t income";      d 	   v      = uRec   p- itincome"p";       engt===== gd 	   v     1= uRec   p- HHLD tax lia- d income";      d 	 r        = uRec   p- R   stap";       engt===== gt d 	 r       1= uRec   p- HHLD tax lia- enme";       gt d 	          = uRec   p- on assistatance";      === gt d 	 ed      1= uRec   p- HHLD tax lia- on assistatax lrd 	          = uRec   p- upport payments";      === gt d 	         1= uRec   p- HHLD tax lia- cpport paymen"= d 	          = uRec   p-  payments";      engt===== gt d 	         1= uRec   p- HHLD tax lia- apaymen" len=== d 	          = uRec   p- ll assistance";     ts";      d 	         1= uRec   p- HHLD tax lia- ll assist"===== d 	          = uork - tax liap";       engt===== gt == d 	         1= uRec   p- HHLD tax lia- ork - tax li"lend 	          = uRec   p- To staiuaseof";, sourc" lengthd 	 e        = uRec   p- To staiuaseof";,;
attg   engtd 	          = uAll           surancex liaexcept"===== d 	          = uAr     in
HHLD  by medica Medi    "=== d 	          = uAr     in
HHLD  by medica Medi  id"=== d 	          = uCHAMPUS, VA,eive  lit       lth     "==d 	          = uAr     in
HHLD have    lth ce (was/w"==d 	          = uRec   p- Huaseof";       "h==ngth==th==d 	       8  = uRec   p- of months         in
HHLD"=== d 	          = uRec   p- Huaseof"; tax liapercr"; lesrhd 	          = uRec   p- HHLD tax liapercr"; les -"=== d 	         8= uFitataweight (2 int iedidecimstaplace  d 	         $= unec me"p"entth iuaseof"; i; of Fat."lend 	x         = uArnus ox       c   e   engt===== gt == d 	          = uReturn
ao iuliaequ   " engt===== gt == d 	          = usuaseof";     " length===== length=====d 	        $1= uFirme"p"entth iuaseof"; i; of Fat. "S  d 	s         = uAll flag for PECOH";HUNITS  engt===== gd 	          = uAT ANY TIME DURINGm20..
DID  engt===== d 	          = uoUMBER OF PEOPLE IN THISOLD RECORD"=== d 	          = uAT ANY TIME DURINGm20..
DID  engt===== d 	     cc   = uoUMBER OF PEOPLE IN THISOLD RECORD"=== d 	          = uDID (YOU/ANYONE IN THISOLD RECORD) PAY d 	 r        = uAT ANY TIME LAST YEAR, DID (YOU/ANYONE d 	 r      le= uAT ANY TIME LAST YEAR, DID (YOU/ANYONE d 	 r r    le= uAT ANY TIME LAST YEAR, DID (YOU/ANYONE d 	 r t    le= uAT ANY TIME LAST YEAR, DID (YOU/ANYONE d 	 r        = uoUMBER OF PEOPLE IN THEOLD RECORD"===  d 	     jc   = uoUMBER OF PEOPLE IN THEOLD RECORD"===  d 	     jr   = uoUMBER OF PEOPLE IN THEOLD RECORD WHO" d 	     jt   = uoUMBER OF PEOPLE IN THEOLD RECORD WHO" d 	     sc   = uoUMBER OF PEOPLE IN THEOLD RECORD WHO" d 	          = uoUMBER OF PEOPLE IN THEOLD RECORD"===  d 	          = uAT ANY TIME LAST YEAR, DID (YOU/ANYONE d 	 r ic   le= uAT ANY TIME LAST YEAR, (WERE YOU/WAS"==d 	          = usuaseof";   ques/weof Fat" length===== d 	          = uPerson f   le, er";    
== length=====d 	          = uK    hs     ly" length===== length=====d 	          = uF   le,    " length===== length========d 	          = uof months         in
    ly" length====d 	          = ubndex
ao with no       hs     ly    d" d 	x         = ubndex
ao with no       hs     ly     " d 	x         = ubndex
ao with no       hs     ly"===== d 	x         = ubndex
ao with no       hs     ly       d 	x         = ubndex
ao with no       hs     " len=== d 	x         = ubndex
ao with no       hs     " len=== d 	x         = uown n under ain     ly ge 19 6" len=== d 	x         = uof months     n     marriedin under "==d 	          = uRel work        in
    ly ge 19 6" len=d 	          = uRel work        in
    ly ge 19 18"=== d 	f         = uIax liapercr"; lesrh==== length========d 	          = uLow tax lia       dollar amwas " lengthd 	          = uRlag  hs     ly tax liabomlow- sourc" ld 	x         = uRlag  hs     ly tax liabomlow- sourc" ld 	          = uRlag  hs rel worksub    ly tax liabo" ld 	          = uLow tax lia       dollar amwas ths" lend 	          = us salary"s     
gth==gth===== h========d 	         1= uF   le, sourcp- w saslary"s    iesrh===d 	     se   = uown basatininployment earnin gth=====  d 	x e      1= uF   le, sourcp- ploy ent earnin";      d 	          = uF -employment earnin gth===== th=====  d 	x         = uF   le, sourcp- lf-em sourc" len=====  d 	x    uc   = uUnent earnin"ourpenslag f" lenen=====  d 	x        1= uF   le, sourcp- Unent earnin"len=====  d 	x    wc   = uWorker's"ourpenslag f" len=== h========d 	         1= uF   le, sourcp- Worker's"ourpenslag f" d 	     s    = uSosistaSecu    tB;
fits h==gth=====   d 	x        1= uF   le, sourcp- SosistaSecu    "=====  d 	x         = uSuppl     staSecu    tB;
fits h==gth==d 	x        1= uF   le, sourcp- Suppl     staSecu    " d 	          = uP      nce";     tH";wloy    b;
fits hd 	         1= uF   le, sourcp- p      nce";     "===  d 	x         = uVet?"ans' B;
fits h==gth=====   =gth==d 	x        1= uF   le, sourcp- vet?"an p";       engt=d 	x     ur  = uSu incom's"p";       engt===== gt == ==d 	x         = uF   le, sourcp- Su incom  sourc"=====  d 	x         = uDty income,p";       engt===== gt == ==d 	x         = uF   le, sourcp- ity income, soum "===  d 	x    re   = uRet income,p";       engt===== gt == ==d 	xr       1= uF   le, sourcp- Ret income, soum "===  d 	x         = uI income"p";       engt===== gtgt == ==d 	x        1= uF   le, sourcp- t income";      =====  d 	x      v  = uDtincome"p";       engt===== g gt == ==d 	x  v      = uF   le, sourcp- itincome";      =====  d 	x    rn   = uRe  stap";       engt===== gt  gt == ==d 	xr       1= uF   le, sourcp- Re  sta sourc" len=====d 	x        4= uon assistab;
fits h==gth====  gt == ==d 	xed      1= uF   le, sourcp- on assistatax le  engt=d 	x         = uCpport payments";      === gt  gt == ==d 	x        1= uF   le, sourcp- Cpport paymen"= en=====d 	x         = uAlayments";      engt===== gt = en=====d 	x        1= uF   le, sourcp- Apaymen" len=== en=====d 	x         = uFitassistance";     ts";      = en=====d 	x        1= uF   le, sourcp- litassistance";     "==d 	x         = uork - tax liap";       engt===== gt == d 	f        1= uF   le, sourcp- ork - tax li"len gt == d 	f         = uTo sta    ly tax li  engt===== gt == ==d 	xe        = uTo sta    ly ;
attg   engt===== gt == d 	f         = uTo sta          ly tax li  engt===== gtd 	f   _     = uTo sta    ly tax lio    d  h==gth===== d 	h         = uRefnco   tsith noom        hs S      "=d 	x        8= usuaseof";onthntd fnco   tsith noweight"d 	          = uTreasor ;
alongestuerson huaseof"; ID"d 	          = uF   le,marke     ualth         mpsrh===d 	          = uF   le,marke     ualth n           rh==d 	x         = uF   le,fungiblli   ualth medi    "=== =d 	x     id  = uF   le,fungiblli   ualth medi  id"===  d 	x         = uF   le,marke     ualth iuasattksub   y"d 	          = uBas   ongUSDA figure   engt===== gt == d 	q         = uUs   bomourpute,fungiblli   ualth"===  d 	p         = usuaseof";   q of Fat" length===== engthd 	pp        = uTreasor ;
alongestuerson huaseof"; ID"d 	o         = ub - Fs8ap- mber of sec === gt  gt == ==d 	t         = ub - Fs8ca- P     'number of Fat"t == ==d 	t         = uox   d   rel wlons  le  d  h==gth===== d 	          = ub - Fs8dp- Ag " length===== length=====d 	l         = ub - Fs8cp- M    sta      "h==ngth==th==d 	e         = ub - Fs8fp- S     'number of Fat"t == ==d 	t         = ub - Fs8gp- Sex" length===== length=====d 	l         = ub - Fs8hp- on assistatanttaincome  engtd 	e         = uRlc " length===== length========th=====d 	        2.= uncomusths       , er";    
== length==d 	          = uA  y ...S      , Hi     c,eiveLssino?"td 	e   h     = uDeteasod Hi     co    d  h==gth===== ==d 	l         = uF   le,of Fat" length===== ength==== ==d 	l     leng= uF   le,    " length===== length========d 	l         = uF   le,rel wlons  l  engt===== gt == ==d 	          = uPr m    f   le,rel wlons  l  engt===== d 	          = uDeteasod huaseof"; summ   
gth==gth====d 	          = uF   le,rel wlons  l  engt===== gt == ==d 	          = uDeteasod huaseof"; ary"    ly       "h=d 	e       1.= uF   le,me Fats ge 19 18 (exclude   engtd 	          = uAgio    d a- P       15+     s h==gth==d 	          = uPoi inc boma li  ques/weof Fatths    "td 	ef        = uPoi inc boma li  ques/weof Fatths     "d 	e         = uneques/weof Fatths e      in
ihld"===  d 	t        8= uFitataweight (2 int iedidecimstaplace  d 	t        8= uo
attg /    in
labivefo    weight"==  d 	t        8= uSuppl     l   ataweight (2 int ied"==  d 	t         = usudider k    did ...               "=  d 	t         = uDoes ... usually      35k    ive o  ya d 	t         = uWhy. mai...       l rom               "d 	t         = uIai... d WIC?gramw saslom       efo "h=d 	e         = ubnd   le" length===== length========th=d 	e   occ   = uO    lag f" len=== h========== gt == ==d 	          = uDuraalongestueent earnin gth===== th===d 	t         = uWh /* id ...          ?" len=== en=====d 	r         = uC   sths worker  engt===== gt  gt == ==d 	d         = uTreasor ;
alongestuerson huaseof"; id"d 	t         = uWh /* id ...          COH";       a"=  d 	t         = uDoes ...      a d gular job now,  engt=d 	r         = uDtdy ...     serve ongactive dume, s"t=d 	r         = uWh /* id  ...serve?" len=== en=====ngt=d 	r         = uWh /* id  ...serve?" len=== en=====ngt=d 	r      3  = uWh /* id  ...serve?" len=== en=====ngt=d 	r      4  = uWh /* id  ...serve?" len=== en=====ngt=d 	s         = usudider k             does ..."====ngt=d 	s         = uIai...      byma lihuar ongati  job?"  d 	t        4= usudid ...does ... ;
a     huar?"==ngt=d 	s         = usudid ...does ... usually ;
a    "==  d 	t         = uOngati  job, iai...  ,me Fatlth a"===  d 	t         = uOngati  job, iai...  by medica atuer f"d 	t         = uL        . mai...  ttendgramor"====ngt=d 	s         = uIai...    olsod o";
      a  a full-"  d 	t         = uL bivefo               d  h==gth===== =d 	t         = uRea   ,OH";ueent earnin gth===== th====d 	          = uFull/p"en-timwe      "h==ngth=== th====d 	          = uox eries/wd
labivefo    ent earnin gth=d 	          = uL bivefo    bymaimweworkedlom losn gth=d 	          = uCC?glian
labivefo   " length===== engthd 	          = uFull/aimwelabivefo   " length===== engtd 	l  j      = uMajom  s    lenc    gth===== ength==engd 	l         = uDeteasod  s    len    d  h==gth===== ==d 	          = uMajom o    lag fn    d  h==gth===== ==gd 	l   occ   = uDeteasod o    lag fn    d  h==gth===== d 	e         = uo
attg  eligibncome,r PE h==gth===== =d 	        1.= ub - F29ap- Didh...         a job or"===d 	        1.= ub - F29bp- Didh... doher      or   ,"  d 	        1.= ub - F3mp- Evengatoughh... di; oo      "d 	        1.= ub - F31much didey diffnco          engtd 	          = ub - F32p- s ... maia limaif" len=== h==d 	          = ub - F33p- Durgram20..
in
iudider k    "d 	          = ub - F34p- t inc; ewatl      i - F-"=== d 	          = ub - F35 Didh...     her  full      lth"d 	          = ub - F36p-  Y...s   ...     od abiun"lend 	          = ub - F36p- W      mai...     gramfor"===d 	          = ub - F37p- W   ya li(o  re, s i - F36)"td 	e       1.= ub - F38p- s ... maia limaifn  a   ,..."d 	          = ub - F39mucFor
iudider kent eae   did . d 	 r      1.= ub - F41p- t ia li      t ......     od d 	 r        = ub - F41p- t inc; ewatl      i - F-"=== d 	        1.= ub - F43p- Didh...      linint .n"==ngt=d 	          = ub - F44much dider k      did ...     "td 	et      1.= ub - F45p- s ... maia limaifn  a   ,..."d 	        1.= ub - F46cp- C   sths worker  engt===== gd 	          = uRec   p-  Worker/  nworkero    d a-"===d 	          = uRec   p-  Worker/  nworkero    d a-"===d 	          = uRec   p-  Worker/  nworkero    d a-"===d 	          = uRec   p- Worker/  nworkero    d a- P  "d 	          = uRec   p- E            "h==ngth=== th===d 	          = uRec   p- Lon     job c   sths worker  ed 	          = uRec   p- Lon     job c   sths worker  ed 	          = uRec   p- O    lag f hs  on     job b " d 	          = uRec   p- O    lag f hs  on     job b " d 	          = uRec   p- bnd   le hs  on     job b "  ed 	          = uRec   p- bnd   le hs  on     job b "  ed 	t         = ub - F55ap- Metropo
attn     istie),   "d 	          = uWmai...  C?gramin
ati  iuase (apt.) 1"ed 	t         = uRec   p- Reglonths erevio     s er"ce"ed 	t   st    = uRec   p- FIPS ncome c   phs erevio  " ed 	t         = uRec   p- CBSA scomusths   s er"ce 1 y  d 	          = uRec   p- Census d inslonths curd nt"== d 	          = uRec   p- Census d inslonths erevio  " ed 	        1.= ub - F47p- Cwas gramall l flag f   h   "d 	          = uo
attg   rom  on     job     d  h==gthd 	         1= ub - F48a &  bmuch did ...did ...     "hd 	          = uo
attg  n    d  h==gth===== ==g h==gthd 	          = ub - F49ap- Didh... ;
a m   y  rom oth"d 	          = ub - F49bmuork - w salary"s      ;
att"d 	e         = uRec   " length===== length========th===d 	          = uRec   " length===== length========th===d 	          = uRec   p- To staw salary"s      ;
attg"d 	          = ub - F49bmu ork -      u own basatini" ed 	          = uRec   p- Ar ktwn basatininploym"t == ==d 	l         = uoRN-YN = 1lom SEOTR = 1" len=== en=====d 	x         = ub - F49b- lf-employment earnin gth=====d 	x         = uAr ktwn ff-employment earninmin
oRN-YN"d 	x         = uRec   p- To staamwas ths ff-employm"== d 	          = ub - F52ap- Ather   imwedurgram20.."== ed 	l         = ub - F52ap- Ather   imwedurgram20.."== ed 	l         = ub - F52ap-Ather   imwedurgram20.."== e d 	        1.= ub - F52bmuch did ...did ... d WIC?  in"d 	          = ub - F53ap- Durgram20..
did ... d WIC? "d 	          = ub - F53b" length===== length========th=d 	w       1.= ub - F53cmuch did ...ourpenslag f
did" ed 	 s        = ub - F56bp- Didh... d WIC?  s.s.?"==ngt=d 	          = ub - F56cmuch did ...did ... d WIC?  in"d 	          = ub - F57bp- Didh... d WIC?  SSI?"t == ==d 	          = ub - F59bp- Didh... d WIC?  p      gth==d 	     lengt= ub - F59cp- Didh... d WIC?  ttnf/AFDC u"d 	          = ub - F59dp- t iiudider kcoveredhs 20.."=d 	         1= ub - F59emuch did ...did ... d WIC?  in"d 	          = ub - F60bp- Didh... d WIC?  vet?"ans'" ed 	1         = ub - F60cp- ity income,ourpenslag f" lend 	2         = ub - F60cp- Su incom b;
fits h==gth====d 	3         = ub - F60cp- Vet?"ans' pensg f" len=== h=d 	3      4  = ub - F60cp- on assistance";      === gt d 	5         = ub - F60cp- ork - vet?"ans' p";       end 	5        1= ub - F60dp- tai... d quir   bomfill  ut"d 	         1= ub - F60emuch did ...did ... d WIC?  f "d 	          = ub - F61bmu ork - t .n sosistasecu    " d 	          = ub - F61cp- s ... maia lisou    th atis"d 	      2   = ub - F61dp- Ar ktrk - pensg fmor"====ngtd 	          = ub - F61emuch did ...did ... d WIC?  f "d 	          = ub - F61gmuch did ...did ... d WIC?   end 	l         = uRec   pto staamwas ths su incom's" sou"d 	          = ub - F62bmuc Does ... have a    lth" lend 	          = ub - F62cp- Didh... d t inlom leave a j"d 	          = ub - F64bmu ork - t .n sosistasecu     "d 	          = ub - F64cp- s ... maia lisou    th  sou"d 	      2   = ub - F64cp- Ar ktrk - dty income, soum "d 	          = ub - F64emuch did ...did ... d WIC?  f "d 	2         = ub - F64gmuch did ...did ... d WIC?  f "d 	2         = uRec   pto staamwas ths dty income, sou"d 	r         = ub - F65bmu ork - t .n sosistasecu    " d 	          = ub - F65cp- s ... maia lisou    th  engtd 	          = ub - F65cp- Ar ktrk - ret income, soum "d 	          = ub - F65emuch did ...did ... d WIC?  f "d 	2         = ub - F65gmuch did ...did ... d WIC?  f "d 	          = uRec   pto staamwas ths ret income, sou d 	sn        = ub - F66bp- Did... twn er ki income" lend 	         1= ub - F66cmuch did ...did ... d WIC?  in"d 	          = ub - F67bp- Didh... twn er kshar sura"end 	          = ub - F67cmucNo d incomes d WIC? y"===== d 	         1= ub - F67cmuch did ...did ... d WIC?  in"d 	rn        = ub - F68bp- Didh... twn er klary,  engt=d 	r        1= ub - F68cmuch did ...did ... d WIC?  in"d 	          = ub - F69cp- Didh... d WIC?  en assistat"d 	1         = ub - F69d(1) &  (2)p- Sou    th  engtgt=d 	2         = ub - F69d(3)p- Sou    th en assistat"gt=d 	2      3  = ub - F69d(4)- Sou    th en assistat"gt= d 	          = ub - F69hp- To staamwas ths en assistat"d 	          = ub - F70bp- Didh... d WIC?  cpport paym"d 	         1= ub - F70cmuch did ...did ... d WIC?  in"d 	          = ub - F71bp- Didh.. d W'v apaymen p";   "d 	         1= ub - F71cmuch did ...did ... d WIC?  in"d 	          = ub - F72bp- Didh... d WIC?  fl assist"==d 	         1= ub - F72cmuch did ...did ... d WIC?  in"d 	          = ub - F73c" length===== length========th=d 	          = ub - F73bp- Didh... d WIC?  ork - tax l"d 	          = ub - F73dmuch did ...did ... d WIC?  in"d 	p         = uRec   p- To sta        inourc" len=====d 	pe        = uRec   p- To sta        ;
attg   engt==d 	          = uRec   p- To statrk - pe      inourc" led 	p   _     = uRec   p- To sta       tax lio    d  h==d 	per       = uRec   p- Low- sourc levelths        " ed 	t        1= ub - F74bmu Wmai...  by medica medi    "d 	t  id    1= ub - F74dmu Wmai...  by medica medi  id"d 	          = ub - F74fmu Wmai...  by medica CHAMPUS,"d 	          = ub - F75bmu Wmai...  by medica     attrhd 	          = ub - F75cmu Wmaiati  i  lth ce (was/w"==d 	 i      1.= ub - F75dmu Wmaiati  i  lth ce (was/w"==d 	 ip       = ub - F75ep- Didh...'s"ent eae  H";uer f"d 	          = ub - F76p- t inc; ewatl      i - Fworke"d 	p         = ub - F76amu ork - t .n sosistasecu    " d 	          = ub - F76bmu Wmai...     udod o";t .. h==d 	          = uRec   p- bnclude     ome         udod"=d 	          = uRec   p- bnclude     ome      by medic"d 	          = uA-AGE linint .n 15" length===== length=d 	          = uA-AGE linint .n 15" length===== length=d 	          = uRel wlons  lebomd fnco   tsith n"==ngt=d 	s1        = uP     'number of Fatmall flag for PE"  d 	t1        = uAgioall flag for PE"  ngth===== length=d 	          = uM    sta      oall flag for PE"  ngth==d 	          = uS     'number of Fatmall flag for PE"  d 	t1        = uS   all flag for PE"  ngth===== length=d 	          = uHigh    gra  p ttendod all flag for PE"d 	          = uL bivefo               d  all flag f  ed 	 x        = uAll flag for PECOH";PEAFEVER" len=== h=d 	1         = uAll flag for PECOH";PEAFWHN1" len=== h=d 	          = uork - tax li" length===== length=======d 	          = uMIG-ST intutlag for PE."== ength ength=d 	     1    = uMIGSAME intutlag for PE."== ength engthd 	          = uo
attg   rom ent eae  H";ploym"t == ==d 	          = us salary"s      tax liabop  d dor PE"  d 	          = uNonff-employ ent earnin";      th engthd 	          = uF -employ ent earnin";     abop  d d"  d 	t         = uCurd nt ;
attg p- W   ln p";" len=====d 	f         = uCurd nt ;
attg p- Hou ln p";" len=====d 	e         = uP      marke     ualth medi    "=== ===d 	e     id  = uP      marke     ualth medi  i;"== engtd 	b         = uont eae       ibuag foror
i  lth" len==d 	          = uTax Fasor       "h==ngth==th==ngth==n==d 	t         = uDe ome  cy        poi inc h==gth===== =d 	         4= uCpportTax Cmedin gth===== th=====  engtd 	b         = uo
a";     abax cmedin gth===== th=====d 	f         = uAddinistataCpportbax cmedin gth===== thd 	          = uSosistasecu     ret income,p"; ols"gt= d 	          = uFederstaret income,p"; ols   n aag f  ed 	          = uAdjusworkgr    tax li" length===== lengd 	          = uAmwas ths      sta     "h==ngth==th==ngd 	          = uAmwas ths      sta    e   engt===== gt d 	          = uTaxabl ";     aamwas " lengtht===== gt d 	x         = uFederstaIax liaM  g  ata    rattrh= gt d 	          = uMajom labivefo        d  h==gth===== ==d 	e         = uRea   ,OH";ueent earnin gth===== th====d 	t         = uFull/p"en-timwe           "h==ngth==th=d 	t         = uDeteasod rea   ,OH";p"en-timw" len=====d 	e         = uDtycou  sad workero    d  h==gth===== =d 	          = uC   sths workero    d -job 1" len=== h=d 	p         = uThealth with no           d  h==gth====d 	pe        = us ... maia limaifn  a   ... mai      " d 	          = ubnd incus oc   sths worker ongfirme"jo"d 	e         = uNLFgactivome, s;
      H";    in

    "d 	p         = usuats gsually     wd
la       "=  h====d 	pe        = ubn w ...cwas r k    y ...bivn?"=  h====d 	pe        = ubn w ...cwas r k maiyuar mtrk - bivn?"=d 	pef       = ubn w ...cwas r k maiyuar fark - bivn?"=d 	pe        = uWh /* id  ...x liaboma liU.S.abom   y?"d 	px        = uAll flag for PECOH";PENATVTY" len=== h=d 	1         = uAll flag for PECOH";PEMNTVTY" len=== h=d 	1 f       = uAll flag for PECOH";PEFNTVTY" len=== h=d 	1         = uAll flag for PECOH";PEINUSYR" len=== h=d 	1e        = uox   d   rel wlons  le attgo iesrh===h=d 	     3    = uIntutlag for PE."== ength ength=n=== h=d 	     1. 
= uCby medica ati  lth      proincod"===  d 	    length= us  lth ce (was/w          . gth===== thd 	        1.= uCby medica ati  lth      through"=== h=d 	          = umber of second po
acyof";onthf
i  lth" d 	     2    = umber of second po
acyof";onthf
i  lth" d 	        1.= uDtdy...'s"OH"me  H";curd nt ;nt eae  H"d 	          = uont eae  H";uer f       by medis lione"d 	p     1. 
= uCby medica at     th...a ln purchas  "td 	e    lengt= uPr  att i  lth ce (was/w          . gthd 	        1.= uCby medica     att          rel workt "d 	p         = umber of second firme"po
acyof";onthf  ed 	     2    = umber of second sec me"po
acyof";onthf  d 	         1= uPr  att       by medis lione  uts er  "d 	        1.= uCby medica a lih  lth      nd s lione"gd 	        1.= uCby medica medi    , a lih  lth"== engtd 	c       1.= uCby medica (medi  i;/l fll name), attrhd 	        1.= uof months covered by medica medi  i; ("d 	        1.= uCby medica ar ktrk - k    hs h  lth"== d 	          = uCby medica TRICARE, CHAMPUS,eive  lit "d 	     2    = uCby medica CHAMPVA."== ength ength=n===d 	     3    = uCby medica VA."== ength ength=n====n===d 	     4    = uCby medica bnd    h  lth. h==gth===== =d 	          = uCby medica trk -."== ength ength=n====nd 	          = uCby medica trk -      hs h  lth"== ===nd 	          = uOrk -      hs h  lth ce (was/w     udo"d 	        1.= uWould  ...sayy...'s"h  lth ce g;
ast"=d 	          = ubntutlag foi - : HI"== ength ength=n===d 	          = ubntutlag foi - : DEPHI"== ength ength=nd 	  p       = ubntutlag foi - : PAID  engt===== ngth=nd 	          = ubntutlag foi - : HIOUT"== ength ength=nd 	  p     1.= ubntutlag foi - : PRIV  engt===== ngth=nd 	          = ubntutlag foi - : DEPRIV  engt===== ngthd 	  p       = ubntutlag foi - : POUT"== ength ength=nhd 	          = ubntutlag foi - : OUT"== ength ength=nhhd 	          = ubntutlag foi - : CARE"== ength ength=nhd 	  c       = ubntutlag foi - : CAID  engt===== ngth=nd 	          = ubntutlag foi - : MON"== ength ength=nhhd 	          = ubntutlag foi - : oth"== ===nh ength=nhhd 	     lengt= ubntutlag foi - s: OTYP-1,y..., OTYP-5. d 	s o       = ubntutlag foi - : OTHSTPER" len=== h=nhhd 	   s lengt= ubntutlag foi - s: OTHSTYP1,y...,rh===h=d 	          = ubntutlag foi - : HEA"== ===nh ength=nhhd 	          = ub - F57cmuch did ...did ... d WIC?  in"d 	w         = ub - F49bmu ork -   salary"s     
gth==gd 	 e        = ub - F49bmu ork -      u own basatini" ed 	          = uRec   :  Cby medica bnd    H  lth"== ==d 	          = uSu incom  tax li,isou    1, gth===== thd 	2         = uSu incom  tax li,isou    2, gth===== thd 	2         = uDty income,tax li,isou    1, gth===== td 	2      2  = uDty income,tax li,isou    2, gth===== td 	2         = uRet income,tax li,isou    1, gth===== td 	2         = uRet income,tax li,isou    2, gth===== td 	2         = ubnincome";      =====   ===nh ength=nhhd 	l         = uDtincome";      =====   ===nh ength=nhhd 	lr        = uenme";       gt =====   ===nh ength=nhhd 	l         = uon assistance";      === gt h ength=nhhd 	l         = uCpport payments";      === gt  gt == ==d 	l         = uAlayments";      engt===== gt = en=====d 	l         = uFitassistance";      === gt h ength=nhhd 	      leng= us ... mai... maifn  a   ,five o?gra?"  d 	        le= uIntutlag for PE =====   ===nh ength=nhhd 	      leng= ub - F49bmu lf-employment earnin ;
att"d 	      leng= uRecIC? y     symenssistance";     ?"nhhd 	lr    leng= uTRANSPORTATION ASSISTANCE ALLOCATION"  d 	      leng= uRecIC?  cpport     services? gth===== td 	      leng= uCpport     nce";     tall flag for PE."d 	      leng= us i...o under aneed       -     w une" d 	        le= uPAIDCCYNtall flag for PE."=nh ength=nhhd 	     lengt= uDoes sith nowi   nod by magio  ymen  "td 	      leng= uAHIPERtall flag for PE."=nh ength=nhhhhd 	      6eng= us ...     hs ce (was/w ( ma/    )"== ==d 	      leng= uAHITYPtall flag for PE."=nh ength=nhhhhd 	    length= uWmaicpportge 19 agio19lary"wi   no" lend 	      leng= uPCHIPtall flag for PE."=nh ength=nhhhhnd 	      leng= us ...    ya li  a   s ( ../name)"nhhhhnd 	      2eng= us ...    ya li  a   s ( ../name)"nhhhhnd 	      leng= uRESNSS1-2 all flag for PE"  ngth===== ld 	      i1ng= us ...    ya li  a   s ( ../name)"nhhhhnd 	      i2ng= us ...    ya li  a   s ( ../name)"nhhhhnd 	      iang= uRESNSSI1-2 all flag for PE"  ngth===== d 	      leng= us i...o under age 19 agio18.    "===== d 	    d   le= uSSIKIDYNtall flag for PE h==gth===== ==d 	     lengt= us i...o under age 19 agio19.    "===== d 	      leng= uSSKIDYNtall flag for PE h==gth===== == d 	      leng= us op ttendod a job s;
...program o "h=d 	      leng= uJCYNtall flag for PE === gt h ength=nhhd 	      leng= us op ttendod job   adatininlr iattgkt "d 	      leng= uJRYNtall flag for PE === gt h ength=nhhd 	 t    leng= us op ttendod a lr iattgkprogram to" lend 	      leng= uJTYNtall flag for PE === gt h ength=nhhd 	n     leng= us op ttendod GEDoc   saslom d WIC? y"==d 	n   l leng= uSCHOOLYNtall flag for PE h==gth===== ==d 	 ic   leng= us opd WIC? y WIC?" len=== en=====ngt===d 	 ic   leng= uWICYNtall flag for PE === gt h ength=nhd 	      leng= us opp"en oipstod o";     programst pch"d 	a     leng= uCOMSRVYNtall flag for PE h==gth===== ==d 	y     leng= ubnd   le hs  on     job h==gth===== == d 	      leng= uO    lag f hs  on     job h==gth===== =d 	1e    leng= u22.digit Person P     , er";    
== led 	    length= uFedersta;     abax li income, befiv "==d 	xc    leng= uFedersta;     abax li income, afinc h==d 	n_bc  lengt= uncome ;     abax li income, befiv "====d 	n_bc  lenat= uncome ;     abax li income, afinc h== =d 	1e    leng= uDemograp i.number of Fatmhs     litttg"d 	      leng= uDemograp i.number of Fatmhs Mtrk -"== =d 	1e    leng= uDemograp i.number of Fatmhs Fark -"== =d 	1e    leng= uDemograp i.nu     hs Mtrk -"== ====== =d 	1e    leng= uDemograp i.nu     hs Fark -"== ====== =d 	1x    leng= uDemograp i.nuall flag for PECOH";PECOH"d 	px    leng= uDemograp i.nu All flag for PECOH" h== =d 	1x    leng= uDemograp i.nu All flag for PECOH" h== =d 	1x    leng= uDemograp i.nu All flag for PECOH" h== =d 	1x    leng= uDemograp i.nu All flag for PECOH" h== =d ;=d run;
en/*----------------------------------------------
enT liPROC FORMATax_ac rnin will sto  ya liOH"mats
o";a"s s data"sett  lsod fcpmar07 .enTo     a listo  diOH"mats o";a"sub  quest program,
o"  udo s lithgramlikeiati :
enprociOH"mat cntmbe=libr   .fcpmar07;
PROC freq;
====== =tabl s PULAYCK1 ;
====== =OH"mat PULAYCK1   PULAYCKa.;
enFive o  yinOH"matg f,    sul..a liPROC FORMAT
secag f hs a liSAS Procedure  Gu er
en  ----------------------------------------------*/
enPROC FORMATacntmout=libr   .fcpmar07;
 ase VALUE h       	(defaul.=32)d 	1 ====== ==  usuaseof";        h==gth===== ==d se VALUE h       	(defaul.=32)d 	1 ====== ==  u1 Pern gth===== th=====  engt =d 	2 ====== ==  u2 Pern   engt===== gt  gt == ==d 	3 ====== ==  u3p- 4 Pern   engt===== gt  gt =d 	4 ====== ==  u5p- 9 Pern   engt===== gt  gt =d 	5 ====== ==  u10+ Pern   engt===== gt  gt == d se VALUE h       	(defaul.=32)d 	-3====== ==  uRefuse;"== ength===== th===== =d 	-2====== ==  uDon't knud" length===== ===== =d 	-1====== ==  uN   in
   y ms  h==gth===== ==gd 	1 ====== ==  uLinint .n $5,000 h==gth===== ==d 	2 ====== ==  u$5,000abom$7,499 h==gth===== ==d 	3 ====== ==  u$7,500abom$9,999 h==gth===== ==d 	4 ====== ==  u$10,000abom$12,499 h==gth===== d 	5 ====== ==  u$12,500abom$14,999 h==gth===== d 	6 ====== ==  u$15,000abom$19,999 h==gth===== d 	7 ====== ==  u$20,000abom$24,999 h==gth===== d 	8 ====== ==  u$25,000abom$29,999 h==gth===== d 	9 ====== ==  u$30,000abom$34,999 h==gth===== d 	10====== ==  u$35,000abom$39,999 h==gth===== d 	11====== ==  u$40,000abom$49,999 h==gth===== d 	12====== ==  u$50,000abom$59,999 h==gth===== d 	13====== ==  u$60,000abom$74,999 h==gth===== d 	14====== ==  u$75,000abom$99,999 h==gth===== d 	15====== ==  u$100,000abom$149,999 h==gth====d 	16====== ==  u$150,000aary"by m h==gth===== =d se VALUE h_re pnm	(defaul.=32)d 	-1====== ==  uN   in
   y ms  (non-int?"; ew)"d 	0====== ===  uBlanklom impo   bl " length====d se VALUE h_h     	(defaul.=32)d 	1 ====== ==  ut inc; ew" len=== en=====ngt===d 	2 ====== ==  uThealA non-int?"; ew h==gth====d 	3 ====== ==  uThealB/C non-int?"; ew h==gth==d se VALUE h_of 1e 	(defaul.=32)d 	0====== ===  uNonint?"; ew iuaseof";"== engthd se VALUE hof     	(defaul.=32)d 	0====== ===  uNonint?"; ew iuaseof";"== engthd se VALUE h       	(defaul.=32)d 	0====== ===  uNon-int?"; ew iuaseof";"== engtd 	1 ====== ==  ususbary/        m    f   le"===d 	2 ====== ==  ususbary/        m    f   le"===d 	3 ====== ==  uUnmarriedinC?glian
mal "=== ===d 	4 ====== ==  uUnmarriedinC?glian
femal "=== =d 	5 ====== ==  uPr m    f   le,huaseof"; -"=== d 	6 ====== ==  uCC?glian
mal  non    ly" lengthd 	7 ====== ==  uCC?glian
femal  non    ly" lengd 	8 ====== ==  uNon    ly,huaseof"; m h==gth===d 	9 ====== ==  uGro   qu"ener  === gt  gt == ==d se VALUE h cover 	(defaul.=32)d 	3 ====== ==  uM
..  gt =====   ===nh ength=nd se VALUE h_h  len	(defaul.=32)d 	0====== ===  uBlank  gt =====   ===nh ength=nd se VALUE h_livqrt	(defaul.=32)d 	1 ====== ==  usuase, apt.,or Pt h==gth===== =d 	2 ====== ==  usU in
n    ansiest hotel, etc."d 	3 ====== ==  usU, sitm,  o";t ans. hotel,"===d 	4 ====== ==  usU in
roomgramhuase"== ====== =d 	5 ====== ==  uMoince iuliaom treasor wi   no"d 	6 ====== ==  uMoince iuliaom treasor wi   1"ed 	7 ====== ==  usU     s1e     d abiv  th engthd 	8 ====== ==  uQtrs     hu in
roomgramH" h== =d 	9 ====== ==  uPern     sitm o";t ans. hotel,"d 	10====== ==  uTest om treasor sit  h==gth====d 	11====== ==  uStuer"; qu"ener  o";colsog  h==d 	12====== ==  uork -     HU === gt h ength=nhhd se VALUE h     b 	(defaul.=32)d 	0====== ===  ut inc; ewad,eiveThealA th engthd 	1 ====== ==  uVac    - d gular h==gth===== ==d 	2 ====== ==  uVac    - sto agiohs HHLD"=== ==d 	3 ====== ==  uT    occ ca  e      wi   URE"==d 	4 ====== ==  uUnfit om to be demolishod"===  d 	5 ====== ==  uUnde     str aag f,     read " d 	6 ====== ==  uCony mworkt       basatininH" hd 	7 ====== ==  uOcc ca AF,me Fats or        " ed 	8 ====== ==  uUnocc test om treasor sit  h==gd 	9 ====== ==  uPitmi  gra ind,    str aag f"= d 	10====== ==  uOrk -"== ====== =h==gth===== ==d 	11====== ==  uDemolishod"===  =h==gth===== ==d 	12====== ==  uH     hm treasor moved th engthd 	13====== ==  uOuts er segrnin gth===== th====d 	14====== ==  uCony mworkt  sitm basatini" e= d 	15====== ==  uMerge;"== ength===== th===== ==d 	16====== ==  uCondemne;"== ength===== th=====d 	17====== ==  uBuil..afinc A   l 1, 1980"===  d 	18====== ==  uUnuse;umber hs  istittksheen"= d 	19====== ==  uOrk -"== ====== =h==gth===== ==d se VALUE h  enur 	(defaul.=32)d 	0====== ===  uNo  in
   y ms  h==gth===== ==gd 	1 ====== ==  uOwnedlom beittkboughn"= en=====d 	2 ====== ==  uRnin gth===== th=====   en=====d 	3 ====== ==  uNo cash rnin gth===== th=====  d se VALUE h  elhhd	(defaul.=32)d 	0====== ===  uNo  in
   y ms  (non-int?"; ew)"d 	1 ====== ==  uYesrh==== length========en=====d 	2 ====== ==  uNorh==== length========en===== d se VALUE h  elavl	(defaul.=32)d 	0====== ===  uNo  in
   y ms  h==gth===== ==gd 	1 ====== ==  uYesrh==== length========en=====d 	2 ====== ==  uNorh==== length========en===== d se VALUE h  elint	(defaul.=32)d 	0====== ===  uNo  in
   y ms  h==gth===== ==gd 	1 ====== ==  uYesrh==== length========en=====d 	2 ====== ==  uNorh==== length========en===== d se VALUE ge      	(defaul.=32)d 	1 ====== ==  uNorrk    " len=== ======en=====d 	2 ====== ==  uMidwe  " len=== ======en=======d 	3 ====== ==  uSouth"== ===nh ength=nhh=======d 	4 ====== ==  uWe  " len=== ======en========= d se VALUE gestcen 	(defaul.=32)d 	11====== ==  uMain   gt =====   ===nh ength=nd 	12====== ==  uNew H mpshir   gt =====   ===nhd 	13====== ==  uVitmoin gth===== th=====   en==d 	14====== ==  uMassachuset    engt===== gt == d 	15====== ==  uRh d  Islary === gt h ength=nhhd 	16====== ==  uConnecagcun gth===== th=====   d 	21====== ==  uNew Y   "th===== th=====   en==d 	22====== ==  uNew J ms e" length===== length=d 	23====== ==  uPennsylvania === gt h ength=nhhd 	31====== ==  uOhiorh==== length========en====d 	32====== ==  ubnd   a === gt h ength=nhhn====d 	33====== ==  uIllinoi  engt===== gt = en=====d 	34====== ==  uMichigaf" len=== h========== gtd 	35====== ==  uWtyconsif" len=== h========== gd 	41====== ==  uMinnesota === gt h ength=nhhn==d 	42====== ==  ubowa === gt h ength=nhhn====n==d 	43====== ==  uMissou i" len=== h========== gtd 	44====== ==  uNorrk Dakota === gt h ength=nhhd 	45====== ==  uSouth Dakota === gt h ength=nhhd 	46====== ==  uNebraska === gt h ength=nhhn===d 	47====== ==  uKansasrh==== length========en==d 	51====== ==  uDelawar   gt =====   ===nh=en==d 	52====== ==  uM
ylary === gt h ength=nhhen==d 	53====== ==  uDistrict Of Columbia === gt h ed 	54====== ==  uVi g  ia === gt h ength=nhh h ed 	55====== ==  uW    Vi g  ia === gt h ength=nhd 	56====== ==  uNorrk Caroli a === gt h ength=nd 	57====== ==  uSouth Caroli a === gt h ength=nd 	58====== ==  uGeo g a === gt h ength=nhhn====d 	59====== ==  uFlorida === gt h ength=nhhn====d 	61====== ==  uKninucke" length===== length===d 	62====== ==  uTestinie   gt =====   ===nh=en=d 	63====== ==  uAlabama === gt h ength=nhhn====d 	64====== ==  uMice";sippi" len=== h==========d 	71====== ==  uArkansasrh==== length========end 	72====== ==  uLouis   a === gt h ength=nhhn==d 	73====== ==  uOklaiula === gt h ength=nhh h ed 	74====== ==  uTexasrh==== length========en==ed 	81====== ==  uMoin  a === gt h ength=nhhn====d 	82====== ==  ubdaiurh==== length========en==ed 	83====== ==  uWyomgra === gt h ength=nhhn====d 	84====== ==  uColoradurh==== length========end 	85====== ==  uNew Mexicurh==== length========d 	86====== ==  uArizo a === gt h ength=nhhn====d 	87====== ==  uUtah"== ===nh ength=nhh========d 	88====== ==  uNevada === gt h ength=nhhn====gd 	91====== ==  uWashgrat f" len=== h========== d 	92====== ==  uo    f" len=== h========== gt =d 	93====== ==  uCalifor ia === gt h ength=nhh hd 	94====== ==  uAlaska === gt h ength=nhhn=== hd 	95====== ==  uHawaii" len=== h========== gt= d se VALUE gtcb len	(defaul.=32)d 	0====== ===  uNon-met H";    ier";    d"===  d se VALUE gtco==  	(defaul.=32)d 	0====== ===  uNo  ier";    d"===  ====== gt= d se VALUE gtcb lst	(defaul.=32)d 	1 ====== ==  uPrinoipsl c   "=====  nhhn=== hd 	2 ====== ==  uBal    tHf CBSA h==gth===== ==gd 	3 ====== ==  uNon CBSA h==gth===== ==g=== ==gd 	4 ====== ==  uNo  ier";    d"===  ====== gt= d se VALUE gtmetsta	(defaul.=32)d 	1 ====== ==  uMetropo
attn === gt h ength=nhhd 	2 ====== ==  uNon-metropo
attn === gt h engthd 	3 ====== ==  uNo  ier";    d"===  ====== gt= d se VALUE gtindvp 	(defaul.=32)d 	0====== ===  uNo  ier";    d, non-met, or"===d se VALUE gtcb lsz	(defaul.=32)d 	0====== ===  uNo  ier";    dmor"====ngt=h=nhhd 	2 ====== ==  u100,000a- 249,999 h==gth===== hd 	3 ====== ==  u250,000a- 499,999 h==gth===== gd 	4 ====== ==  u500,000a- 999,999 h==gth===== gd 	5 ====== ==  u1,000,000a- 2,499,999 h==gth===d 	6 ====== ==  u2,500,000a- 4,999,999 h==gth===d 	7 ====== ==  u5,000,000+ === gt h ength=nhh hd se VALUE gtc leng	(defaul.=32)d 	0====== ===  uNon-met H";    ier";    d"===  d se VALUE hge 191 	(defaul.=32)d 	0====== ===  uNon   gt =====   ===nh ength=n d se VALUE hct     	(defaul.=32)d 	0====== ===  uNo  in
   y ms  h==gth===== ==gd 	1 ====== ==  uAl  H";s li  engt===== gt == ==d 	2 ====== ==  uNon   gt =====   ===nh ength=n d se VALUE hct     	(defaul.=32)d 	0====== ===  uNo  in
   y ms  h==gth===== ==gd 	1 ====== ==  u1.o und === gt h ength=nhhn====d 	9 ====== ==  u9 ive o  yo under "gth=nhhn====d se VALUE hc      	(defaul.=32)d 	0====== ===  uNo  in
   y ms  h==gth===== ==gd 	1 ====== ==  uAl  H";s li  engt===== gt == ==d 	2 ====== ==  uNon   gt =====   ===nh ength=n d se VALUE hchgro  	(defaul.=32)d 	0====== ===  uNo  in
   y ms   HCHI==  2" e= d 	1====== ===  u1aCppor === gt h ength=nhhn====d 	9 ====== ==  u9 ive o  yo under "gth=nhhn====d se VALUE hc  nrr 	(defaul.=32)d 	0====== ===  uNo  in
   y ms  h==gth===== ==gd 	1 ====== ==  uAl  H";s li  engt===== gt == ==d 	2 ====== ==  uNon   gt =====   ===nh ength=n d se VALUE hchgr   	(defaul.=32)d 	0====== ===  uNo  in
   y ms   HCHINRH= 2" e=d 	1====== ===  u1aCppor === gt h ength=nhhn====d 	9 ====== ==  u9 ive o  yo under "gth=nhhn====d se VALUE hh5to18l	(defaul.=32)d 	0====== ===  uNon   gt =====   ===nh ength=n d se VALUE hhotlun 	(defaul.=32)d 	0====== ===  uNo  in
   y ms  h==gth===== ==gd 	1 ====== ==  uAl  H";s li  engt===== gt == ==d 	2 ====== ==  uNon   gt =====   ===nh ength=n d se VALUE hhotro  	(defaul.=32)d 	0====== ===  uNo  in
   y ms  h==gth===== ==gd 	1 ====== ==  u1.o und === gt h ength=nhhn====d 	9 ====== ==  u9 ive o  yo under "gth=nhhn====d se VALUE hf      	(defaul.=32)d 	0====== ===  uNo  in
   y ms  h==gth===== ==gd 	1 ====== ==  uSuliaom als"gt= h==gth===== ==gd 	2 ====== ==  uNon   gt =====   ===nh ength=n d se VALUE hf      	(defaul.=32)d 	0====== ===  uNo  in
   y ms  h==gth===== ==gd 	1 ====== ==  u1rh==== length========en===== =d 	9 ====== ==  u9 ive o   === gt h ength=nhhn==d se VALUE hp      	(defaul.=32)d 	0====== ===  uNo  in
   y ms  h==gth===== ==gd 	1 ====== ==  uYesrh==== length========en=====d 	2 ====== ==  uNorh==== length========en===== d se VALUE hlorest 	(defaul.=32)d 	0====== ===  uNo  in
   y ms  h==gth===== ==gd 	1 ====== ==  uYesrh==== length========en=====d 	2 ====== ==  uNorh==== length========en===== d se VALUE h    sp 	(defaul.=32)d 	0====== ===  uNo  in
   y ms  h==gth===== ==gd 	1 ====== ==  uYesrh==== length========en=====d 	2 ====== ==  uNorh==== length========en===== d se VALUE h       	(defaul.=32)d 	0====== ===  uNo  in
   y ms  h==gth===== ==gd 	1 ====== ==  u1rh==== length========en===== =d 	9 ====== ==  u9 ive o   === gt h ength=nhhn==d se VALUE h    m  	(defaul.=32)d 	0====== ===  uNo  in
   y ms  h==gth===== ==gd 	1 ====== ==  u1.cover gth===== th=====   en==d 	12====== ==  u12=Movere === gt h ength=nhhn==d se VALUE h d  len	(defaul.=32)d 	0====== ===  uNo  in
   y ms  h==gth===== ==gd se VALUE henga   	(defaul.=32)d 	0====== ===  uNo  in
   y ms  h==gth===== ==gd 	1 ====== ==  uYesrh==== length========en=====d 	2 ====== ==  uNorh==== length========en===== d se VALUE heng  le	(defaul.=32)d 	0====== ===  uNo  in
   y ms  h==gth===== ==gd se VALUE hino_ws 	(defaul.=32)d 	0====== ===  uNo  in
   y ms  h==gth===== ==gd 	1 ====== ==  uYesrh==== length========en=====d 	2 ====== ==  uNorh==== length========en===== d se VALUE h       	(defaul.=32)d 	0====== ===  uNon  H";    in
   y ms  h==gth=d se VALUE hino_s  	(defaul.=32)d 	0====== ===  uNo  in
   y ms  h==gth===== ==gd 	1 ====== ==  uYesrh==== length========en=====d 	2 ====== ==  uNorh==== length========en===== d se VALUE h       	(defaul.=32)d 	0====== ===  uNon  H";    in
   y ms  h==gth=d se VALUE hino_fr 	(defaul.=32)d 	0====== ===  uNo  in
   y ms  h==gth===== ==gd 	1 ====== ==  uYesrh==== length========en=====d 	2 ====== ==  uNorh==== length========en===== d se VALUE hfr     	(defaul.=32)d 	0====== ===  uNon  H";    in
   y ms  h==gth=d se VALUE hino_u  	(defaul.=32)d 	0====== ===  uNo  in
   y ms  h==gth===== ==gd 	1 ====== ==  uYesrh==== length========en=====d 	2 ====== ==  uNorh==== length========en===== d se VALUE huc     	(defaul.=32)d 	0====== ===  uNon  H";    in
   y ms  h==gth=d se VALUE hino_w  	(defaul.=32)d 	0====== ===  uNo  in
   y ms  h==gth===== ==gd 	1 ====== ==  uYesrh==== length========en=====d 	2 ====== ==  uNorh==== length========en===== d se VALUE hwc     	(defaul.=32)d 	0====== ===  uNon  H";    in
   y ms  h==gth=d se VALUE h s     	(defaul.=32)d 	0====== ===  uNo  in
   y ms  h==gth===== ==gd 	1 ====== ==  uYesrh==== length========en=====d 	2 ====== ==  uNorh==== length========en===== d se VALUE hs      	(defaul.=32)d 	0====== ===  uNon  H";    in
   y ms  h==gth=d se VALUE h       	(defaul.=32)d 	0====== ===  uNo  in
   y ms  h==gth===== ==gd 	1 ====== ==  uYesrh==== length========en=====d 	2 ====== ==  uNorh==== length========en===== d se VALUE hs i  le	(defaul.=32)d 	0====== ===  uNon   gt =====   ===nh ength=n d se VALUE h       	(defaul.=32)d 	0====== ===  uNo  in
   y ms  h==gth===== ==gd 	1 ====== ==  uYesrh==== length========en=====d 	2 ====== ==  uNorh==== length========en===== d se VALUE h     le	(defaul.=32)d 	0====== ===  uNon   gt =====   ===nh ength=n d se VALUE h       	(defaul.=32)d 	0====== ===  uNo  in
   y ms  h==gth===== ==gd 	1 ====== ==  uYesrh==== length========en=====d 	2 ====== ==  uNorh==== length========en===== d se VALUE hv      	(defaul.=32)d 	0====== ===  uNon  H";    in
   y ms  h==gth=d se VALUE h       	(defaul.=32)d 	0====== ===  uNo  in
   y ms  h==gth===== ==gd 	1 ====== ==  uYesrh==== length========en=====d 	2 ====== ==  uNorh==== length========en===== d se VALUE h       	(defaul.=32)d 	0====== ===  uNon  H";    in
   y ms  h==gth=d se VALUE h       	(defaul.=32)d 	0====== ===  uNo  in
   y ms  h==gth===== ==gd 	1 ====== ==  uYesrh==== length========en=====d 	2 ====== ==  uNorh==== length========en===== d se VALUE h       	(defaul.=32)d 	0====== ===  uNon  H";    in
   y ms  h==gth=d se VALUE hr      	(defaul.=32)d 	0====== ===  uNo  in
   y ms  h==gth===== ==gd 	1 ====== ==  uYesrh==== length========en=====d 	2 ====== ==  uNorh==== length========en===== d se VALUE hr      	(defaul.=32)d 	0====== ===  uNon  H";    in
   y ms  h==gth=d se VALUE hsn     	(defaul.=32)d 	0====== ===  uNo  in
   y ms  h==gth===== ==gd 	1 ====== ==  uYesrh==== length========en=====d 	2 ====== ==  uNorh==== length========en===== d se VALUE hsn     	(defaul.=32)d 	0====== ===  uNon  H";    in
   y ms  h==gth=d se VALUE h  v    	(defaul.=32)d 	0====== ===  uNo  in
   y ms  h==gth===== ==gd 	1 ====== ==  uYesrh==== length========en=====d 	2 ====== ==  uNorh==== length========en===== d se VALUE h  v    	(defaul.=32)d 	0====== ===  uNon  H";    in
   y ms  h==gth=d se VALUE hrn     	(defaul.=32)d 	0====== ===  uNo  in
   y ms  h==gth===== ==gd 	1 ====== ==  uYesrh==== length========en=====d 	2 ====== ==  uNorh==== length========en===== d se VALUE hrn     	(defaul.=32)d 	0====== ===  uNon  H";    in
   y ms  h==gth=d se VALUE h       	(defaul.=32)d 	0====== ===  uNo  in
   y ms  h==gth===== ==gd 	1 ====== ==  uYesrh==== length========en=====d 	2 ====== ==  uNorh==== length========en===== d se VALUE hed  len	(defaul.=32)d 	0====== ===  uNon  H";    in
   y ms  h==gth=d se VALUE h       	(defaul.=32)d 	0====== ===  uNo  in
   y ms  h==gth===== ==gd 	1 ====== ==  uYesrh==== length========en=====d 	2 ====== ==  uNorh==== length========en===== d se VALUE h       	(defaul.=32)d 	0====== ===  uNon  H";    in
   y ms  h==gth=d se VALUE h       	(defaul.=32)d 	0====== ===  uNo  in
   y ms  h==gth===== ==gd 	1 ====== ==  uYesrh==== length========en=====d 	2 ====== ==  uNorh==== length========en===== d se VALUE h       	(defaul.=32)d 	0====== ===  uNon  H";    in
   y ms  h==gth=d se VALUE h       	(defaul.=32)d 	0====== ===  uNo  in
   y ms  h==gth===== ==gd 	1 ====== ==  uYesrh==== length========en=====d 	2 ====== ==  uNorh==== length========en===== d se VALUE h       	(defaul.=32)d 	0====== ===  uNon  H";    in
   y ms  h==gth=d se VALUE h       	(defaul.=32)d 	0====== ===  uNo  in
   y ms  h==gth===== ==gd 	1 ====== ==  uYesrh==== length========en=====d 	2 ====== ==  uNorh==== length========en===== d se VALUE hoi  len	(defaul.=32)d 	0====== ===  uNon  H";    in
   y ms  h==gth=d se VALUE h       	(defaul.=32)d 	0====== ===  uNon  H";    in
   y ms  h==gth=d se VALUE h       	(defaul.=32)d 	0====== ===  uNon  H";    in
   y ms  h==gth=d se VALUE h       	(defaul.=32)d 	0====== ===  uNon  H";    in
   y ms  h==gth=d se VALUE hh      	(defaul.=32)d 	0====== ===  uNo  in
   y ms  h==gth===== ==gd 	1 ====== ==  uUnde  $2,500rh==== length======d 	2 ====== ==  u$2,500abom$4,999 h==gth===== ==d 	3 ====== ==  u$5,000abom$7,499 h==gth===== ==d 	4 ====== ==  u$7,500abom$9,999 h==gth===== ==d 	5 ====== ==  u$10,000abom$12,499 h==gth===== d 	6 ====== ==  u$12,500abom$14,999 h==gth===== d 	7 ====== ==  u$15,000abom$17,499 h==gth===== 
 	8 ====== ==  u$17,500abom$19,999 h==gth===== d 	9 ====== ==  u$20,000abom$22,499 h==gth===== d 	10====== ==  u$22,500abom$24,999 h==gth===== d 	11====== ==  u$25,000abom$27,499 h==gth===== 
 	12====== ==  u$27,500abom$29,999 h==gth===== d 	13====== ==  u$30,000abom$32,499 h==gth===== d 	14====== ==  u$32,500abom$34,999 h==gth===== d 	15====== ==  u$35,000abom$37,499 h==gth===== 
 	16====== ==  u$37,500abom$39,999 h==gth===== d 	17====== ==  u$40,000abom$42,499 h==gth===== d 	18====== ==  u$42,500abom$44,999 h==gth===== d 	19====== ==  u$45,000abom$47,499 h==gth===== 
 	20====== ==  u$47,500abom$49,999 h==gth===== d 	21====== ==  u$50,000abom$52,499 h==gth===== d 	22====== ==  u$52,500abom$54,999 h==gth===== d 	23====== ==  u$55,000abom$57,499 h==gth===== 
 	24====== ==  u$57,500abom$59,999 h==gth===== d 	25====== ==  u$60,000abom$62,499 h==gth===== d 	26====== ==  u$62,500abom$64,999 h==gth===== d 	27====== ==  u$65,000abom$67,499 h==gth===== 
 	28====== ==  u$67,500abom$69,999 h==gth===== d 	29====== ==  u$70,000abom$72,499 h==gth===== d 	30====== ==  u$72,500abom$74,999 h==gth===== d 	31====== ==  u$75,000abom$77,499 h==gth===== 
 	32====== ==  u$77,500abom$79,999 h==gth===== d 	33====== ==  u$80,000abom$82,499 h==gth===== d 	34====== ==  u$82,500abom$84,999 h==gth===== d 	35====== ==  u$85,000abom$87,499 h==gth===== 
 	36====== ==  u$87,500abom$89,999 h==gth===== d 	37====== ==  u$90,000abom$92,499 h==gth===== d 	38====== ==  u$92,500abom$94,999 h==gth===== d 	39====== ==  u$95,000abom$97,499 h==gth===== 
 	40====== ==  u$97,500abom$99,999 h==gth===== d 	41====== ==  u$100,000aary"by m h==gth===== =d se VALUE ht      	(defaul.=32)d 	0====== ===  uNo  in
   y ms  h==gth===== ==gd 	1 ====== ==  uYesrh==== length========en=====d 	2 ====== ==  uNorh==== length========en===== d se VALUE ht  id  	(defaul.=32)d 	0====== ===  uNo  in
   y ms  h==gth===== ==gd 	1 ====== ==  uYesrh==== length========en=====d 	2 ====== ==  uNorh==== length========en===== d se VALUE h       	(defaul.=32)d 	0====== ===  uNo  in
   y ms  h==gth===== ==gd 	1 ====== ==  uYesrh==== length========en=====d 	2 ====== ==  uNorh==== length========en===== d se VALUE hh      	(defaul.=32)d 	0====== ===  uNo  in
   y ms  h==gth===== ==gd 	1 ====== ==  uYesrh==== length========en=====d 	2 ====== ==  uNorh==== length========en===== d se VALUE hh      	(defaul.=32)d 	0====== ===  uNo  in
   y ms  (gro  "en===== d 	1 ====== ==  uPrim    f   le"=========en=====d 	2 ====== ==  uNon    ly,huaseof"; m livgra ==d 	3 ====== ==  uNon    ly,huaseof"; m livgra ==d se VALUE hge 191h	(defaul.=32)d 	0====== ===  uNon   gt =====   ===nh ength=n d se VALUE htop5pct	(defaul.=32)d 	0====== ===  uNo  in
   y ms  (gro  "en===== d 	1 ====== ==  uInabop 5 sitcnin gth===== th===d 	2 ====== ==  uNo  in
bop 5 sitcnin gth===== td se VALUE h ctcu  	(defaul.=32)d 	0====== ===  uNo  in
   y ms  (gro  "en===== d 	1 ====== ==  uLowe   5 sitcnin gth===== th===d 	2 ====== ==  uSec me"5 sitcnin gth===== th===d 	20====== ==  uTop 5 sitcnin gth===== th==== td se VALUE h1 enur 	(defaul.=32)d 	0====== ===  uNo    ng   gt =====   ===nh=en=d 	1 ====== ==  uVa ualto blank  gt =====   ===nd 	4 ====== ==  uAll flae;"== ength===== th=====d se VALUE h1livqrt	(defaul.=32)d 	0====== ===  uNo    ng   gt =====   ===nh=en=d 	4 ====== ==  uAll flae;"== ength===== th=====d 	7 ====== ==  uBlanklto NA - noderror"====ngt=d se VALUE h1 elhhd	(defaul.=32)d 	0====== ===  uNo    ng   gt =====   ===nh=en=d 	1 ====== ==  uVa ualto blank  gt =====   ===nd 	4 ====== ==  uAll flae;"== ength===== th=====d se VALUE h1 elavl	(defaul.=32)d 	0====== ===  uNo    ng   gt =====   ===nh=en=d 	1 ====== ==  uVa ualto blank  gt =====   ===nd 	4 ====== ==  uAll flae;"== ength===== th=====d se VALUE h1 elint	(defaul.=32)d 	0====== ===  uNo    ng   gt =====   ===nh=en=d 	1 ====== ==  uVa ualto blank  gt =====   ===nd 	4 ====== ==  uAll flae;"== ength===== th=====d se VALUE i_hhotlu	(defaul.=32)d 	0====== ===  uNo    ng   gt =====   ===nh=en=d 	1 ====== ==  uAll flae;"== ength===== th=====d se VALUE i_hhotno	(defaul.=32)d 	0====== ===  uNo    ng   gt =====   ===nh=en=d 	1 ====== ==  uAll flae;"== ength===== th=====d se VALUE i_hf    	(defaul.=32)d 	0====== ===  uNo    ng   gt =====   ===nh=en=d 	1 ====== ==  uAll flae;"== ength===== th=====d se VALUE i_hf   n	(defaul.=32)d 	0====== ===  uNo    ng   gt =====   ===nh=en=d 	1 ====== ==  uAll flae;"== ength===== th=====d se VALUE i_hp    	(defaul.=32)d 	0====== ===  uNo    ng   gt =====   ===nh=en=d 	1 ====== ==  uAll flae;"== ength===== th=====d se VALUE i_hlores	(defaul.=32)d 	0====== ===  uNo    ng   gt =====   ===nh=en=d 	1 ====== ==  uAll flae;"== ength===== th=====d se VALUE i_hf   s	(defaul.=32)d 	0====== ===  uNo    ng   gt =====   ===nh=en=d 	1 ====== ==  uAll flae;"== ength===== th=====d se VALUE i_hfd   	(defaul.=32)d 	0====== ===  uNo    ng   gt =====   ===nh=en=d 	1 ====== ==  uAll flae;"== ength===== th=====d se VALUE i_hf   s	(defaul.=32)d 	0====== ===  uNo    ng   gt =====   ===nh=en=d 	1 ====== ==  uAll flae;"== ength===== th=====d se VALUE i_hf   m	(defaul.=32)d 	0====== ===  uNo    ng   gt =====   ===nh=en=d 	1 ====== ==  uAll flae;"== ength===== th=====d se VALUE i_henga 	(defaul.=32)d 	0====== ===  uNo    ng   gt =====   ===nh=en=d 	1 ====== ==  uAll flae;"== ength===== th=====d se VALUE i_hengva	(defaul.=32)d 	0====== ===  uNo    ng   gt =====   ===nh=en=d 	1 ====== ==  uAll flae;"== ength===== th=====d se VALUE prop    	(defaul.=32)d 	0====== ===  uNon   gt =====   ===nh ength=n d se VALUE huas    	(defaul.=32)d 	0====== ===  uNon   gt =====   ===nh ength=n d se VALUE hr      	(defaul.=32)d 	0====== ===  uNon-int?"; ew iuaseof";"== engtd 	1 ====== ==  ususbary/        m    f   le"===d 	2 ====== ==  ususbary/        m    f   le"===d 	3 ====== ==  uUnmarriedinC?glian
mal "=== ===d 	4 ====== ==  uUnmarriedinC?glian
femal "=== =d 	5 ====== ==  uPr m    f   le,huaseof"; -"=== d 	6 ====== ==  uCC?glian
mal  non    ly" lengthd 	7 ====== ==  uCC?glian
femal  non    ly" lengd 	8 ====== ==  uNon    ly,huaseof"; m h==gth===d 	9 ====== ==  uGro   qu"ener  wi   actuas"gt= d 	10====== ==  uGro   qu"ener  wi   sec me   
gd se VALUE i_h     	(defaul.=32)d 	0====== ===  uNo    ng   gt =====   ===nh=en=d 	1 ====== ==  uAll flae;"== ength===== th=====d se VALUE hrta    	(defaul.=32)d 	0====== ===  uNIU === gt h ength=nhh===nh=en=d 	1 ====== ==  uYESrh==== length========en=====d 	2 ====== ==  uNOrh==== length========en===== d se VALUE hrnumta 	(defaul.=32)d 	0====== ===  uNIU === gt h ength=nhh===nh=en=d se VALUE hr      	(defaul.=32)d 	0====== ===  uNIU === gt h ength=nhh===nh=en=d 	1 ====== ==  uYESrh==== length========en=====d 	2 ====== ==  uNOrh==== length========en===== d se VALUE hrnumc  	(defaul.=32)d 	0====== ===  uNIU === gt h ength=nhh===nh=en=d se VALUE hr      	(defaul.=32)d 	0====== ===  uNIU === gt h ength=nhh===nh=en=d 	1 ====== ==  uYESrh==== length========en=====d 	2 ====== ==  uNOrh==== length========en===== d se VALUE hra   ys	(defaul.=32)d 	0====== ===  uNIU === gt h ength=nhh===nh=en=d 	1 ====== ==  uYESrh==== length========en=====d 	2 ====== ==  uNOrh==== length========en===== d se VALUE hr      	(defaul.=32)d 	0====== ===  uNIU === gt h ength=nhh===nh=en=d 	1 ====== ==  uYESrh==== length========en=====d 	2 ====== ==  uNOrh==== length========en===== d se VALUE hr r    	(defaul.=32)d 	0====== ===  uNIU === gt h ength=nhh===nh=en=d 	1 ====== ==  uYESrh==== length========en=====d 	2 ====== ==  uNOrh==== length========en===== d se VALUE hr t    	(defaul.=32)d 	0====== ===  uNIU === gt h ength=nhh===nh=en=d 	1 ====== ==  uYESrh==== length========en=====d 	2 ====== ==  uNOrh==== length========en===== d se VALUE hrschlys	(defaul.=32)d 	0====== ===  uNIU === gt h ength=nhh===nh=en=d 	1 ====== ==  uYESrh==== length========en=====d 	2 ====== ==  uNOrh==== length========en===== d se VALUE hr ic   	(defaul.=32)d 	0====== ===  uNIU === gt h ength=nhh===nh=en=d 	1 ====== ==  uYESrh==== length========en=====d 	2 ====== ==  uNOrh==== length========en===== d se VALUE f       	(defaul.=32)d 	2 ====== ==  uF   ly,       h==gth===== ==== d se VALUE fk      	(defaul.=32)d 	1 ====== ==  ususbary-     f   le"=========end 	2 ====== ==  uMal  referes/w        h==gth===d 	3 ====== ==  uFemal  referes/w        h==gth=d se VALUE f       	(defaul.=32)d 	1 ====== ==  uPrim    f   le"=========en=====d 	2 ====== ==  uNon    ly,huaseof"; m h==gth===d 	3 ====== ==  uRel worksubf   le"=========en==d 	4 ====== ==  uUnrel worksubf   le"=========end 	5 ====== ==  uSec me       tincuas"gt= ==gth=d se VALUE f    id 	(defaul.=32)d 	0====== ===  uNo     rh==== length========en=d se VALUE fhusbid 	(defaul.=32)d 	0====== ===  uNo husbaryrh==== length========d se VALUE fspouid 	(defaul.=32)d 	0====== ===  uNo spous  h==gth===== ==g======d se VALUE fownu6  	(defaul.=32)d 	0====== ===  uNon ,;    in
   y ms  h==gth=n=d 	1 ====== ==  u1rh==== length========en===== =d 	2 ====== ==  u2rh==== length========en===== =d 	6 ====== ==  u6+ === gt h ength=nhh h=g======d se VALUE fownu18l	(defaul.=32)d 	0====== ===  uNon ,;    in
   y ms  h==gth=n=d 	1 ====== ==  u1rh==== length========en===== =d 	9 ====== ==  u9 ive o   === gt h ength=nhhn==d se VALUE f  lu6  	(defaul.=32)d 	0====== ===  uNon ,;    in
   y ms  h==gth=n=d 	1 ====== ==  u1rh==== length========en===== =d 	2 ====== ==  u2rh==== length========en===== =d 	6 ====== ==  u6+ === gt h ength=nhh h=g======d se VALUE f  lu18l	(defaul.=32)d 	0====== ===  uNon ,;    in
   y ms  h==gth=n=d 	1 ====== ==  u1rh==== length========en===== =d 	2 ====== ==  u2rh==== length========en===== =d 	9 ====== ==  u9+ === gt h ength=nhh h=g======d se VALUE f ctcu  	(defaul.=32)d 	0====== ===  uNIU (FTYPE=2+)"=========en=====d 	1 ====== ==  uLowe   5 sitcnin gth===== th===d 	2 ====== ==  uSec me"5 sitcnin gth===== th===d 	20====== ==  uTop 5 sitcnin gth===== th==== td se VALUE f  li   	(defaul.=32)d 	1 ====== ==  uBelow low-;     aleves"gt= ==gtd 	2 ====== ==  u100a- 124 sitcnin hs a lilow-"=d 	3 ====== ==  u125p- 149 sitcnin hs a lilow-"=d 	4 ====== ==  u150 sitcnin ary"abiv  a l" lengd se VALUE povlleng	(defaul.=32)d 	1 ====== ==  uUnde  .50rh==== length=======gtd 	2 ====== ==  u.50lto .74rh==== length========d 	3 ====== ==  u.75lto .99 h==gth===== ========d 	4 ====== ==  u1.00abom1.24rh==== length======d 	5 ====== ==  u1.25abom1.49 h==gth===== ======d 	6 ====== ==  u1.50lto 1.74rh==== length======d 	7 ====== ==  u1.75lto 1.99 h==gth===== ======d 	8 ====== ==  u2.00abom2.49 h==gth===== ======d 	9 ====== ==  u2.50abom2.99 h==gth===== ======d 	10====== ==  u3.00abom3.49 h==gth===== ======d 	11====== ==  u3.50abom3.99 h==gth===== ======d 	12====== ==  u4.00abom4.49 h==gth===== ======d 	13====== ==  u4.50abom4.99 h==gth===== ======d 	14====== ==  u5.00aary"by m h==gth===== =====d se VALUE f spov  	(defaul.=32)d 	0====== ===  uNo  in
   y ms  h==gth===== ==gd 	1 ====== ==  uUnde  .50rh==== length=======gtd 	2 ====== ==  u.50lto .74rh==== length========d 	3 ====== ==  u.75lto .99 h==gth===== ========d 	4 ====== ==  u1.00abom1.24rh==== length======d 	5 ====== ==  u1.25abom1.49 h==gth===== ======d 	6 ====== ==  u1.50lto 1.74rh==== lengt ======d 	7 ====== ==  u1.75lto 1.99 h==gth===== ======d 	8 ====== ==  u2.00abom2.49 h==gth===== ======d 	9 ====== ==  u2.50abom2.99 h==gth===== ======d 	10====== ==  u3.00abom3.49 h==gth===== ======d 	11====== ==  u3.50abom3.99 h==gth===== ======d 	12====== ==  u4.00abom4.49 h==gth===== ======d 	13====== ==  u4.50abom4.99 h==gth===== ======d 	14====== ==  u5.00aary"by m h==gth===== =====d se VALUE fino_ws 	(defaul.=32)d 	1 ====== ==  uYesrh==== length========en=====d 	2 ====== ==  uNorh==== length========en===== d se VALUE fino_s  	(defaul.=32)d 	1 ====== ==  uYesrh==== length========en=====d 	2 ====== ==  uNorh==== length========en===== d se VALUE f       	(defaul.=32)d 	0====== ===  uNon  H";    in
   y ms  h==gth=d se VALUE fino_fr 	(defaul.=32)d 	1 ====== ==  uYesrh==== length========en=====d 	2 ====== ==  uNorh==== length========en===== d se VALUE ffr     	(defaul.=32)d 	0====== ===  uNon  H";    in
   y ms  h==gth=d se VALUE fino_u  	(defaul.=32)d 	1 ====== ==  uYesrh==== length========en=====d 	2 ====== ==  uNorh==== length========en===== d se VALUE fuc     	(defaul.=32)d 	0====== ===  uNon  H";    in
   y ms  h==gth=d se VALUE fino_w  	(defaul.=32)d 	1 ====== ==  uYesrh==== length========en=====d 	2 ====== ==  uNorh==== length========en===== d se VALUE fwc     	(defaul.=32)d 	0====== ===  uNon  H";    in
   y ms  h==gth=d se VALUE fino_ss 	(defaul.=32)d 	1 ====== ==  uYesrh==== length========en=====d 	2 ====== ==  uNorh==== length========en===== d se VALUE fs      	(defaul.=32)d 	0====== ===  uNon  H";    in
   y ms  h==gth=d se VALUE fino_ss 	(defaul.=32)d 	1 ====== ==  uYesrh==== length========en=====d 	2 ====== ==  uNorh==== length========en===== d se VALUE fs i  le	(defaul.=32)d 	0====== ===  uNon   gt =====   ===nh ength=n d se VALUE fino_paw	(defaul.=32)d 	1 ====== ==  uYesrh==== length========en=====d 	2 ====== ==  uNorh==== length========en===== d se VALUE f     le	(defaul.=32)d 	0====== ===  uNon   gt =====   ===nh ength=n d se VALUE fino_vet	(defaul.=32)d 	1 ====== ==  uYesrh==== length========en=====d 	2 ====== ==  uNorh==== length========en===== d se VALUE fv      	(defaul.=32)d 	0====== ===  uNon  H";    in
   y ms  h==gth=d se VALUE fino_su 	(defaul.=32)d 	1 ====== ==  uYesrh==== length========en=====d 	2 ====== ==  uNorh==== length========en===== d se VALUE fs      	(defaul.=32)d 	0====== ===  uNon  H";    in
   y ms  h==gth=d se VALUE fino_di 	(defaul.=32)d 	1 ====== ==  uYesrh==== length========en=====d 	2 ====== ==  uNorh==== length========en===== d se VALUE f       	(defaul.=32)d 	0====== ===  uNon  H";    in
   y ms  h==gth=d se VALUE fino_ret	(defaul.=32)d 	1 ====== ==  uYesrh==== length========en=====d 	2 ====== ==  uNorh==== length========en===== d se VALUE fr      	(defaul.=32)d 	0====== ===  uNon  H";    in
   y ms  h==gth=d se VALUE fino_int	(defaul.=32)d 	1 ====== ==  uYesrh==== length========en=====d 	2 ====== ==  uNorh==== length========en===== d se VALUE fin     	(defaul.=32)d 	0====== ===  uNon  H";    in
   y ms  h==gth=d se VALUE fino_div	(defaul.=32)d 	1 ====== ==  uYesrh==== length========en=====d 	2 ====== ==  uNorh==== length========en===== d se VALUE f  v    	(defaul.=32)d 	0====== ===  uNon  H";    in
   y ms  h==gth=d se VALUE fino_rnt	(defaul.=32)d 	1 ====== ==  uYesrh==== length========en=====d 	2 ====== ==  uNorh==== length========en===== d se VALUE frn     	(defaul.=32)d 	0====== ===  uNon  H";    in
   y ms  h==gth=d se VALUE fino_e  	(defaul.=32)d 	1 ====== ==  uYesrh==== length========en=====d 	2 ====== ==  uNorh==== length========en===== d se VALUE fed  len	(defaul.=32)d 	0====== ===  uNon  H";    in
   y ms  h==gth=d se VALUE fino_csp	(defaul.=32)d 	1 ====== ==  uYesrh==== length========en=====d 	2 ====== ==  uNorh==== length========en===== d se VALUE f       	(defaul.=32)d 	0====== ===  uNon  H";    in
   y ms  h==gth=d se VALUE fino_alm	(defaul.=32)d 	1 ====== ==  uYesrh==== length========en=====d 	2 ====== ==  uNorh==== length========en===== d se VALUE f       	(defaul.=32)d 	0====== ===  uNon  H";    in
   y ms  h==gth=d se VALUE fino_fis	(defaul.=32)d 	1 ====== ==  uYesrh==== length========en=====d 	2 ====== ==  uNorh==== length========en===== d se VALUE ff      	(defaul.=32)d 	0====== ===  uNon  H";    in
   y ms  h==gth=d se VALUE fino_oi 	(defaul.=32)d 	1 ====== ==  uYesrh==== length========en=====d 	2 ====== ==  uNorh==== length========en===== d se VALUE foi  len	(defaul.=32)d 	0====== ===  uNon  H";    in
   y ms  h==gth=d se VALUE f       	(defaul.=32)d 	0====== ===  uNon  H";    in
   y ms  h==gth=d se VALUE f       	(defaul.=32)d 	0====== ===  uNon  H";    in
   y ms  h==gth=d se VALUE f       	(defaul.=32)d 	0====== ===  uNon   gt =====   ===nh ength=n d se VALUE f   _rng	(defaul.=32)d 	1 ====== ==  uUnde  $2,500rh==== length======d 	2 ====== ==  u$2,500abom$4,999 h==gth===== ==d 	3 ====== ==  u$5,000abom$7,499 h==gth===== ==d 	4 ====== ==  u$7,500abom$9,999 h==gth===== ==d 	5 ====== ==  u$10,000abom$12,499 h==gth===== d 	6 ====== ==  u$12,500abom$14,999 h==gth===== d 	7 ====== ==  u$15,000abom$17,499 h==gth===== 
 	8 ====== ==  u$17,500abom$19,999 h==gth===== d 	9 ====== ==  u$20,000abom$22,499 h==gth===== d 	10====== ==  u$22,500abom$24,999 h==gth===== d 	11====== ==  u$25,000abom$27,499 h==gth===== 
 	12====== ==  u$27,500abom$29,999 h==gth===== d 	13====== ==  u$30,000abom$32,499 h==gth===== d 	14====== ==  u$32,500abom$34,999 h==gth===== d 	15====== ==  u$35,000abom$37,499 h==gth===== 
 	16====== ==  u$37,500abom$39,999 h==gth===== d 	17====== ==  u$40,000abom$42,499 h==gth===== d 	18====== ==  u$42,500abom$44,999 h==gth===== d 	19====== ==  u$45,000abom$47,499 h==gth===== 
 	20====== ==  u$47,500abom$49,999 h==gth===== d 	21====== ==  u$50,000abom$52,499 h==gth===== d 	22====== ==  u$52,500abom$54,999 h==gth===== d 	23====== ==  u$55,000abom$57,499 h==gth===== 
 	24====== ==  u$57,500abom$59,999 h==gth===== d 	25====== ==  u$60,000abom$62,499 h==gth===== d 	26====== ==  u$62,500abom$64,999 h==gth===== d 	27====== ==  u$65,000abom$67,499 h==gth===== 
 	28====== ==  u$67,500abom$69,999 h==gth===== 
 	29====== ==  u$70,000abom$72,499 h==gth===== d 	30====== ==  u$72,500abom$74,999 h==gth===== d 	31====== ==  u$75,000abom$77,499 h==gth===== 
 	32====== ==  u$77,500abom$79,999 h==gth===== d 	33====== ==  u$80,000abom$82,499 h==gth===== d 	34====== ==  u$82,500abom$84,999 h==gth===== d 	35====== ==  u$85,000abom$87,499 h==gth===== 
 	36====== ==  u$87,500abom$89,999 h==gth===== d 	37====== ==  u$90,000abom$92,499 h==gth===== d 	38====== ==  u$92,500abom$94,999 h==gth===== d 	39====== ==  u$95,000abom$97,499 h==gth===== d 	40====== ==  u$97,500abom$99,999 h==gth===== d 	41====== ==  u$100,000aary"by m h==gth===== =d se VALUE fspanish	(defaul.=32)d 	1 ====== ==  uYesrh==== length========en=====d 	2 ====== ==  uNorh==== length========en===== d se VALUE f_mv_fs 	(defaul.=32)d 	0====== ===  uNon   gt =====   ===nh ength=n d se VALUE f_mv_s  	(defaul.=32)d 	0====== ===  uNon   gt =====   ===nh ength=n d se VALUE ffng    	(defaul.=32)d 	0====== ===  uNon   gt =====   ===nh ength=n d se VALUE ffng  id	(defaul.=32)d 	0====== ===  uNon   gt =====   ===nh ength=n d se VALUE fhuassub	(defaul.=32)d 	0====== ===  uNon   gt =====   ===nh ength=n d se VALUE ffoodreq	(defaul.=32)d 	0====== ===  uNon   gt =====   ===nh ength=n d se VALUE fhuasreq	(defaul.=32)d 	0====== ===  uNon   gt =====   ===nh ength=n d se VALUE p       	(defaul.=32)d 	3 ====== ==  uP     ,       h==gth===== ==== d se VALUE a_parest	(defaul.=32)d 	0====== ===  uNon   gt =====   ===nh ength=n d se VALUE a_exprrp	(defaul.=32)d 	1 ====== ==  uReferes/w        wi   rel w y s"d 	2 ====== ==  uReferes/w        wi  oun gth===d 	3 ====== ==  uHusbaryrh==== length======== ==d 	4 ====== ==  uW   rh==== length========en= ==d 	5 ====== ==  uOwn.o und === gt h ength=nhhn==d 	7 ====== ==  uGraryo und === gt h ength=nhhn=
 	8 ====== ==  uParnin gth===== th=====  =nhhn=
 	9 ====== ==  uBr   er/sist m h==gth===== ====d 	10====== ==  uO  er rel w y  h==gth===== ====d 	11====== ==  uFost m.o und === gt h ength=nhh
 	12====== ==  uNonrel w y  wi   rel w y s"=nhh
 	13====== ==  uPartner/roommat  h==gth===== ==d 	14====== ==  uNonrel w y  wi  oun rel w y s"=d se VALUE a_ag    	(defaul.=32)d 	80====== ==  u80-84 y   s hs ag   gt =====   
 	85====== ==  u85+ y   s hs ag   gt =====   n d se VALUE a_marit 	(defaul.=32)d 	1 ====== ==  uMarriedi-inC?glian
spous  h==gtd 	2 ====== ==  uMarriedi-iAF
spous  p  snin gthd 	3 ====== ==  uMarriedi-ispous  absnin (exc"==d 	4 ====== ==  uW dowe;"== ength===== th=======d 	5 ====== ==  uDivorce;"== ength===== th======d 	6 ====== ==  uSeparlae;"== ength===== th=====d 	7 ====== ==  uNey m married h==gth===== ==== d se VALUE a_spous 	(defaul.=32)d 	0====== ===  uNon  H";o under "gth=nhhn===== d se VALUE a_sex ng	(defaul.=32)d 	1 ====== ==  uMal "=== === ength===== th=====d 	2 ====== ==  uFemal "=== === ength===== th===d se VALUE a_hgleng	(defaul.=32)d 	0====== ===  uC under "gth=nhhn=====  th=====d 	31====== ==  uLess than
1st grad "=== === eng
 	32====== ==  u1st,2nd,3rd,H";4   grad "=== ==d 	33====== ==  u5   H";6   grad "=== == === eng
 	34====== ==  u7   ary"8   grad "=== == === end 	35====== ==  u9   grad "=== == === eng === end 	36====== ==  u10   grad "=== == === eng === ed 	37====== ==  u11   grad "=== == === eng === ed 	38====== ==  u12   grad  noddiplula === gt h d 	39====== ==  uHigh school gradulaei-ihigh gthd 	40====== ==  uSuliacolleg  bun noddegre   gt d 	41====== ==  uAssocilaeidegre  in
colleg  -"=d 	42====== ==  uAssocilaeidegre  in
colleg  -"=d 	43====== ==  uBachelor'sidegre  (for"====ngt=d 	44====== ==  uMast m'sidegre  (for"====ngt=t=d 	45====== ==  uProfessional school degre  (for"
 	46====== ==  uDoctorlaeidegre  (for"====ngt=td se VALUE p dtrac 	(defaul.=32)d 	1 ====== ==  uWhiaeionle"=========en=====t=t=d 	2 ====== ==  uBlackionle"=========en=====t=t=d 	3 ====== ==  uAmerican
Indian, h==gth===== ==d 	4 ====== ==  uAs   ionle"=========en=====t=t=d 	5 ====== ==  uHawaiin/Pacific Islan; m h==gthd 	6 ====== ==  uWhiae-Black"=========en=====t=td 	7 ====== ==  uWhiae-AI"gth=nhhn=====  th=====d 	8 ====== ==  uWhiae-As   "=========en=====t=td 	9 ====== ==  uWhiae-HP"gth=nhhn=====  th=====d 	10====== ==  uBlack-AI"gth=nhhn=====  th=====d 	11====== ==  uBlack-As   "=========en=====t=td 	12====== ==  uBlack-HP"gth=nhhn=====  th=====d 	13====== ==  uAI-As   "=========en=====t=t ==d 	14====== ==  uAs   -HP"gth=nhhn=====  th=====d 	15====== ==  uWhiae-Black-AI"gth=nhhn=====  t
 	16====== ==  uWhiae-Black-As   "=========en==d 	17====== ==  uWhiae-AI-As   "=========en=====d 	18====== ==  uWhiae-As   -HP"gth=nhhn=====  td 	19====== ==  uWhiae-Black-AI-As   "=========e
 	20====== ==  u2 H";3 rac srh==== length======d 	21====== ==  u4 H";5 rac srh==== length======d se VALUE p_    ng	(defaul.=32)d 	1 ====== ==  uCC?glian
15+ === gt h ength=nhhd 	2 ====== ==  uArmediForcesrh==== length======d 	3 ====== ==  uC under  0a- 14rh==== lengt ===d se VALUE pehspnos	(defaul.=32)d 	1 ====== ==  uYesrh==== length========en=====d 	2 ====== ==  uNorh==== length========en===== d se VALUE p dthsp 	(defaul.=32)d 	0====== ===  uNo  in
   y ms  h==gth===== ==gd 	1 ====== ==  uMexican"== ength===== th=======d 	2 ====== ==  uPuerto Rican"== ength===== th==d 	3 ====== ==  uCuban"== ength===== th=========d 	4 ====== ==  uCninral/Sounh American"====ngt=d 	5 ====== ==  uO  er Spanish h==gth===== ==== d se VALUE a_famnum	(defaul.=32)d 	0====== ===  uNot a f   le,memb m h==gth=====d 	1 ====== ==  uPr m    f   le,memb mionle"====d se VALUE a_famtyp	(defaul.=32)d 	1 ====== ==  uPrim    f   le"=========en=====d 	2 ====== ==  uNon    ly,huaseof"; m h==gth===d 	3 ====== ==  uRel worksubf   le"=========en==d 	4 ====== ==  uUnrel worksubf   le"=========end 	5 ====== ==  uSec me       tincuas"gt= ==gth=d se VALUE a_famrel	(defaul.=32)d 	0====== ===  uNot a f   le,memb m h==gth=====d 	1 ====== ==  uReferes/w        h==gth===== ==d 	2 ====== ==  uSpous  h==gth===== ==g=========d 	3 ====== ==  uCppor === gt h ength=nhhn======d 	4 ====== ==  uO  er rel w y  (   m   "n======d se VALUE a_pf  l 	(defaul.=32)d 	0====== ===  uNo  in
   m    f   le"===h=====d 	1 ====== ==  uHusbaryrh==== length======== ==d 	2 ====== ==  uW   rh==== length========en= ==d 	3 ====== ==  uOwn.o und === gt h ength=nhhn==d 	4 ====== ==  uO  er rel w y "=========en=====d 	5 ====== ==  uUnmarriedireferes/w        h==gd se VALUE hhd  l  	(defaul.=32)d 	1 ====== ==  usuaseof"; m h==gth========== ==d 	2 ====== ==  uSpous  hs huaseof"; m h==gth===d 	3 ====== ==  uUnde  18=y   s, singl  (ney m hd 	4 ====== ==  uUnde  18=y   s, ey m married h=d 	5 ====== ==  u18=y   saary"by m h==gth===== =d 	6 ====== ==  uO  er rel w y  hs huaseof"; m hd 	7 ====== ==  uNonrel w y  hs huaseof"; m h==gd 	8 ====== ==  uSec me       tincuas"gt= ==gth=d se VALUE famrel  	(defaul.=32)d 	1 ====== ==  uReferes/w        hs f   le"===hd 	2 ====== ==  uSpous  hs referes/w        h==gd 	3 ====== ==  uUnde  18=y   s, singl  (ney m hd 	4 ====== ==  uUnde  18=y   s, ey m married h=d 	5 ====== ==  u18=y   saary"by m h==gth===== =d 	6 ====== ==  uGraryo und hs referes/w        d 	7 ====== ==  uUnde  18=y   s, singl  (ney m hd 	8 ====== ==  uUnde  18=y   s, ey m married h=d 	9 ====== ==  u18=y   saary"by m h==gth===== =d 	10====== ==  uNon    ly,huaseof"; m h==gth===d 	11====== ==  uSec me       tincuas"gt= ==gth=d se VALUE hhdfmx  	(defaul.=32)d 	1 ====== ==  usuaseof"; m h==gth========== ==d 	2 ====== ==  uSpous  hs huaseof"; m h==gth===d 	3 ====== ==  uReferes/w        hs subf   le"=d 	4 ====== ==  uNo  in
aksubf   le"=========en=d 	5 ====== ==  uReferes/w        hs subf   le"=d 	6 ====== ==  uSpous  hs subf   le referes/w hd 	7 ====== ==  uNo  in
aksubf   le"=========en=d 	8 ====== ==  uHead hs aksubf   le"=========end 	9 ====== ==  uNo  in
aksubf   le"=========en=d 	10====== ==  uReferes/w        hs subf   le"=d 	11====== ==  uSpous  hs subf   le referes/w hd 	12====== ==  uNo  in
aksubf   le"=========en=d 	23====== ==  uReferes/w        hs subf   le"=d 	24====== ==  uC und hs aksubf   le"=========e
 	25====== ==  uNo  in
aksubf   le"=========en=d 	26====== ==  uReferes/w        hs subf   le"=d 	27====== ==  uSpous  hs subf   le referes/w hd 	28====== ==  uNo  us ;"== ength===== th======d 	29====== ==  uNo  in
aksubf   le"=========en=d 	30====== ==  uReferes/w        hs aksubf   le"d 	31====== ==  uNo  in
aksubf   le"=========en=d 	32====== ==  uReferes/w        hs subf   le"=d 	33====== ==  uSpous  hs subf   le referes/w hd 	34====== ==  uNo  in
aksubf   le"=========en=d 	35====== ==  uReferes/w        hs subf   le"=d 	36====== ==  uC und hs subf   le referes/w hed 	37====== ==  uNo  in
aksubf   le"=========en=d 	38====== ==  uReferes/w        hs subf   le"=d 	39====== ==  uSpous  hs subf   le referes/w hd 	40====== ==  uNo  in
aksubf   le"=========en=d 	41====== ==  uReferes/w        hs aksubf   le"d 	42====== ==  uNo  in
aksubf   le"=========en=d 	43====== ==  uReferes/w        hs subf   le"=d 	44====== ==  uSpous  hs subf   le referes/w hd 	45====== ==  uNo  in
aksubf   le"=========en=d 	46====== ==  uReferes/w        hs unrel wor hd 	47====== ==  uSpous  hs unrel worksubf   le"=d 	48====== ==  uC und < 18, singl  (ney m-"=== d 	49====== ==  uNon    ly,huaseof"; m h==gth===d 	50====== ==  uSec me       tincuas"gt= ==gth=d 	51====== ==  uIn gro   qu"ener  h==gth===== =d se VALUE parnin  	(defaul.=32)d 	0====== ===  uNo  in
   y ms  h==gth===== ==gd 	1 ====== ==  uBoth parnins p  snin gth=== ==gd 	2 ====== ==  uM   erionle p  snin gth=== ==g=d 	3 ====== ==  uFa  erionle p  snin gth=== ==g=d 	4 ====== ==  uNei  eriparnin p  snin gth=== =d se VALUE age1leng	(defaul.=32)d 	0====== ===  uNo  in
   y ms  h==gth===== ==gd 	1 ====== ==  u15=y   s"== ength===== th======d 	2 ====== ==  u16aary"17=y   s"== ength===== td 	3 ====== ==  u18=ary"19=y   s"== ength===== td 	4 ====== ==  u20aary"21=y   s"== ength===== td 	5 ====== ==  u22abom24=y   s"== ength===== thd 	6 ====== ==  u25abom29=y   s"== ength===== thd 	7 ====== ==  u30abom34=y   s"== ength===== thd 	8 ====== ==  u35abom39=y   s"== ength===== thd 	9 ====== ==  u40abom44=y   s"== ength===== thd 	10====== ==  u45abom49=y   s"== ength===== thd 	11====== ==  u50abom54=y   s"== ength===== thd 	12====== ==  u55abom59=y   s"== ength===== thd 	13====== ==  u60abom61=y   s"== ength===== t=d 	14====== ==  u62abom64=y   s"== ength===== thd 	15====== ==  u65abom69=y   s"== ength===== thd 	16====== ==  u70abom74=y   s"== ength===== thd 	17====== ==  u75=y   saary"by m h==gth===== =d se VALUE a_fnlwgt	(defaul.=32)d 	0====== ===  uSupplemninal Spanish sampl "===d se VALUE a_ernlwt	(defaul.=32)d 	0====== ===  uNo  in
   y ms  H";o under aary"d se VALUE a_hrs1l 	(defaul.=32)d 	-1====== ==  uNo  in
   y ms  h==gth===== ==gd 	0====== ===  uC under aary"ArmediForcesrh====d se VALUE a_uslf  	(defaul.=32)d 	0====== ===  uNo  in
   y ms  H";o under aary"d 	1 ====== ==  uYesrh==== length========en=====d 	2 ====== ==  uNorh==== length========en===== d se VALUE a_whyab 	(defaul.=32)d 	0====== ===  uNo  in
   y ms  H";o under aary"d 	1 ====== ==  uOwn.illnessrh==== length=======d 	2 ====== ==  uOn vacati   h==gth===== =======d 	3 ====== ==  uBad wea  er h==gth===== =======d 	4 ====== ==  uLabH";disput  h==gth===== == thd 	8 ====== ==  uO  er h==gth===== ======= == thd se VALUE a_payab 	(defaul.=32)d 	0====== ===  uNo  in
   y ms  H";o under aary"d 	1 ====== ==  uYesrh==== length========en=====d 	2 ====== ==  uNorh==== length========en===== d 	3 ====== ==  uSelf-employed h==gth===== ==== d se VALUE peio    	(defaul.=32)d 	0====== ===  uNo  in
   y ms  H";o under "== d se VALUE peiooc  	(defaul.=32)d 	0====== ===  uNo  in
   y ms  H";o under "== d se VALUE a_wkslk 	(defaul.=32)d 	-1====== ==  uNo  in
   y ms  h==gth===== ==gd 	0====== ===  uC under aH";ArmediForcesrh==== d se VALUE a_whenlj	(defaul.=32)d 	0====== ===  uNo  in
   y ms  H";o under aary"d 	1 ====== ==  uIn last 12=month  h==gth===== =d 	2 ====== ==  uM re than
12=month  agorh==== ld 	5 ====== ==  uNey m workediat als"gt= ==gth= d se VALUE a_clswk 	(defaul.=32)d 	0====== ===  uNo  in
   y ms  H";o under aary"d 	1 ====== ==  uPrivat  h==gth===== ==th===== =d 	2 ====== ==  uFe; mal gby mnmnin gth===== th=d 	3 ====== ==  uStlaeigby mnmnin gth===== th===d 	4 ====== ==  uLocal gby mnmnin gth===== th=end 	5 ====== ==  uSelf-employed-;   rporlae;"== ed 	6 ====== ==  uSelf-employed-    in  rporlae;"d 	7 ====== ==  uWi  oun pay h==gth===== =======d 	8 ====== ==  uNey m workedrh==== length======d se VALUE a_nlflj 	(defaul.=32)d 	0====== ===  uNo  in
   y ms  H";o under aary"d 	1 ====== ==  uWi  in
akpast 12=month  h==gth=d 	3 ====== ==  uM re than
12=month  agorh==== ld 	7 ====== ==  uNey m workedrh==== length======d se VALUE a_wantjb	(defaul.=32)d 	0====== ===  uNo  in
   y ms  H";o under aary"d 	1 ====== ==  uYesrh==== length========en=====d 	2 ====== ==  uNorh==== length========en===== d se VALUE peafey m	(defaul.=32)d 	-1====== ==  uNo  in
   y ms  h==gth===== ==gd 	1 ====== ==  uYesrh==== length========en=====d 	2 ====== ==  uNorh==== length========en===== d se VALUE peafwhna	(defaul.=32)d 	-1====== ==  uNo  in
   y ms  h==gth===== ==gd 	1 ====== ==  uSeptemb mi2001 H";l worrh==== ld 	2 ====== ==  uAugust 1990abomAugust 2001 h==gd 	3 ====== ==  uMay 1975lto July 1990 h==gth===d 	4 ====== ==  uVietnam Era (August 1964=to"== d 	5 ====== ==  uFebru    1955lto July 1964"== ed 	6 ====== ==  uK rean
War (July 1950aborh==== d 	7 ====== ==  uJanu    1947lto June 1950rh====d 	8 ====== ==  uWorld
War II (Decemb mi1941"== d 	9 ====== ==  uNovemb mi1941 H";   li m h==gthd se VALUE peafwhnb	(defaul.=32)d 	-1====== ==  uNo  in
   y ms  h==gth===== ==gd 	1 ====== ==  uSeptemb mi2001 H";l worrh==== ld 	2 ====== ==  uAugust 1990abomAugust 2001 h==gd 	3 ====== ==  uMay 1975lto July 1990 h==gth===d 	4 ====== ==  uVietnam Era (August 1964=to"== d 	5 ====== ==  uFebru    1955lto July 1964"== ed 	6 ====== ==  uK rean
War (July 1950aborh==== d 	7 ====== ==  uJanu    1947lto June 1950rh====d 	8 ====== ==  uWorld
War II (Decemb mi1941"== d 	9 ====== ==  uNovemb mi1941 H";   li m h==gthd se VALUE peafwhn 	(defaul.=32)d 	-1====== ==  uNo  in
   y ms  h==gth===== ==gd 	1 ====== ==  uSeptemb mi2001 H";l worrh==== ld 	2 ====== ==  uAugust 1990abomAugust 2001 h==gd 	3 ====== ==  uMay 1975lto July 1990 h==gth===d 	4 ====== ==  uVietnam Era (August 1964=to"== d 	5 ====== ==  uFebru    1955lto July 1964"== ed 	6 ====== ==  uK rean
War (July 1950aborh==== d 	7 ====== ==  uJanu    1947lto June 1950rh====d 	8 ====== ==  uWorld
War II (Decemb mi1941"== d 	9 ====== ==  uNovemb mi1941 H";   li m h==gthd se VALUE peafwhnd	(defaul.=32)d 	-1====== ==  uNo  in
   y ms  h==gth===== ==gd 	1 ====== ==  uSeptemb mi2001 H";l worrh==== ld 	2 ====== ==  uAugust 1990abomAugust 2001 h==gd 	3 ====== ==  uMay 1975lto July 1990 h==gth===d 	4 ====== ==  uVietnam Era (August 1964=to"== d 	5 ====== ==  uFebru    1955lto July 1964"== ed 	6 ====== ==  uK rean
War (July 1950aborh==== d 	7 ====== ==  uJanu    1947lto June 1950rh====d 	8 ====== ==  uWorld
War II (Decemb mi1941"== d 	9 ====== ==  uNovemb mi1941 H";   li m h==gthd se VALUE a_uslhr 	(defaul.=32)d 	-4====== ==  uHours vary h==gth===== ======= d 	-1====== ==  uNo  in
   y ms  h==gth===== ==gd 	0====== ===  uNon ,;  ,hua s"== ength===== thd se VALUE a_hrlywk	(defaul.=32)d 	0====== ===  uNo  in
   y ms  H";o under aary"d 	1 ====== ==  uYesrh==== length========en=====d 	2 ====== ==  uNorh==== length========en===== d se VALUE a_hrspay	(defaul.=32)d 	0====== ===  uNo  in
   y ms  H";o under aary"d se VALUE a_grswk 	(defaul.=32)d 	0====== ===  uNo  in
   y ms  H";o under aor"
 se VALUE a_unmnm 	(defaul.=32)d 	0====== ===  uNo  in
   y ms  H";o under aary"d 	1 ====== ==  uYesrh==== length========en=====d 	2 ====== ==  uNorh==== length========en===== d se VALUE a_un  v 	(defaul.=32)d 	0====== ===  uNo  in
   y ms  H";o under aary"d 	1 ====== ==  uYesrh==== length========en=====d 	2 ====== ==  uNorh==== length========en===== d se VALUE a_enrlw 	(defaul.=32)d 	0====== ===  uNo  in
   y ms  H";o under aary"d 	1 ====== ==  uYesrh==== length========en=====d 	2 ====== ==  uNorh==== length========en===== d se VALUE a_hscol 	(defaul.=32)d 	0====== ===  uNo  in
   y ms  H";o under aary"d 	1 ====== ==  uHigh schoolrh==== length=======d 	2 ====== ==  uColleg  H";   y. gth===== th=end se VALUE a_ftpn  	(defaul.=32)d 	0====== ===  uNo  in
   y ms  H";o under aary"d 	1 ====== ==  uFull tim "=== == === eng === end 	2 ====== ==  uPart tim "=== == === eng === end se VALUE a_lfsrng	(defaul.=32)d 	0====== ===  uC under aH";ArmediForcesrh==== d 	1 ====== ==  uWorkgra ===== == === eng === end 	2 ====== ==  uWi   job,    at work gth=== ==gd 	3 ====== ==  uUnemployed, lookgra for work gtd 	4 ====== ==  uUnemployed, on layoff h==gth===d 	7 ====== ==  uNilfrh==== length========en====d se VALUE a_un    	(defaul.=32)d 	0====== ===  uNo  in
   y ms  H";o under "== d 	1 ====== ==  uJob los mi- on layoff h==gth===d 	2 ====== ==  uO  erijob los m"== ength===== td 	3 ====== ==  uJob leay m h==gth===== ===== gtd 	4 ====== ==  uRe-ninrain gth===== th=====  =nd 	5 ====== ==  uNew ninrain gth===== th=====  =d se VALUE a_wkstat	(defaul.=32)d 	0====== ===  uC under aH";ArmediForcesrh==== d 	1 ====== ==  uNo  in
labH";force gth===== th=d 	2 ====== ==  uFull-tim  schedulesrh==== lengtd 	3 ====== ==  uPart-tim  for ec momic reasons,"d 	4 ====== ==  uPart-tim  for non-ec momic"== ed 	5 ====== ==  uPart-tim  for ec momic reasons,"d 	6 ====== ==  uUnemployed FT h==gth===== == thd 	7 ====== ==  uUnemployed PT h==gth===== == thd se VALUE a_explf 	(defaul.=32)d 	0====== ===  uNo  in
experies/wd
labH";force d 	1 ====== ==  uEmployed h==gth===== ==== = th=d 	2 ====== ==  uUnemployed gth===== th=====  =nd se VALUE a_wkschg	(defaul.=32)d 	0====== ===  uNo  in
   y ms  h==gth===== ==gd 	1 ====== ==  uAt work gth=== ==g== ==== = th=d 	2 ====== ==  uWi   job,     at work gth=== ==d 	3 ====== ==  uUnemployed, seeks FT h==gth====d 	4 ====== ==  uUnemployed, seeks PT h==gth====d se VALUE a_civlf 	(defaul.=32)d 	0====== ===  uNo  in
   y ms  H";o under aary"d 	1 ====== ==  uIn    y ms  h==gth===== ==g====d se VALUE a_ftlf  	(defaul.=32)d 	0====== ===  uNo  in
   y ms  H";o under aary"d 	1 ====== ==  uIn    y ms  h==gth===== ==g====d se VALUE a_mj    	(defaul.=32)d 	0====== ===  uNo  in
   y ms , H";o under "==d 	1 ====== ==  uAgricul.ur , forestry, h==gth==d 	2 ====== ==  uMingra ===== == === eng === en=d 	3 ====== ==  uConstructi   h==gth===== ======d 	4 ====== ==  uManufacturgra ===== == === eng d 	5 ====== ==  uWholesal  ary"retail trad "=== d 	6 ====== ==  uTraisportati   ary"utilitiesrh=d 	7 ====== ==  uInformati   h==gth===== =======d 	8 ====== ==  uFinancial activitiesrh= =======d 	9 ====== ==  uProfessional ary"businessrh====
 	10====== ==  uEducati  al ary"heal   servic s"d 	11====== ==  uLeisur  ary"hospitality" lengthd 	12====== ==  uO  eriservic s"gth===== =======d 	13====== ==  uP    c admingstrati   h==gth===
 	14====== ==  uArmediForcesrh==== length======d se VALUE a_dt    	(defaul.=32)d 	0====== ===  uNo  in
   y ms  H";o under aor"
 se VALUE mjoc    	(defaul.=32)d 	0====== ===  uNo  in
   y ms  H";o under "== d 	1 ====== ==  uManagemnin,"business, aryrh====d 	2 ====== ==  uProfessional ary"rel wor hh====d 	3 ====== ==  uServic  oc upati  srh==== lengtd 	4 ====== ==  uSal s ary"rel wor oc upati  srhd 	5 ====== ==  uOffic  ary"admingstratiy "=====d 	6 ====== ==  uFarming, fishing, aryrh==== lend 	7 ====== ==  uConstructi   ary"extracti   h==d 	8 ====== ==  uInstallati  , maint?nance,"=== d 	9 ====== ==  uProducti   oc upati  srh==== le
 	10====== ==  uTraisportati   ary"mat rias"gt=d 	11====== ==  uArmediForcesrh==== length======d se VALUE a_dtoc  	(defaul.=32)d 	0====== ===  uNo  in
   y ms  fH";o under aor"
 se VALUE prerelg 	(defaul.=32)d 	0====== ===  uNo      ings eligibl "=== === ed 	1 ====== ==  uE   ings eligibl "=== === e====d se VALUE work    	(defaul.=32)d 	0====== ===  uNo  in
   y ms  h==gth===== ==gd 	1 ====== ==  uYesrh==== length========en=====d 	2 ====== ==  uNorh==== length========en===== d se VALUE wtemp   	(defaul.=32)d 	0====== ===  uNo  in
   y ms  h==gth===== ==gd 	1 ====== ==  uYesrh==== length========en=====d 	2 ====== ==  uNorh==== length========en===== d se VALUE nwlook  	(defaul.=32)d 	0====== ===  uNo  in
   y ms  h==gth===== ==gd 	1 ====== ==  uYesrh==== length========en=====d 	2 ====== ==  uNorh==== length========en===== d se VALUE nwlkwk  	(defaul.=32)d 	0====== ===  uNo  in
   y ms  h==gth===== ==gd 	1 ====== ==  u1 week ===== == === eng === en=d 	52====== ==  u52 weeks"== ength===== th======d se VALUE rsn   w 	(defaul.=32)d 	0====== ===  uNo  in
   y ms  h==gth===== ==gd 	1 ====== ==  uIll H";disabl d gth===== th====d 	2 ====== ==  uRetire;"== ength===== th=======d 	3 ====== ==  uTakgra      hs hum  H";f   le"=d 	4 ====== ==  uGogra to schoolrh==== length===d 	5 ====== ==  uCould     f    work gth=== ==g=d 	6 ====== ==  uO  er h==gth===== ======= == thd se VALUE wkswork 	(defaul.=32)d 	0====== ===  uNo  in
   y ms  h==gth===== ==gd 	1 ====== ==  u1 week ===== == === eng === en=d 	52====== ==  u52 weeks"== ength===== th======d se VALUE wkcheck 	(defaul.=32)d 	0====== ===  uNo  in
   y ms  h==gth===== ==gd 	1 ====== ==  u1-49 weeks"== ength===== th====d 	2 ====== ==  u50-51 weeks"== ength===== th===d 	3 ====== ==  u52 weeks"== ength===== th======d se VALUE los wks 	(defaul.=32)d 	0====== ===  uNo  in
   y ms  h==gth===== ==gd 	1 ====== ==  uYesrh==== length========en=====d 	2 ====== ==  uNorh==== length========en===== d se VALUE lknon   	(defaul.=32)d 	0====== ===  uNo  in
   y ms  h==gth===== ==gd 	1 ====== ==  uNo  eeks lookgra for work H";   d se VALUE lk eeks 	(defaul.=32)d 	0====== ===  uNo  in
   y ms  h==gth===== ==gd 	1 ====== ==  u01 weeks"== ength===== th=====gd 	51====== ==  u51 weeks"== ength===== th===== d se VALUE lkstrchg	(defaul.=32)d 	0====== ===  uNo  in
   y ms  h==gth===== ==gd 	1 ====== ==  uYes, 1 stretch h==gth===== ====d 	2 ====== ==  uNo, 2 stretchesrh==== length===d 	3 ====== ==  uNo, 3 plus stretchesrh==== leng
 se VALUE pyrsn   	(defaul.=32)d 	0====== ===  uNo  in
   y ms  h==gth===== ==gd 	1 ====== ==  uIll H";disabl d gth===== th====d 	2 ====== ==  uTakgra      hs hum rh==== lengtd 	3 ====== ==  uGogra to schoolrh==== length===d 	4 ====== ==  uRetire;"== ength===== th=======d 	5 ====== ==  uNo work availabl "=== === e====d 	6 ====== ==  uO  er h==gth===== ======= == thd se VALUE phmempr 	(defaul.=32)d 	0====== ===  uNo  in
   y ms  h==gth===== ==gd 	1 ====== ==  u1 employem h==gth===== ===== gtd 	2 ====== ==  u2rh==== length========en===== =d 	3 ====== ==  u3 plus ===== == === eng === en=d se VALUE hrswk   	(defaul.=32)d 	0====== ===  uNo  in
   y ms  h==gth===== ==gd 	1 ====== ==  u1 hua  ===== == === eng === en=d 	99====== ==  u99=hua s plus ===== == === eng d se VALUE hrcheck 	(defaul.=32)d 	0====== ===  uNo  in
   y ms  h==gth===== ==gd 	1 ====== ==  uPart tim  (1-34)"=========en===d 	2 ====== ==  uFull tim  (35+)"=========en====d se VALUE pt      	(defaul.=32)d 	0====== ===  uNo  in
   y ms  h==gth===== ==gd 	1 ====== ==  uYesrh==== length========en=====d 	2 ====== ==  uNorh==== length========en===== d se VALUE pt eeks 	(defaul.=32)d 	0====== ===  uNo  in
   y ms  h==gth===== ==gd 	1 ====== ==  u1 week ===== == === eng === en=d 	52====== ==  u52 weeks"== ength===== th======d se VALUE ptrsn   	(defaul.=32)d 	0====== ===  uNo  in
   y ms  h==gth===== ==gd 	1 ====== ==  uCould onle f    PT job h==gth==d 	2 ====== ==  uWanwor part tim "=== == === engd 	3 ====== ==  uSlackiwork gth=== ==g== ==== = d 	4 ====== ==  uO  er h==gth===== ======= == thd se VALUE ljcw    	(defaul.=32)d 	0====== ===  uNo  in
   y ms  h==gth===== ==gd 	1 ====== ==  uPrivat  h==gth===== ==th===== =d 	2 ====== ==  uFe; mal"== ength===== th=======d 	3 ====== ==  uStlae h==gth===== ======= == thd 	4 ====== ==  uLocal h==gth===== ======= == thd 	5 ====== ==  uSelf employed in  rporlae;, y s"d 	6 ====== ==  uSelf employed in  rporlae;, no"d 	7 ====== ==  uWi  oun pay h==gth===== =======d se VALUE wexp    	(defaul.=32)d 	0====== ===  uNo  in
   y ms  h==gth===== ==gd 	1 ====== ==  u50abom52 weeks"== ength===== thd 	2 ====== ==  u48abom49=weeks"== ength===== thd 	3 ====== ==  u40abom47=weeks"== ength===== thd 	4 ====== ==  u27abom39=weeks"== ength===== thd 	5 ====== ==  u14abom26=weeks"== ength===== thd 	6 ====== ==  u13  eeks H";lessrh==== length==d 	7 ====== ==  u50abom52 weeks"== ength===== thd 	8 ====== ==  u48abom49=weeks"== ength===== thd 	9 ====== ==  u40abom47=weeks"== ength===== thd 	10====== ==  u27abom39=weeks"== ength===== thd 	11====== ==  u14abom26=weeks"== ength===== thd 	12====== ==  u13  eeks H";lessrh==== length==d 	13====== ==  uNonworker h==gth===== ======= =d se VALUE wewkr   	(defaul.=32)d 	0====== ===  uNo  in
   y ms  h==gth===== ==gd 	1 ====== ==  uFull tim "=== == === eng === end 	2 ====== ==  uPart tim "=== == === eng === end 	3 ====== ==  uFull tim "=== == === eng === end 	4 ====== ==  uPart tim "=== == === eng === end 	5 ====== ==  uNonworker h==gth===== ======= =d se VALUE welknwng	(defaul.=32)d 	0====== ===  uC under "gth=nhhn=====  th=====d 	1 ====== ==  uNon  (no  lookgra for work)"gt=d 	2 ====== ==  u1abom4  eeks lookgrarh= =======d 	3 ====== ==  u5lto 14  eeks lookgrarh= ======d 	4 ====== ==  u15abom26=weeks lookgrarh= =====d 	5 ====== ==  u27abom39=weeks lookgrarh= =====d 	6 ====== ==  u40aor m re weeks lookgrarh= ===d 	7 ====== ==  uWorkersrh==== length========en=d se VALUE weuemp  	(defaul.=32)d 	0====== ===  uNo  in
   y ms  h==gth===== ==gd 	1 ====== ==  uNon   gt =====   ===nh ength=n d 	2 ====== ==  u1abom4  eeks h==gth===== ======d 	3 ====== ==  u5lto 10  eeks h==gth===== =====d 	4 ====== ==  u11lto 14  eeks"== ength===== thd 	5 ====== ==  u15abom26=weeks"== ength===== thd 	6 ====== ==  u27abom39=weeks"== ength===== thd 	7 ====== ==  u40aor m re weeksrh==== length==d 	8 ====== ==  uFull y    worker h==gth===== ==d 	9 ====== ==  uNonworker h==gth===== ======= =d se VALUE     erng	(defaul.=32)d 	0====== ===  uNo  in
   y ms  h==gth===== ==gd 	1 ====== ==  uE   ern(p        n  0)rh= =====d 	2 ====== ==  uNon    er h==gth===== ======= =d se VALUE clwk    	(defaul.=32)d 	0====== ===  uNo  in
   y ms  h==gth===== ==gd 	1 ====== ==  uPrivat  (in ludes self-"=== ==gd 	2 ====== ==  uGby mnmnin gth===== th=en== ==gd 	3 ====== ==  uSelf-employed h==gth===== ==== d 	4 ====== ==  uW   oun pay h==gth===== =======d 	5 ====== ==  uNey m workedrh==== length======d se VALUE weclw   	(defaul.=32)d 	0====== ===  uNo  in
   y ms  h==gth===== ==gd 	1 ====== ==  uWag  ary"salary h==gth===== ===d 	2 ====== ==  uSelf-employed h==gth===== ==== d 	3 ====== ==  uUnpair === gt h ength=nhhn=====d 	4 ====== ==  uPrivat  huaseof";"=== === e====d 	5 ====== ==  uO  er privat  h==gth===== ==th=d 	6 ====== ==  uGby mnmnin gth===== th=en== ==gd 	7 ====== ==  uSelf-employed h==gth===== ==== d 	8 ====== ==  uUnpair === gt h ength=nhhn=====d 	9 ====== ==  uNey m workedrh==== length======d se VALUE mig_cbst	(defaul.=32)d 	0====== ===  uNIU, nonmby m h==gth===== =====d 	1 ====== ==  uCBSA  gt =====   ===nh ength=n d 	2 ====== ==  unon CBSA  gt =====   ===nh engtd 	3 ====== ==  uAbroar === gt h ength=nhhn=====d 	4 ====== ==  uNo  idninifiabl "=== === e=====d se VALUE migsame 	(defaul.=32)d 	0====== ===  uNIUrh==== length========en=====d 	1 ====== ==  uYes (nonmby m)"=========en=====d 	2 ====== ==  uNo, differes/w huase in
U.S. gtd 	3 ====== ==  uNo, ounsidn   e
U.S. (mby m)"==d se VALUE mig_reg 	(defaul.=32)d 	0====== ===  uNo  in
   y ms  unde  1 y   "=gd 	1 ====== ==  uNor  easn gth===== th=====  =nhd 	2 ====== ==  uMidwesn gth===== th=====  =nh=gd 	3 ====== ==  uSounh h==gth===== ======= == thd 	4 ====== ==  uWesn gth===== th=====  =nh=g ==d 	5 ====== ==  uAbroar === gt h ength=nhhn=====d se VALUE mig_sn  	(defaul.=32)d 	0====== ===  uNonmatch h==gth===== ====h=g ==d 	1 ====== ==  uAlabala === gt h === ====h=g ==d 	2 ====== ==  uAlaska === gt h === ====h=g ==hd 	4 ====== ==  uArizona === gt h === ====h=g ==d 	5 ====== ==  uArkansas"== ength===== th=====gd 	6 ====== ==  uCalifornia === gt h === ====h=gd 	8 ====== ==  uColoradorh==== length========end 	9 ====== ==  uConnecticun gth===== th=====  =d 	10====== ==  uDelawar   gt =====   ===nh engtd 	11====== ==  uDgstrict hs Columbia === gt h =d 	12====== ==  uFlorida === gt h === ====h=g ==d 	13====== ==  uGeorgia === gt h === ====h=g ==d 	15====== ==  uHawaii === gt h === ====h=g ==hd 	16====== ==  uIdahorh==== length========en===
 	17====== ==  uIllinois"== ength===== th=====gd 	18====== ==  uIndiana === gt h === ====h=g ==d 	19====== ==  uIowa === gt h === ====h=g ==h==d 	20====== ==  uKansas"== ength===== th=====g==d 	21====== ==  uKninucky h==gth===== ======= ==d 	22====== ==  uLouisiana === gt h === ====h=g 
 	23====== ==  uMain   gt =====   ===nh ength=n
 	24====== ==  uMarylaryrh==== length======== =
 	25====== ==  uMassachasetts h==gth===== =====d 	26====== ==  uMichig  "=========en=====t=t ==d 	27====== ==  uMinnesota === gt h === ====h=g 
 	28====== ==  uMississippi === gt h === ====h=
 	29====== ==  uMissouri === gt h === ====h=g =
 	30====== ==  uMontana === gt h === ====h=g ==d 	31====== ==  uNebraska === gt h === ====h=g =
 	32====== ==  uNeyada === gt h === ====h=g ===
 	33====== ==  uNew Hampshir   gt =====   ===nh
 	34====== ==  uNew J ms e"=========en=====t=t=d 	35====== ==  uNew Mexicorh==== length========
 	36====== ==  uNew York gth=== ==g== ==== = th
 	37====== ==  uNor   Carolina === gt h === ===
 	38====== ==  uNor   Dakota === gt h === ====h
 	39====== ==  uOhiorh==== length========en====
 	40====== ==  uOklahola === gt h === ====h=g =
 	41====== ==  uOreg   h==gth===== =======h=g =
 	42====== ==  uPennsylvania === gt h === ====h
 	44====== ==  uRhodn Islan; === gt h === ====h
 	45====== ==  uSounh Carolina === gt h === ===
 	46====== ==  uSounh Dakota === gt h === ====h
 	47====== ==  uTennesse "=== == === eng === end 	48====== ==  uTexas"== ength===== th=====g==nd 	49====== ==  uUtah h==gth===== ======= == th=d 	50====== ==  uVermont === gt h === ====h=g ==d 	51====== ==  uVirginia === gt h === ====h=g==d 	53====== ==  uWashingt   h==gth===== =======hd 	54====== ==  uWesn Virginia === gt h === ====d 	55====== ==  uWisconsi  h==gth===== =======h=d 	56====== ==  uWyomgra ===== == === eng === end 	96====== ==  uAbroar === gt h ength=nhhn=====d se VALUE mig_dscp	(defaul.=32)d 	0====== ===  uNIU (unde  1 y    f";, h==gth==d 	1 ====== ==  uPrincipal city hs akCBSA  gt ==d 	2 ====== ==  uBalas/w hs akCBSA  gt ====gth==d 	3 ====== ==  uNon-metrorh==== length========ed 	4 ====== ==  uAbroar === gt h ength=nhhn=====d 	5 ====== ==  uNo  idninifiedrh==== length====d se VALUE gediv   	(defaul.=32)d 	1 ====== ==  uNew Englaryrh==== length=======d 	2 ====== ==  uMiddle Atlartic"== et ====gth==d 	3 ====== ==  uEast Nor   Cninral"et ====gth==d 	4 ====== ==  uWesn Nor   Cninral"et ====gth==d 	5 ====== ==  uSounh Atlartic"== et ====gth==gd 	6 ====== ==  uEast Sounh Cninral"et ====gth==d 	7 ====== ==  uWest Sounh Cninral"et ====gth==d 	8 ====== ==  uMountai  h==gth===== =======h=nd 	9 ====== ==  uPacificrh==== length========en=d se VALUE mig_div 	(defaul.=32)d 	0====== ===  uNo  in
   y ms  (unde  1 y   "=d 	1 ====== ==  uNew Englaryrh==== length=======d 	2 ====== ==  uMiddle Atlartic"== et ====gth==d 	3 ====== ==  uEast Nor   Cninral"et ====gth==d 	4 ====== ==  uWesn Nor   Cninral"et ====gth==d 	5 ====== ==  uSounh Atlartic"== et ====gth==gd 	6 ====== ==  uEast Sounh Cninral"et ====gth==d 	7 ====== ==  uWest Sounh Cninral"et ====gth==d 	8 ====== ==  uMountai  h==gth===== =======h=nd 	9 ====== ==  uPacificrh==== length========en=d 	10====== ==  uAboa   h==gth===== ==== ====en=d se VALUE mig_mnra	(defaul.=32)d 	1 ====== ==  uNonmby m h==gth===== =======en=d 	2 ====== ==  uMetroabommetrorh==== length====d 	3 ====== ==  uMetroabomnon-metrorh==== lengthd 	4 ====== ==  uNon-metroabommetrorh==== lengthd 	5 ====== ==  uNon-metroabomnon-metrorh==== led 	6 ====== ==  uAbroarabommetrorh==== length===d 	7 ====== ==  uAbroarabomnon-metrorh==== lengtd 	8 ====== ==  uNo  in
   y ms  (C under "gth=nd 	9 ====== ==  uNo  idninifiabl "=== === e=====d se VALUE mig_mnr 	(defaul.=32)d 	1 ====== ==  uNonmby m h==gth===== =======en=d 	2 ====== ==  uSaliacoun  rh==== length=======d 	3 ====== ==  uDifferestacoun  , same stlae h=d 	4 ====== ==  uDifferestastlae, same  tinsion"d 	5 ====== ==  uDifferesta tinsion, same  gt ==d 	6 ====== ==  uDifferestaregi   h==gth===== ==d 	7 ====== ==  uAbroar === gt h ength=nhhn=====d 	8 ====== ==  uNo  in
   y ms  (c under "gth=nd se VALUE mig_mnrd	(defaul.=32)d 	1 ====== ==  uNonmby m h==gth===== =======en=d 	2 ====== ==  uSaliacoun  rh==== length=======d 	3 ====== ==  uDifferestacoun  , same stlae h=d 	4 ====== ==  uDifferestastlae in
Nor  easn gtd 	5 ====== ==  uDifferestastlae in
midwesn gth=d 	6 ====== ==  uDifferestastlae in
Sounh h==gthd 	7 ====== ==  uDifferestastlae in
wesn gth====d 	8 ====== ==  uAbroar, foreignacoun   "n======d 	9 ====== ==  uNo  in
   y ms  (c under "gth=nd se VALUE noemp   	(defaul.=32)d 	0====== ===  uNo  in
   y ms  h==gth===== ==gd 	1 ====== ==  uUnde  10 h==gth===== =======en=d 	2 ====== ==  u10a- 24rh==== lengt ========en=d 	3 ====== ==  u25a- 99rh==== lengt ========en=d 	4 ====== ==  u100a- 499rh==== lengt ========ed 	5 ====== ==  u500a- 999rh==== lengt ========ed 	6 ====== ==  u1000+ === gt h ength=nhh======ed se VALUE  rn_    	(defaul.=32)d 	0====== ===  uNo  in
   y ms  h==gth===== ==gd 	1 ====== ==  uYesrh==== length========en=====d 	2 ====== ==  uNorh==== length========en===== d se VALUE  rn_    	(defaul.=32)d 	0====== ===  uNon  H";no  in
   y ms  h==gth=d se VALUE  rn_src 	(defaul.=32)d 	0====== ===  uNo  in
   y ms  h==gth===== ==gd 	1 ====== ==  uWag  ary"salary h==gth===== ===d 	2 ====== ==  uSelf employmnin gth===== th=en=d 	3 ====== ==  uFarm self employmnin gth===== td 	4 ====== ==  uWi  oun pay h==gth===== =======d se VALUE  rn_otr 	(defaul.=32)d 	0====== ===  uNo  in
   y ms  h==gth===== ==gd 	1 ====== ==  uYesrh==== length========en=====d 	2 ====== ==  uNorh==== length========en===== d se VALUE wag otr 	(defaul.=32)d 	0====== ===  uNo  in
   y ms  h==gth===== ==gd 	1 ====== ==  uYesrh==== length========en=====d 	2 ====== ==  uNorh==== length========en===== d se VALUE wsal_   	(defaul.=32)d 	0====== ===  uNo  in
   y ms  h==gth===== ==gd 	1 ====== ==  uYesrh==== length========en=====d 	2 ====== ==  uNorh==== length========en===== d se VALUE wsal_   	(defaul.=32)d 	0====== ===  uNon  H";no  in
   y ms  h==gth=d se VALUE s otr   	(defaul.=32)d 	0====== ===  uNo  in
   y ms  h==gth===== ==gd 	1 ====== ==  uYesrh==== length========en=====d 	2 ====== ==  uNorh==== length========en===== d se VALUE semp_   	(defaul.=32)d 	0====== ===  uNo  in
   y ms  h==gth===== ==gd 	1 ====== ==  uYesrh==== length========en=====d 	2 ====== ==  uNorh==== length========en===== d se VALUE semp_   	(defaul.=32)d 	0====== ===  uNon  H";no  in
   y ms  h==gth=d se VALUE frmotr  	(defaul.=32)d 	0====== ===  uNo  in
   y ms  h==gth===== ==gd 	1 ====== ==  uYesrh==== length========en=====d 	2 ====== ==  uNorh==== length========en===== d se VALUE fms _   	(defaul.=32)d 	0====== ===  uNo  in
   y ms  h==gth===== ==gd 	1 ====== ==  uYesrh==== length========en=====d 	2 ====== ==  uNorh==== length========en===== d se VALUE fms _   	(defaul.=32)d 	0====== ===  uNon  H";no  in
   y ms  h==gth=d se VALUE uc_     	(defaul.=32)d 	0====== ===  uNo  in
   y ms  h==gth===== ==gd 	1 ====== ==  uYesrh==== length========en=====d 	2 ====== ==  uNorh==== length========en===== d se VALUE subu    	(defaul.=32)d 	0====== ===  uNo  in
   y ms  h==gth===== ==gd 	1 ====== ==  uYesrh==== length========en=====d 	2 ====== ==  uNorh==== length========en===== d se VALUE strku   	(defaul.=32)d 	0====== ===  uNo  in
   y ms  h==gth===== ==gd 	1 ====== ==  uYesrh==== length========en=====d 	2 ====== ==  uNorh==== length========en===== d se VALUE uc_     	(defaul.=32)d 	0====== ===  uNon  H";no  in
   y ms  h==gth=d se VALUE wc_     	(defaul.=32)d 	0====== ===  uNo  in
   y ms  h==gth===== ==gd 	1 ====== ==  uYesrh==== length========en=====d 	2 ====== ==  uNorh==== length========en===== d se VALUE wc_     	(defaul.=32)d 	0====== ===  uNo  in
   y ms  h==gth===== ==gd 	1 ====== ==  uStlaeiworker'sacompensati   h==d 	2 ====== ==  uEmployer H"; mployers insuras/w"d 	3 ====== ==  uOwn.insuras/w"th========en=====d 	4 ====== ==  uO  er h==gth===== ======= == thd se VALUE wc_     	(defaul.=32)d 	0====== ===  uNon  H";no  in
   y ms  h==gth=d se VALUE ss_     	(defaul.=32)d 	0====== ===  uNo  in
   y ms  h==gth===== ==gd 	1 ====== ==  uYesrh==== length========en=====d 	2 ====== ==  uNorh==== length========en===== d se VALUE ss_     	(defaul.=32)d 	0====== ===  uNon  H";no  in
   y ms  h==gth=d se VALUE ssi_    	(defaul.=32)d 	0====== ===  uNo  in
   y ms  h==gth===== ==gd 	1 ====== ==  uYesrh==== length========en=====d 	2 ====== ==  uNorh==== length========en===== d se VALUE paw_    	(defaul.=32)d 	0====== ===  uNo  in
   y ms  h==gth===== ==gd 	1 ====== ==  uYesrh==== length========en=====d 	2 ====== ==  uNorh==== length========en===== d se VALUE paw_    	(defaul.=32)d 	0====== ===  uNo  in
   y ms  h==gth===== ==gd 	1 ====== ==  uTANF/AFDCrh==== lengt ========ed 	2 ====== ==  uO  er h==gth===== ======= == thd 	3 ====== ==  uBonh h==gth===== ======= == th d se VALUE paw_mo  	(defaul.=32)d 	0====== ===  uNo  in
   y ms  h==gth===== ==gd 	1 ====== ==  uOn   gt =====   ===nh ength=n gd 	12====== ==  uTwely "=========en====== == th d se VALUE paw_    	(defaul.=32)d 	0====== ===  uNon  H";no  in
   y ms  h==gth=d se VALUE vet_    	(defaul.=32)d 	0====== ===  uNo  in
   y ms  h==gth===== ==gd 	1 ====== ==  uYesrh==== length========en=====d 	2 ====== ==  uNorh==== length========en===== d se VALUE vet_   a	(defaul.=32)d 	0====== ===  uNo  in
   y ms  h==gth===== ==gd 	1 ====== ==  uYesrh==== length========en=====d 	2 ====== ==  uNorh==== length========en===== d se VALUE vet_   b	(defaul.=32)d 	0====== ===  uNo  in
   y ms  h==gth===== ==gd 	1 ====== ==  uYesrh==== length========en=====d 	2 ====== ==  uNorh==== length========en===== d se VALUE vet_    	(defaul.=32)d 	0====== ===  uNo  in
   y ms  h==gth===== ==gd 	1 ====== ==  uYesrh==== length========en=====d 	2 ====== ==  uNorh==== length========en===== d se VALUE vet_   d	(defaul.=32)d 	0====== ===  uNo  in
   y ms  h==gth===== ==gd 	1 ====== ==  uYesrh==== length========en=====d 	2 ====== ==  uNorh==== length========en===== d se VALUE vet_    	(defaul.=32)d 	0====== ===  uNo  in
   y ms  h==gth===== ==gd 	1 ====== ==  uYesrh==== length========en=====d 	2 ====== ==  uNorh==== length========en===== d se VALUE vet_qva 	(defaul.=32)d 	0====== ===  uNo  in
   y ms  h==gth===== ==gd 	1 ====== ==  uYesrh==== length========en=====d 	2 ====== ==  uNorh==== length========en===== d se VALUE vet_    	(defaul.=32)d 	0====== ===  uNon  H";no  in
   y ms  h==gth=d se VALUE sur_    	(defaul.=32)d 	0====== ===  uNo  in
   y ms  h==gth===== ==gd 	1 ====== ==  uYesrh==== length========en=====d 	2 ====== ==  uNorh==== length========en===== d se VALUE sur_sc1 	(defaul.=32)d 	0====== ===  uNon  H";no  in
   y ms  h==gth=d 	1 ====== ==  uCompany H";   o  survivor"gth=nd 	2 ====== ==  uFe; mal gby mnmnin gth===== th=d 	3 ====== ==  uUs milit    retiremnin gth=====d 	4 ====== ==  uStlaeiH";local gby mnmnin gth==d 	5 ====== ==  uUs railroararetiremnin gth=====d 	6 ====== ==  uWorker'sacompensati   survivor"d 	7 ====== ==  uBlackiLung Survivor Pensi   h==d 	8 ====== ==  uRegularipaymnins from estlaesrhd 	9 ====== ==  uRegularipaymnins from gth===== 
 	10====== ==  uO  er H";don't knowrh==== lengtd se VALUE sur_   a	(defaul.=32)d 	0====== ===  uNon  H";no  in
   y ms  h==gth=d se VALUE sur_   b	(defaul.=32)d 	0====== ===  uNon  H";no  in
   y ms  h==gth=d se VALUE srvs_   	(defaul.=32)d 	0====== ===  uNon  H";no  in
   y ms  h==gth=d se VALUE dis_hp  	(defaul.=32)d 	0====== ===  uNo  in
   y ms  h==gth===== ==gd 	1 ====== ==  uYesrh==== length========en=====d 	2 ====== ==  uNorh==== length========en===== d se VALUE dis_c   	(defaul.=32)d 	0====== ===  uNo  in
   y ms  H";o under "== d 	1 ====== ==  uYesrh==== length========en=====d 	2 ====== ==  uNorh==== length========en===== d se VALUE dis_    	(defaul.=32)d 	0====== ===  uNo  in
   y ms  H";o under "== d 	1 ====== ==  uYesrh==== length========en=====d 	2 ====== ==  uNorh==== length========en===== d se VALUE dis_sc1 	(defaul.=32)d 	0====== ===  uNo  in
   y ms  h==gth===== ==gd 	1 ====== ==  uWorker'sacompensati   h==n=====d 	2 ====== ==  uCompany H";   o  disability" led 	3 ====== ==  uFe; mal gby mnmnin disability" d 	4 ====== ==  uUs milit    retiremnin gth=====d 	5 ====== ==  uStlaeiH";local gby't  mployew hd 	6 ====== ==  uUs railroararetiremnin gth=====d 	7 ====== ==  uAccidnin H";disability" length=d 	8 ====== ==  uBlackiLung miner'sadisability" d 	9 ====== ==  uStlaeitempor    sicknessrh==== 
 	10====== ==  uO  er H";don't knowrh==== lengtd se VALUE dis_   a	(defaul.=32)d 	0====== ===  uNon  H";no  in
   y ms  h==gth=d se VALUE dis_   b	(defaul.=32)d 	0====== ===  uNon  H";no  in
   y ms  h==gth=d se VALUE dsab_   	(defaul.=32)d 	0====== ===  uNon  H";no  in
   y ms  h==gth=d se VALUE ret_    	(defaul.=32)d 	0====== ===  uNo  in
   y ms  h==gth===== ==gd 	1 ====== ==  uYesrh==== length========en=====d 	2 ====== ==  uNorh==== length========en===== d se VALUE ret_sc1 	(defaul.=32)d 	0====== ===  uNon  H";no  in
   y ms  h==gth=d 	1 ====== ==  uCompany H";   o  pensi   h=====d 	2 ====== ==  uFe; mal gby mnmnin retiremnin gd 	3 ====== ==  uUS milit    retiremnin gth=====d 	4 ====== ==  uStlaeiH";local gby mnmnin gth==d 	5 ====== ==  uUS railroararetiremnin gth=====d 	6 ====== ==  uRegularipaymnins from annuitiesrd 	7 ====== ==  uRegularipaymnins from ira,"=== d 	8 ====== ==  uO  er sources H";don't knowrh==d se VALUE ret_   a	(defaul.=32)d 	0====== ===  uNon  H";no  in
   y ms  h==gth=d se VALUE ret_   b	(defaul.=32)d 	0====== ===  uNon  H";no  in
   y ms  h==gth=d se VALUE rtm_    	(defaul.=32)d 	0====== ===  uNon  H";no  in
   y ms  h==gth=d se VALUE int_    	(defaul.=32)d 	0====== ===  uNo  in
   y ms  h==gth===== ==gd 	1 ====== ==  uYesrh==== length========en=====d 	2 ====== ==  uNorh==== length========en===== d se VALUE int_    	(defaul.=32)d 	0====== ===  uNon  H";no  in
   y ms  h==gth=d se VALUE div_    	(defaul.=32)d 	0====== ===  uNo  in
   y ms  h==gth===== ==gd 	1 ====== ==  uYesrh==== length========en=====d 	2 ====== ==  uNorh==== length========en===== d se VALUE div_no  	(defaul.=32)d 	0====== ===  uNo  in
   y ms  h==gth===== ==gd 	1 ====== ==  uNon   gt =====   ===nh ength=n d se VALUE div_    	(defaul.=32)d 	0====== ===  uNon  H";no  in
   y ms  h==gth=d se VALUE rnt_    	(defaul.=32)d 	0====== ===  uNo  in
   y ms  h==gth===== ==gd 	1 ====== ==  uYesrh==== length========en=====d 	2 ====== ==  uNorh==== length========en===== d se VALUE rnt_    	(defaul.=32)d 	0====== ===  uNon  H";no  in
   y ms  h==gth=d se VALUE ed_     	(defaul.=32)d 	0====== ===  uNo  in
   y ms  h==gth===== ==gd 	1 ====== ==  uYesrh==== length========en=====d 	2 ====== ==  uNorh==== length========en===== d se VALUE oed_   a	(defaul.=32)d 	0====== ===  uNo  in
   y ms  h==gth===== ==gd 	1 ====== ==  uYesrh==== length========en=====d 	2 ====== ==  uNorh==== length========en===== d se VALUE oed_   b	(defaul.=32)d 	0====== ===  uNo  in
   y ms  h==gth===== ==gd 	1 ====== ==  uYesrh==== length========en=====d 	2 ====== ==  uNorh==== length========en===== d se VALUE oed_    	(defaul.=32)d 	0====== ===  uNo  in
   y ms  h==gth===== ==gd 	1 ====== ==  uYesrh==== length========en=====d 	2 ====== ==  uNorh==== length========en===== d se VALUE ed_     	(defaul.=32)d 	0====== ===  uNon  H";no  in
   y ms  h==gth=d se VALUE csp_    	(defaul.=32)d 	0====== ===  uNo  in
   y ms  h==gth===== ==gd 	1 ====== ==  uYesrh==== length========en=====d 	2 ====== ==  uNorh==== length========en===== d se VALUE csp_    	(defaul.=32)d 	0====== ===  uNon  H";no  in
   y ms  h==gth=d se VALUE alm_    	(defaul.=32)d 	0====== ===  uNon  H";no  in
   y ms  h==gth=d 	1 ====== ==  uYesrh==== length========en=====d 	2 ====== ==  uNorh==== length========en===== d se VALUE alm_    	(defaul.=32)d 	0====== ===  uNon  H";no  in
   y ms  h==gth=d se VALUE fin_    	(defaul.=32)d 	0====== ===  uNo  in
   y ms  h==gth===== ==gd 	1 ====== ==  uYesrh==== length========en=====d 	2 ====== ==  uNorh==== length========en===== d se VALUE fin_    	(defaul.=32)d 	0====== ===  uNon  H";no  in
   y ms  h==gth=d se VALUE oi_off  	(defaul.=32)d 	0====== ===  uNIUrh==== length========en=====d 	1 ====== ==  uSocial securi  rh==== length===d 	2 ====== ==  uPrivat  pensi  srh==== length==d 	3 ====== ==  uAFDCrh==== lengt ========egth==d 	4 ====== ==  uO  er p    c assistas/w"th=====d 	5 ====== ==  uInteresn gth===== th=====  =nh=d 	6 ====== ==  uDividnidsrh==== length========ed 	7 ====== ==  uReins H";royaltiesrh= ======== d 	8 ====== ==  uEstlaes H";trusts h==gth===== =d 	9 ====== ==  uStlaeidisabilityipaymnins gth==d 	10====== ==  uDisabilityipaymnins (ow  h=====d 	11====== ==  uUnemploymestacompensati   h==n=
 	12====== ==  uStrike benefits h==gth===== ===
 	13====== ==  uAnnuities H";pair up insuras/w"d 	14====== ==  uNo  incom "=== == === eng === e
 	15====== ==  uLongest job h==gth=== eng === e
 	16====== ==  uWages H";salary h==gth===== ===d 	17====== ==  uNonfarm self-employmnin gth====
 	19====== ==  uAnything els  h==gth===== ==g==d se VALUE oi_     	(defaul.=32)d 	0====== ===  uNon  H";no  in
   y ms  h==gth=d 	1 ====== ==  uYesrh==== length========en=====d 	2 ====== ==  uNorh==== length========en===== d se VALUE oi_     	(defaul.=32)d 	0====== ===  uNon  H";no  in
   y ms  h==gth=d se VALUE ptot    	(defaul.=32)d 	0====== ===  uNon  H";no  in
   y ms  h==gth=d se VALUE p       	(defaul.=32)d 	0====== ===  uNon  H";no  in
   y ms  h==gth=d se VALUE poth    	(defaul.=32)d 	0====== ===  uNon   gt =====   ===nh ength=n d se VALUE fl_665  	(defaul.=32)d 	0====== ===  uCompleaeino resp  seaborh==== =d 	1 ====== ==  uSupplemestaint?rviewrh==== lengd 	2 ====== ==  uSum  supplemestaresp  seabun gtd 	3 ====== ==  uSupplemestaint?rviewabun;no "h=d se VALUE ptot_r  	(defaul.=32)d 	0====== ===  uNo  in
   y ms  h==gth===== ==gd 	1 ====== ==  uUnde  $2,500 h==gth===== ======d 	2 ====== ==  u$2,500abom$4,999rh==== lengt ==d 	3 ====== ==  u$5,000abom$7,499rh==== lengt ==d 	4 ====== ==  u$7,500abom$9,999rh==== lengt ==d 	5 ====== ==  u$10,000abom$12,499rh==== lengt d 	6 ====== ==  u$12,500abom$14,999rh==== lengt d 	7 ====== ==  u$15,000abom$17,499rh==== lengt d 	8 ====== ==  u$17,500abom$19,999rh==== lengt d 	9 ====== ==  u$20,000abom$22,499rh==== lengt d 	10====== ==  u$22,500abom$24,999rh==== lengt d 	11====== ==  u$25,000abom$27,499rh==== lengt d 	12====== ==  u$27,500abom$29,999rh==== lengt d 	13====== ==  u$30,000abom$32,499rh==== lengt d 	14====== ==  u$32,500abom$34,999rh==== lengt d 	15====== ==  u$35,000abom$37,499rh==== lengt d 	16====== ==  u$37,500abom$39,999rh==== lengt d 	17====== ==  u$40,000abom$42,499rh==== lengt d 	18====== ==  u$42,500abom$44,999rh==== lengt d 	19====== ==  u$45,000abom$47,499rh==== lengt d 	20====== ==  u$47,500abom$49,999rh==== lengt d 	21====== ==  u$50,000abom$52,499rh==== lengt d 	22====== ==  u$52,500abom$54,999rh==== lengt d 	23====== ==  u$55,000abom$57,499rh==== lengt d 	24====== ==  u$57,500abom$59,999rh==== lengt d 	25====== ==  u$60,000abom$62,499rh==== lengt d 	26====== ==  u$62,500abom$64,999rh==== lengt d 	27====== ==  u$65,000abom$67,499rh==== lengt d 	28====== ==  u$67,500abom$69,999rh==== lengt d 	29====== ==  u$70,000abom$72,499rh==== lengt d 	30====== ==  u$72,500abom$74,999rh==== lengt d 	31====== ==  u$75,000abom$77,499rh==== lengt d 	32====== ==  u$77,500abom$79,999rh==== lengt d 	33====== ==  u$80,000abom$82,499rh==== lengt d 	34====== ==  u$82,500abom$84,999rh==== lengt d 	35====== ==  u$85,000abom$87,499rh==== lengt d 	36====== ==  u$87,500abom$89,999rh==== lengt d 	37====== ==  u$90,000abom$92,499rh==== lengt d 	38====== ==  u$92,500abom$94,999rh==== lengt d 	39====== ==  u$95,000abom$97,499rh==== lengt d 	40====== ==  u$97,500abom$99,999rh==== lengt d 	41====== ==  u$100,000aary"by m h==gth===== =d se VALUE p rli   	(defaul.=32)d 	1 ====== ==  uBelow low-incom  level"et ====gd 	2 ====== ==  u100a- 124=p rcnin Hf   e
low- gd 	3 ====== ==  u125a- 149=p rcnin Hf   e
low- gd 	4 ====== ==  u150aary"abby    e
low-incom "==d se VALUE m       	(defaul.=32)d 	0====== ===  uNIU (c under  unde  15)"=======d 	1 ====== ==  uYesrh==== length========en=====d 	2 ====== ==  uNorh==== length========en===== d se VALUE m  ir   	(defaul.=32)d 	1 ====== ==  uYesrh==== length========en=====d 	2 ====== ==  uNorh==== length========en===== d se VALUE champ   	(defaul.=32)d 	1 ====== ==  uYesrh==== length========en=====d 	2 ====== ==  uNorh==== length========en===== d se VALUE hi_     	(defaul.=32)d 	0====== ===  uNo  in
   y ms  h==gth===== ==gd 	1 ====== ==  uYesrh==== length========en=====d 	2 ====== ==  uNorh==== length========en===== d se VALUE hiow    	(defaul.=32)d 	0====== ===  uNo  in
   y ms  h==gth===== ==gd 	1 ====== ==  uYesrh==== length========en=====d 	2 ====== ==  uNorh==== length========en===== d se VALUE hiemp   	(defaul.=32)d 	0====== ===  uNo  in
   y ms  h==gth===== ==gd 	1 ====== ==  uYesrh==== length========en=====d 	2 ====== ==  uNorh==== length========en===== d se VALUE hipair g	(defaul.=32)d 	0====== ===  uNo  in
   y ms  h==gth===== ==gd 	1 ====== ==  uAll h==gth===== ======= == th==d 	2 ====== ==  uParn gth===== th=====  =nh=g ==d 	3 ====== ==  uNon   gt =====   ===nh ength=n d se VALUE wrk_ck  	(defaul.=32)d 	0====== ===  uNo  in
   y ms  h==gth===== ==gd 	1 ====== ==  uYesrh==== length========en=====d 	2 ====== ==  uNorh==== length========en===== d se VALUE penpla  	(defaul.=32)d 	0====== ===  uNo  in
   y ms  h==gth===== ==gd 	1 ====== ==  uYesrh==== length========en=====d 	2 ====== ==  uNorh==== length========en===== d se VALUE penin l 	(defaul.=32)d 	0====== ===  uNo  in
   y ms  h==gth===== ==gd 	1 ====== ==  uYesrh==== length========en=====d 	2 ====== ==  uNorh==== length========en===== d se VALUE cov_gh  	(defaul.=32)d 	1 ====== ==  uYesrh==== length========en=====d 	2 ====== ==  uNorh==== length========en===== d se VALUE cov_hi  	(defaul.=32)d 	1 ====== ==  uYesrh==== length========en=====d 	2 ====== ==  uNorh==== length========en===== d se VALUE ch_m    	(defaul.=32)d 	0====== ===  uNo  c und's reco   h==gth===== d 	1 ====== ==  uYesrh==== length========en=====d 	2 ====== ==  uNorh==== length========en===== d se VALUE ch_hi   	(defaul.=32)d 	0====== ===  uNo  c und's reco   h==gth===== d 	1 ====== ==  uCby med by=p rson.in huaseof";"d 	2 ====== ==  uCby med by=p rson.ounsidn of gtd 	3 ====== ==  uNo  cby med h==gth=== eng === e
 se VALUE a1rrp   	(defaul.=32)d 	0====== ===  uNo chang "=== == === eng === end 	2 ====== ==  uBla kabomvalu "=== == === eng =d 	3 ====== ==  uValu abomvalu "=== == === eng =d se VALUE a1parest	(defaul.=32)d 	0====== ===  uNo chang "=== == === eng === end 	2 ====== ==  uBla kabomvalu "=== == === eng =d 	3 ====== ==  uValu abomvalu "=== == === eng =d se VALUE a1ag    	(defaul.=32)d 	0====== ===  uNo chang "=== == === eng === end 	4 ====== ==  uAllocate;"== ength===== th=====d se VALUE a1marit 	(defaul.=32)d 	0====== ===  uNo chang "=== == === eng === end 	4 ====== ==  uAllocate;"== ength===== th=====d se VALUE a1spuase	(defaul.=32)d 	0====== ===  uNo chang "=== == === eng === end 	2 ====== ==  uBla kabomvalu "=== == === eng =d 	3 ====== ==  uValu abomvalu "=== == === eng =d se VALUE a1sex   	(defaul.=32)d 	0====== ===  uNo chang "=== == === eng === end 	4 ====== ==  uAllocate;"== ength===== th=====d se VALUE a1hga   	(defaul.=32)d 	0====== ===  uNo chang "=== == === eng === end 	4 ====== ==  uAllocate;"== ength===== th=====d se VALUE a1lfsr  	(defaul.=32)d 	0====== ===  uNo chang  H";o under  H";armed"d 	4 ====== ==  uAllocate;"== ength===== th=====d se VALUE a1hr    	(defaul.=32)d 	0====== ===  uNo chang  H";o under  H";armed"d 	4 ====== ==  uAllocate;"== ength===== th=====d se VALUE pxafey m	(defaul.=32)d 	-1====== ==  uNo  allocate;"== ength===== th=d 	0====== ===  uValu a- no chang "=== == === end 	1 ====== ==  uBla ka- no chang "=== == === end 	2 ====== ==  uDon't knowa- no chang "=== == =d 	3 ====== ==  uRefaseda- no chang "=== == === d 	10====== ==  uValu abomvalu "=== == === eng =d 	11====== ==  uBla kabomvalu "=== == === eng =d 	12====== ==  uDon't knowabomvalu "=== == === d 	13====== ==  uRefasedabomvalu "=== == === engd 	20====== ==  uValu abomlongitudinalmvalu "===d 	21====== ==  uBla kabomlongitudinalmvalu "===d 	22====== ==  uDon't knowabomlongitudinal" engd 	23====== ==  uRefasedabomlongitudinalmvalu "=d 	30====== ==  uValu abomallocate;mvalu mlong" d 	31====== ==  uBla kabomallocate;mvalu mlong" d 	32====== ==  uDon't knowabomallocate;mvalu " d 	33====== ==  uRefasedabomallocate;mvalu mlong"d 	40====== ==  uValu abomallocate;mvalu "== engd 	41====== ==  uBla kabomallocate;mvalu "== engd 	42====== ==  uDon't knowabomallocate;mvalu " d 	43====== ==  uRefasedabomallocate;mvalu " engd 	50====== ==  uValu abombla k"=== == === eng =d 	52====== ==  uDon't knowabombla k"=== == === 
 	53====== ==  uRefasedabombla k"=== == === engd se VALUE pxafwhna	(defaul.=32)d 	-1====== ==  uNo  allocate;"== ength===== th=d 	0====== ===  uValu a- no chang "=== == === end 	1 ====== ==  uBla ka- no chang "=== == === end 	2 ====== ==  uDon't knowa- no chang "=== == =d 	3 ====== ==  uRefaseda- no chang "=== == === d 	10====== ==  uValu abomvalu "=== == === eng =d 	11====== ==  uBla kabomvalu "=== == === eng =d 	12====== ==  uDon't knowabomvalu "=== == === d 	13====== ==  uRefasedabomvalu "=== == === engd 	20====== ==  uValu abomlongitudinalmvalu "===d 	21====== ==  uBla kabomlongitudinalmvalu "===d 	22====== ==  uDon't knowabomlongitudinal" engd 	23====== ==  uRefasedabomlongitudinalmvalu "=d 	30====== ==  uValu abomallocate;mvalu mlong" d 	31====== ==  uBlal kabomallocate;mvalu mlong"d 	32====== ==  uDon't knowabomallocate;mvalu " d 	33====== ==  uRefasedabomallocate;mvalu mlong"d 	40====== ==  uValu abomallocate;mvalu "== engd 	41====== ==  uBla kabomallocate;mvalu "== engd 	42====== ==  uDon't knowabomallocate;mvalu " d 	43====== ==  uRefasedabomallocate;mvalu " engd 	50====== ==  uValu abombla k"=== == === eng =d 	52====== ==  uDon't knowabombla k"=== == === 
 	53====== ==  uRefasedabombla k"=== == === engd se VALUE a1whyab 	(defaul.=32)d 	0====== ===  uNo chang  H";o under  H";armed"d 	4 ====== ==  uAllocate;"== ength===== th=====d se VALUE a1payab 	(defaul.=32)d 	0====== ===  uNo chang  H";o under  H";armed"d 	4 ====== ==  uAllocate;"== ength===== th=====d se VALUE a1clswkm	(defaul.=32)d 	0====== ===  uNo chang  H";o under  H";armed"d 	4 ====== ==  uAllocate;"== ength===== th=====d se VALUE a1nlflj 	(defaul.=32)d 	0====== ===  uNo chang  H";o under  H";armed"d 	4 ====== ==  uAllocate;"== ength===== th=====d se VALUE a1uslhr 	(defaul.=32)d 	0====== ===  uNo chang  H";o under  H";armed"d 	4 ====== ==  uAllocate;"== ength===== th=====d se VALUE a1hrlywk	(defaul.=32)d 	0====== ===  uNo chang  H";o under  H";armed"d 	4 ====== ==  uAllocate;"== ength===== th=====d se VALUE prwern  	(defaul.=32)d 	0====== ===  uNo  allocate;"== ength===== th=d 	1 ====== ==  uAllocate;"== ength===== th=====d se VALUE prhern  	(defaul.=32)d 	0====== ===  uNo  allocate;"== ength===== th=d 	1 ====== ==  uAllocate;"== ength===== th=====d se VALUE a1unmem 	(defaul.=32)d 	0====== ===  uNo chang  H";o under  H";armed"d 	4 ====== ==  uAllocate;"== ength===== th=====d se VALUE a1uncov 	(defaul.=32)d 	0====== ===  uNo chang  H";o under  H";armed"d 	4 ====== ==  uAllocate;"== ength===== th=====d se VALUE a1enrlw 	(defaul.=32)d 	0====== ===  uNo chang  H";o under  H";armed"d 	4 ====== ==  uAllocate;"== ength===== th=====d se VALUE a1hscol 	(defaul.=32)d 	0====== ===  uNo chang  H";o under  H";armed"d 	4 ====== ==  uAllocate;"== ength===== th=====d se VALUE a1ftpn  	(defaul.=32)d 	0====== ===  uNo chang  H";o under  H";armed"d 	4 ====== ==  uAllocate;"== ength===== th=====d se VALUE i_ern   	(defaul.=32)d 	0====== ===  uNo chang  H";o under "= th=====d 	1 ====== ==  uAllocate;"== ength===== th=====d se VALUE i_ern   	(defaul.=32)d 	0====== ===  uNo chang  H";o under "= th=====d 	1 ====== ==  uAllocate;"== ength===== th=====d se VALUE i_ws    	(defaul.=32)d 	0====== ===  uNo chang  H";o under "= th=====d 	1 ====== ==  uAllocate;"== ength===== th=====d se VALUE i_ws    	(defaul.=32)d 	0====== ===  uNo chang  H";o under "= th=====d 	1 ====== ==  uAllocate;"== ength===== th=====d se VALUE i_se    	(defaul.=32)d 	0====== ===  uNo chang  H";o under "= th=====d 	1 ====== ==  uAllocate;"== ength===== th=====d se VALUE i_se    	(defaul.=32)d 	0====== ===  uNo chang  H";o under "= th=====d 	1 ====== ==  uAllocate;"== ength===== th=====d se VALUE i_frm   	(defaul.=32)d 	0====== ===  uNo chang  H";o under "= th=====d 	1 ====== ==  uAllocate;"== ength===== th=====d se VALUE i_frm   	(defaul.=32)d 	0====== ===  uNo chang  H";o under "= th=====d 	1 ====== ==  uAllocate;"== ength===== th=====d se VALUE i_uc    	(defaul.=32)d 	0====== ===  uNo chang  H";o under "= th=====d 	1 ====== ==  uAllocate;"== ength===== th=====d se VALUE i_uc    	(defaul.=32)d 	0====== ===  uNo chang  H";o under "= th=====d 	1 ====== ==  uAllocate;"== ength===== th=====d se VALUE i_wc    	(defaul.=32)d 	0====== ===  uNo chang  H";o under "= th=====d 	1 ====== ==  uAllocate;"== ength===== th=====d se VALUE i_wc    	(defaul.=32)d 	0====== ===  uNo chang  H";o under "= th=====d 	1 ====== ==  uAllocate;"== ength===== th=====d se VALUE i_wc    	(defaul.=32)d 	0====== ===  uNo chang  H";o under "= th=====d 	1 ====== ==  uAllocate;"== ength===== th=====d se VALUE i_ss    	(defaul.=32)d 	0====== ===  uNo chang  H";o under "= th=====d 	1 ====== ==  uAllocate;"== ength===== th=====d se VALUE i_ss    	(defaul.=32)d 	0====== ===  uNo chang  H";o under "= th=====d 	1 ====== ==  uAllocate;"== ength===== th=====d se VALUE i_ssi   	(defaul.=32)d 	0====== ===  uNo chang  H";o under "= th=====d 	1 ====== ==  uAllocate;"== ength===== th=====d se VALUE i_ssi   	(defaul.=32)d 	0====== ===  uNo chang  H";o under "= th=====d 	1 ====== ==  uAllocate;"== ength===== th=====d se VALUE i_paw   	(defaul.=32)d 	0====== ===  uNo chang  H";o under "= th=====d 	1 ====== ==  uAllocate;"== ength===== th=====d se VALUE i_paw   	(defaul.=32)d 	0====== ===  uNo chang  H";o under "= th=====d 	1 ====== ==  uAllocate;"== ength===== th=====d se VALUE i_paw   	(defaul.=32)d 	0====== ===  uNo chang  H";o under "= th=====d 	1 ====== ==  uAllocate;"== ength===== th=====d se VALUE i_pawmo 	(defaul.=32)d 	0====== ===  uNo chang  H";o under "= th=====d 	1 ====== ==  uAllocate;"== ength===== th=====d se VALUE i_vet   	(defaul.=32)d 	0====== ===  uNo chang  H";o under "= th=====d 	1 ====== ==  uAllocate;"== ength===== th=====d se VALUE i_vet   	(defaul.=32)d 	0====== ===  uNo chang  H";o under "= th=====d 	1 ====== ==  uAllocate;"== ength===== th=====d se VALUE i_vet   	(defaul.=32)d 	0====== ===  uNo chang  H";o under "= th=====d 	1 ====== ==  uAllocate;"== ength===== th=====d se VALUE i_vetqva	(defaul.=32)d 	0====== ===  uNo chang  H";o under "= th=====d 	1 ====== ==  uAllocate;"== ength===== th=====d se VALUE i_sur   	(defaul.=32)d 	0====== ===  uNo chang  H";o under "= th=====d 	1 ====== ==  uAllocate;"== ength===== th=====d se VALUE i_sursca	(defaul.=32)d 	0====== ===  uNo chang  H";o under "= th=====d 	1 ====== ==  uAllocate;"== ength===== th=====d se VALUE i_surscb	(defaul.=32)d 	0====== ===  uNo chang  H";o under "= th=====d 	1 ====== ==  uAllocate;"== ength===== th=====d se VALUE i_surv a	(defaul.=32)d 	0====== ===  uNo chang  H";o under "= th=====d 	1 ====== ==  uAllocate;"== ength===== th=====d se VALUE i_surv b	(defaul.=32)d 	0====== ===  uNo chang  H";o under "= th=====d 	1 ====== ==  uAllocate;"== ength===== th=====d se VALUE i_dissca	(defaul.=32)d 	0====== ===  uNo chang  H";o under "= th=====d 	1 ====== ==  uAllocate;"== ength===== th=====d se VALUE i_disscb	(defaul.=32)d 	0====== ===  uNo chang  H";o under "= th=====d 	1 ====== ==  uAllocate;"== ength===== th=====d se VALUE i_dish  	(defaul.=32)d 	0====== ===  uNo chang  H";o under "= th=====d 	1 ====== ==  uAllocate;"== ength===== th=====d se VALUE i_discs 	(defaul.=32)d 	0====== ===  uNo chang  H";o under "= th=====d 	1 ====== ==  uAllocate;"== ength===== th=====d se VALUE i_dis   	(defaul.=32)d 	0====== ===  uNo chang  H";o under "= th=====d 	1 ====== ==  uAllocate;"== ength===== th=====d se VALUE toi_    	(defaul.=32)d 	0====== ===  uNo  topcode;"== ength===== th==d 	1 ====== ==  uTopcode;"== ength===== th======d se VALUE i_disv a	(defaul.=32)d 	0====== ===  uNo chang  H";o under "= th=====d 	1 ====== ==  uAllocate;"== ength===== th=====d se VALUE i_disv b	(defaul.=32)d 	0====== ===  uNo chang  H";o under "= th=====d 	1 ====== ==  uAllocate;"== ength===== th=====d se VALUE i_ret   	(defaul.=32)d 	0====== ===  uNo chang  H";o under "= th=====d 	1 ====== ==  uAllocate;"== ength===== th=====d se VALUE i_retsca	(defaul.=32)d 	0====== ===  uNo chang  H";o under "= th=====d 	1 ====== ==  uAllocate;"== ength===== th=====d se VALUE i_retscb	(defaul.=32)d 	0====== ===  uNo chang  H";o under "= th=====d 	1 ====== ==  uAllocate;"== ength===== th=====d se VALUE i_retv a	(defaul.=32)d 	0====== ===  uNo chang  H";o under "= th=====d 	1 ====== ==  uAllocate;"== ength===== th=====d se VALUE i_retv b	(defaul.=32)d 	0====== ===  uNo chang  H";o under "= th=====d 	1 ====== ==  uAllocate;"== ength===== th=====d se VALUE i_int   	(defaul.=32)d 	0====== ===  uNo chang  H";o under "= th=====d 	1 ====== ==  uAllocate;"== ength===== th=====d se VALUE i_int   	(defaul.=32)d 	0====== ===  uNo chang  H";o under "= th=====d 	1 ====== ==  uAllocate;"== ength===== th=====d se VALUE i_div   	(defaul.=32)d 	0====== ===  uNo chang  H";o under "= th=====d 	1 ====== ==  uAllocate;"== ength===== th=====d se VALUE i_div   	(defaul.=32)d 	0====== ===  uNo chang  H";o under "= th=====d 	1 ====== ==  uAllocate;"== ength===== th=====d se VALUE i_rnt   	(defaul.=32)d 	0====== ===  uNo chang  H";o under "= th=====d 	1 ====== ==  uAllocate;"== ength===== th=====d se VALUE i_rnt   	(defaul.=32)d 	0====== ===  uNo chang  H";o under "= th=====d 	1 ====== ==  uAllocate;"== ength===== th=====d 	2 ====== ==  uAllocate; a lossrh==== length==d se VALUE i_ed    	(defaul.=32)d 	0====== ===  uNo chang  H";o under "= th=====d 	1 ====== ==  uAllocate;"== ength===== th=====d se VALUE i_ed   a	(defaul.=32)d 	0====== ===  uNo chang  H";o under "= th=====d 	1 ====== ==  uAllocate;"== ength===== th=====d se VALUE i_ed   b	(defaul.=32)d 	0====== ===  uNo chang  H";o under "= th=====d 	1 ====== ==  uAllocate;"== ength===== th=====d se VALUE i_oed   	(defaul.=32)d 	0====== ===  uNo chang  H";o under "= th=====d 	1 ====== ==  uAllocate;"== ength===== th=====d se VALUE i_csp   	(defaul.=32)d 	0====== ===  uNo chang  H";o under "= th=====d 	1 ====== ==  uAllocate;"== ength===== th=====d se VALUE i_csp   	(defaul.=32)d 	0====== ===  uNo chang  H";o under "= th=====d 	1 ====== ==  uAllocate;"== ength===== th=====d se VALUE i_alm   	(defaul.=32)d 	0====== ===  uNo chang  H";o under "= th=====d 	1 ====== ==  uAllocate;"== ength===== th=====d se VALUE i_alm   	(defaul.=32)d 	0====== ===  uNo chang  H";o under "= th=====d 	1 ====== ==  uAllocate;"== ength===== th=====d se VALUE i_fin   	(defaul.=32)d 	0====== ===  uNo chang  H";o under "= th=====d 	1 ====== ==  uAllocate;"== ength===== th=====d se VALUE i_fin   	(defaul.=32)d 	0====== ===  uNo chang  H";o under "= th=====d 	1 ====== ==  uAllocate;"== ength===== th=====d se VALUE i_oi    	(defaul.=32)d 	0====== ===  uNo chang  H";o under "= th=====d 	1 ====== ==  uAllocate;"== ength===== th=====d se VALUE i_nwlook	(defaul.=32)d 	0====== ===  uNo chang  H";o under "= th=====d 	1 ====== ==  uAllocate;"== ength===== th=====d se VALUE i_nwlkwk	(defaul.=32)d 	0====== ===  uNo chang  H";o under "= th=====d 	1 ====== ==  uAllocate;"== ength===== th=====d se VALUE i_rsnnot	(defaul.=32)d 	0====== ===  uNo chang  H";o under "= th=====d 	1 ====== ==  uAllocate;"== ength===== th=====d se VALUE i_losewk	(defaul.=32)d 	0====== ===  uNo chang  H";o under "= th=====d 	1 ====== ==  uAllocate;"== ength===== th=====d se VALUE i_lkweek	(defaul.=32)d 	0====== ===  uNo chang  H";o under "= th=====d 	1 ====== ==  uAllocate;"== ength===== th=====d se VALUE i_lkstr 	(defaul.=32)d 	0====== ===  uNo chang  H";o under "= th=====d 	1 ====== ==  uAllocate;"== ength===== th=====d se VALUE i_pyrsn 	(defaul.=32)d 	0====== ===  uNo chang  H";o under "= th=====d 	1 ====== ==  uAllocate;"== ength===== th=====d se VALUE i_phmem 	(defaul.=32)d 	0====== ===  uNo chang  H";o under "= th=====d 	1 ====== ==  uAllocate;"== ength===== th=====d se VALUE i_hrswk 	(defaul.=32)d 	0====== ===  uNo chang  H";o under "= th=====d 	1 ====== ==  uAllocate;"== ength===== th=====d se VALUE i_hrchk 	(defaul.=32)d 	0====== ===  uNo chang  H";o under "= th=====d 	1 ====== ==  uAllocate;"== ength===== th=====d se VALUE i_pt    	(defaul.=32)d 	0====== ===  uNo chang  H";o under "= th=====d 	1 ====== ==  uAllocate;"== ength===== th=====d se VALUE i_ptwks 	(defaul.=32)d 	0====== ===  uNo chang  H";o under "= th=====d 	1 ====== ==  uAllocate;"== ength===== th=====d se VALUE i_ptrsn 	(defaul.=32)d 	0====== ===  uNo chang  H";o under "= th=====d 	1 ====== ==  uAllocate;"== ength===== th=====d se VALUE i_ljcw  	(defaul.=32)d 	0====== ===  uNo chang  H";o under "= th=====d 	1 ====== ==  uAllocate;"== ength===== th=====d se VALUE i_indus 	(defaul.=32)d 	0====== ===  uNo chang  H";o under "= th=====d 	1 ====== ==  uAllocate;"== ength===== th=====d se VALUE i_occu  	(defaul.=32)d 	0====== ===  uNo chang  H";o under "= th=====d 	1 ====== ==  uAllocate;"== ength===== th=====d se VALUE i_workyn	(defaul.=32)d 	0====== ===  uNo chang  H";o under "= th=====d 	1 ====== ==  uAllocate;"== ength===== th=====d se VALUE i_wtemp 	(defaul.=32)d 	0====== ===  uNo chang  H";o under "= th=====d 	1 ====== ==  uAllocate;"== ength===== th=====d se VALUE i_wkswk 	(defaul.=32)d 	0====== ===  uNo chang  H";o under "= th=====d 	1 ====== ==  uAllocate;"== ength===== th=====d se VALUE i_wkchk 	(defaul.=32)d 	0====== ===  uNo chang  H";o under "= th=====d 	1 ====== ==  uAllocate;"== ength===== th=====d se VALUE i_ernsr 	(defaul.=32)d 	0====== ===  uNo chang  H";o under "= th=====d 	1 ====== ==  uAllocate;"== ength===== th=====d se VALUE i_noemp 	(defaul.=32)d 	0====== ===  uNo chang  H";o under "= th=====d 	1 ====== ==  uAllocate;"== ength===== th=====d se VALUE i_mig2  	(defaul.=32)d 	0====== ===  uNIU, H";no  chang d."== th=====d 	1 ====== ==  uAssigned from huaseof";er"gth=nd 	2 ====== ==  uAssigned from spuase"== th=====d 	3 ====== ==  uAssigned from mo  er h==gth====
 	4 ====== ==  uAssigned from fa  er h==gth====
 	5 ====== ==  uAllocate; from matrix MIG1"====
 	6 ====== ==  uAllocate; from matrix MIG2"====
 	7 ====== ==  uAllocate; from MIG3"== ength===
 	8 ====== ==  uAllocate; from MIG4"== ength===
 	9 ====== ==  uAllocate; from MIG5"== ength===
 	10====== ==  uAllocate; from MIG6"== ength===
 se VALUE i_penpla	(defaul.=32)d 	0====== ===  uNo chang  H";o under "= th=====d 	1 ====== ==  uAllocate;"== ength===== th=====d se VALUE i_penin 	(defaul.=32)d 	0====== ===  uNo chang  H";o under "= th=====d 	1 ====== ==  uAllocate;"== ength===== th=====d se VALUE i_mig1  	(defaul.=32)d 	0====== ===  uNIU, H";no  chang d."== th=====d 	1 ====== ==  uAssigned from huaseof";er."====
 	2 ====== ==  uAssigned from spuase"== th=====d 	3 ====== ==  uAssign from mo  er h==gth======
 	4 ====== ==  uAssign from fa  er h==gth======
 	5 ====== ==  uAllocate; from matrix mob h==gtd se VALUE p_mv    	(defaul.=32)d 	0====== ===  uNon   gt =====   ===nh ength=n d se VALUE p_mv  id	(defaul.=32)d 	0====== ===  uNon   gt =====   ===nh ength=n d se VALUE emcontrb	(defaul.=32)d 	0====== ===  uNon   gt =====   ===nh ength=n d se VALUE filestla	(defaul.=32)d 	1 ====== ==  uJoint, bo   <65  gt =====   ===
 	2 ====== ==  uJoint, on  <65 &  on  65+"gth=nd 	3 ====== ==  uJoint, bo   65+"gth=n====   ===
 	4 ====== ==  uHead Hf huaseof";"h=n====   ===
 	5 ====== ==  uSingl "=========en====== == th d 	6 ====== ==  uNonfiler h==gth===== ======= ==d se VALUE dep_stla	(defaul.=32)d 	0====== ===  uNo  a dependnin gth===== th= ==d se VALUE ctc_crd 	(defaul.=32)d 	0====== ===  uNon   gt =====   ===nh ength=n d se VALUE eit_cred	(defaul.=32)d 	0====== ===  uNon   gt =====   ===nh ength=n d se VALUE actc_crd	(defaul.=32)d 	0====== ===  uNon   gt =====   ===nh ength=n d se VALUE fica    	(defaul.=32)d 	0====== ===  uNon   gt =====   ===nh ength=n d se VALUE fed_ret 	(defaul.=32)d 	0====== ===  uNon   gt =====   ===nh ength=n d se VALUE agi     	(defaul.=32)d 	0====== ===  uNon  H";no  in
   y ms  h==gth=d se VALUE cap_gain	(defaul.=32)d 	0====== ===  uNon   gt =====   ===nh ength=n d se VALUE cap_loss	(defaul.=32)d 	0====== ===  uNon   gt =====   ===nh ength=n d se VALUE tax_inc 	(defaul.=32)d 	0====== ===  uNon   gt =====   ===nh ength=n d se VALUE marg_tax	(defaul.=32)d 	0====== ===  uNon   gt =====   ===nh ength=n d se VALUE pemlr   	(defaul.=32)d 	0====== ===  uNIUrh==== length========en=====d 	1 ====== ==  uEmployeda- at work h==gth======
 	2 ====== ==  uEmployeda- absnin gth===== th= d 	3 ====== ==  uUnemployeda- on layoff"=== th= d 	4 ====== ==  uUnemployeda- looking" ==== th= d 	5 ====== ==  uNo  in
labH";forc a- retire;"h=d 	6 ====== ==  uNo  in
labH";forc a- disable;"h
 	7 ====== ==  uNo  in
labH";forc a- o  er h==gd se VALUE prun    	(defaul.=32)d 	0====== ===  uNIUrh==== length========en=====d 	1 ====== ==  uJob loser/on layoff"=== th= ===
 	2 ====== ==  uO  er job loser"gth=n====   ===
 	3 ====== ==  uTempor    job endnd"=== th= ===
 	4 ====== ==  uJob leay m h==gth===== =th= ===
 	5 ====== ==  uRe-ninrain gth===== th= === ===
 	6 ====== ==  uNew-ninrain gth===== th= === ==d se VALUE prwkstla	(defaul.=32)d 	0====== ===  uNIUrh==== length========en=====d 	1 ====== ==  uNo  in
labH";forc  h==gth======
 	2 ====== ==  uFT huars (35+), usually FT"====
 	3 ====== ==  uPT;for economic reasons,"======
 	4 ====== ==  uPT;for non-economic reasons,"==d 	5 ====== ==  uNo  at work, usually FT"=======
 	6 ====== ==  uPT;hrs, usually PT;for economicrd 	7 ====== ==  uPT;hrs, usually PT;for non-" ==
 	8 ====== ==  uFT huars, usually PT;for"======
 	9 ====== ==  uFT huars, usually PT;for non-" 
 	10====== ==  uNo  at work, usually part-timw"d 	11====== ==  uUnemployedaFT"==========en=====d 	12====== ==  uUnemployedaPT"==========en=====d se VALUE prptrea 	(defaul.=32)d 	-1====== ==  uNIUa- adul. civilian" ==== th= d 	0====== ===  uNIUa- o under  H";Armed Forc srd 	1 ====== ==  uUsually FTa- slackiwork/"======
 	2 ====== ==  uUsually FTa- seasonal work h==gd 	3 ====== ==  uUsually FTa- job stlrte;/endnd"d 	4 ====== ==  uUsually FTa- vacati  /p rsonal"d 	5 ====== ==  uUsually FTa- ow  illness/"gth=nd 	6 ====== ==  uUsually FTa- of"iday" ==== th= d 	7 ====== ==  uUsually FTa- o und     "=======
 	8 ====== ==  uUsually FTa- o  er fam/p rs" ==
 	9 ====== ==  uUsually FTa- labH";disput " engd 	10====== ==  uUsually FTa- wea  er affecte;"h
 	11====== ==  uUsually FTa- school/nraining" =d 	12====== ==  uUsually FTa- oivic/milit   " ==
 	13====== ==  uUsually FTa- o  er reason"gth=nd 	14====== ==  uUsually PT;- slack h==gth======
 	15====== ==  uUsually PT;- PT;cound only find"d 	16====== ==  uUsually PT;- seasonal work h==gd 	17====== ==  uUsually PT;- o und     "=======
 	18====== ==  uUsually PT;- o  er fam/p rs" ==
 	19====== ==  uUsually PT;- health/medical" ==
 	20====== ==  uUsually PTa- school/nraining" =d 	21====== ==  uUsually PTa- retire;/social" ==
 	22====== ==  uUsually PTa- workweek <35 huars"d 	23====== ==  uUsually PTa- o  er reason"gth=nd se VALUE prdisc  	(defaul.=32)d 	0====== ===  uNIUrh==== length========en=====d 	1 ====== ==  uDiscuaraged worker h==gth======
 	2 ====== ==  uConditi  ally interesnnd"=== thd 	3 ====== ==  uNo  available"==========en=====d se VALUE prcow1  	(defaul.=32)d 	0====== ===  uNIUrh==== length========en=====d 	1 ====== ==  uFe; mal gbyn gth===== th= === =
 	2 ====== ==  uStlaeigbyn gth===== th= === =thd 	3 ====== ==  uLocal gbyn gth===== th= === ===
 	4 ====== ==  uPrivat  (in l. self-employe;"h=d 	5 ====== ==  uSelf-employe;,
   ncorp."=== thd 	6 ====== ==  uWithuatipay gth===== th= === ==d se VALUE prp r   	(defaul.=32)d 	1 ====== ==  uC und huaseof"; member h==gth==
 	2 ====== ==  uAdul. civilian huaseof"; member d 	3 ====== ==  uAdul. Armed Forc s huaseof";"h=d se VALUE peabsrsn	(defaul.=32)d 	-1====== ==  uNIUa- adul. civilian" ==== th= d 	0====== ===  uNIUa- o under  H";Armed Forc srd 	2 ====== ==  uSlackiwork/business;conditi  s"d 	4 ====== ==  uVacati  /p rsonal days h==gth==
 	5 ====== ==  uOw  illness/injury/medical" ==hd 	6 ====== ==  uC und      problemsrh==== lengtd 	7 ====== ==  uO  er family/p rsonal"=== lengtd 	8 ====== ==  uMat rnity/pat rnity leay "gth=nd 	9 ====== ==  uLabH";disput " enggggggggggggggd 	10====== ==  uWea  er affecte; job h==gth=== 
 	11====== ==  uSchool/nraining" =gggggggggggggd 	12====== ==  uCivic/milit    du  rh==== lengt
 	13====== ==  uDo s no  work in
  e
business"nd 	14====== ==  uO  er (specify)" =gggggggggggggd se VALUE peio1cow	(defaul.=32)d 	0====== ===  uNIUrh==== length========en=====d 	1 ====== ==  uGby mnmnin-fe; mal h==gth======
 	2 ====== ==  uGby mnmnin-stlaerh==== length==d 	3 ====== ==  uGby mnmnina- local h==gth======
 	4 ====== ==  uPrivat ,;for profitrh==== lengt
 	5 ====== ==  uPrivat ,;nonprofitrh==== lengthd 	6 ====== ==  uSelf-employe;,
 ncorpor nnd"===d 	7 ====== ==  uSelf-employe;,
   ncorpor nnd"=d 	8 ====== ==  uWithuatipay gth===== th= === ==d se VALUE prnlfsch	(defaul.=32)d 	0====== ===  uNIUrh==== length========en=====d 	1 ====== ==  uIn school"== ength===== th=====d 	2 ====== ==  uNo  in
school"== ength===== th=d se VALUE pehrusla	(defaul.=32)d 	-4====== ==  uHuars vary h==gth===== ========d 	-1====== ==  uNIUa- adul. civilian" ==== th= d 	0====== ===  uNIUa- o under  H";Armed Forc srd se VALUE peinusym	(defaul.=32)d 	0====== ===  uNIUrh==== length========en=====d 	1 ====== ==  uBefore 1950 h==gth===== =======d 	2 ====== ==  u1950-1959rh==== lengt =========d 	3 ====== ==  u1960-1964rh==== lengt =========d 	4 ====== ==  u1965-1969rh==== lengt =========d 	5 ====== ==  u1970-1974rh==== lengt =========d 	6 ====== ==  u1975-1979rh==== lengt =========d 	7 ====== ==  u1980-1981rh==== lengt =========d 	8 ====== ==  u1982-1983rh==== lengt =========d 	9 ====== ==  u1984-1985  gt =====   =========d 	10====== ==  u1986-1987  gt =====   =========d 	11====== ==  u1988-1989rh==== lengt =========d 	12====== ==  u1990-1991rh==== lengt =========d 	13====== ==  u1992-1993rh==== lengt =========d 	14====== ==  u1994-1995  gt =====   =========d 	15====== ==  u1996-1997  gt =====   =========d 	16====== ==  u1998-1999rh==== lengt =========d 	17====== ==  u2000-2001rh==== lengt =========d 	18====== ==  u2002-2003rh==== lengt =========d 	19====== ==  u2004-2007  gt =====   =========d se VALUE prcitsh 	(defaul.=32)d 	1 ====== ==  uNative, born in
  e
Unitnd"=== d 	2 ====== ==  uNative, born in
Pu r o Rico H" d 	3 ====== ==  uNative, born abroad Hf American"d 	4 ====== ==  uForeign born, U.S. citizr  by"=d 	5 ====== ==  uForeign born, no  a citizr  ofrd se VALUE pxnatvty	(defaul.=32)d 	-1====== ==  uNo  allocate;"== ength===== th=d 	0====== ===  uValu a- no chang "=== == === end 	1 ====== ==  uBla ka- no chang "=== == === end 	2 ====== ==  uDon't knowa- no chang "=== == =d 	3 ====== ==  uRefaseda- no chang "=== == === d 	10===== ===  uValu abomvalu "=== == === eng =d 	11====== ==  uBla kabomvalu "=== == === eng =d 	12====== ==  uDon't knowabomvalu "=== == === d 	13====== ==  uRefasedabomvalu "=== == === engd 	20====== ==  uValu abomlongitudinalmvalu "===d 	21====== ==  uBla kabomlongitudinalmvalu "===d 	22====== ==  uDon't knowabomlongitudinal" engd 	23====== ==  uRefasedabomlongitudinalmvalu "=d 	30====== ==  uValu abomallocate;mvalu mlong. d 	31====== ==  uBla kabomallocate;mvalu mlong."d 	32====== ==  uDon't knowabomallocate;mvalu " d 	33====== ==  uRefasedabomallocate;mvalu " engd 	40====== ==  uValu abomallocate;mvalu "== engd 	41====== ==  uBla kabomallocate;mvalu "== engd 	42====== ==  uDon't knowabomallocate;mvalu " d 	43====== ==  uRefasedabomallocate;mvalu " engd 	50====== ==  uValu abombla k"=== == === eng =d 	52====== ==  uDon't knowabombla k"=== == === 
 	53====== ==  uRefasedabombla k"=== == === engd se VALUE perrp   	(defaul.=32)d 	1 ====== ==  uRefeer ce=p rson.w/rels."=== thd 	2 ====== ==  uRefeer ce=p rson.w/o rels."=== d 	3 ====== ==  uSpuase"== th====== == === eng =d 	4 ====== ==  uC undrh==== length========en===d 	5 ====== ==  uGrandc undrh==== length========d 	6 ====== ==  uParest"== th====== == === eng =d 	7 ====== ==  uBro  er/sist m h==gth===== =th=d 	8 ====== ==  uO  er rel. Hf ref.=p rson"gth=nd 	9 ====== ==  uFost m c undrh==== length======d 	10===== ===  uNo rel. Hf ref.=p rson.w/rels."d 	11====== ==  uNo  ased"== th====== == === engd 	12====== ==  uNo rel. Hf ref.=p rson.w/o h==gd 	13====== ==  uUnmarriedapartn m w/rels."=== td 	14====== ==  uUnmarriedapartn m w/o rels."===d 	15====== ==  uHuasemate/roommate w/rels."=== d 	16====== ==  uHuasemate/roommate w/o rels."==d 	17====== ==  uRoomer/board m w/rels."=== t ==d 	18====== ==  uRoomer/board m w/o rels."=== ngd se VALUE i_mig3  	(defaul.=32)d 	0====== ===  uNIU, H";no  chang d."== th=====d 	1 ====== ==  uStlaeiary"below assigned"=== thd 	2 ====== ==  uCoun  iary"below assigned"=== td 	3 ====== ==  uMCDiary"below assigned"=== th==
 	4 ====== ==  uPlace=onlyrh==== length========d 	5 ====== ==  uCoun  iin
New York Ci  rh==== ld se VALUE hi      	(defaul.=32)d 	0====== ===  uNIUrh==== length========en=====d 	1 ====== ==  uYesrh==== length========en=====d 	2 ====== ==  uNorh==== length========en===== d se VALUE hi      	(defaul.=32)d 	0====== ===  uNIUrh==== length========en=====d 	1 ====== ==  uFamily pla  h==gth===== =======d 	2 ====== ==  uSelf-onlyrh==== length======== d se VALUE dephi   	(defaul.=32)d 	0====== ===  uNIUrh==== length========en=====d 	1 ====== ==  uYesrh==== length========en=====d se VALUE hilin1  	(defaul.=32)d 	0====== ===  uNIUrh==== length========en=====d se VALUE hilin2  	(defaul.=32)d 	0====== ===  uNIUrh==== length========en=====d se VALUE pair g  	(defaul.=32)d 	0====== ===  uNIUrh==== length========en=====d 	1 ====== ==  uAll h==gth===== ======= == th==d 	2 ====== ==  uParn gth===== th=====  =nh=g ==d 	3 ====== ==  uNon   gt =====   ===nh ength=n d se VALUE hiuati  	(defaul.=32)d 	0====== ===  uNIUrh==== length========en=====d 	1 ====== ==  uYesrh==== length========en=====d 	2 ====== ==  uNorh==== length========en===== d se VALUE priv i  	(defaul.=32)d 	0====== ===  uNIUrh==== length========en=====d 	1 ====== ==  uYesrh==== length========en=====d 	2 ====== ==  uNorh==== length========en===== d se VALUE pri     	(defaul.=32)d 	0====== ===  uNIUrh==== length========en=====d 	1 ====== ==  uFamily pla  h==gth===== =======d 	2 ====== ==  uSelf-onlyrh==== length======== d se VALUE depriv i	(defaul.=32)d 	0====== ===  uNo H";NIUrh==== length========ed 	1 ====== ==  uYesrh==== length========en=====d se VALUE pilin1  	(defaul.=32)d 	0====== ===  uNIUrh==== length========en=====d se VALUE pilin2  	(defaul.=32)d 	0====== ===  uNIUrh==== length========en=====d se VALUE puati   	(defaul.=32)d 	0====== ===  uNIUrh==== length========en=====d 	1 ====== ==  uYesrh==== length========en=====d 	2 ====== ==  uNorh==== length========en===== d se VALUE uati    	(defaul.=32)d 	0====== ===  uNIUrh==== length========en=====d 	1 ====== ==  uYesrh==== length========en=====d 	2 ====== ==  uNorh==== length========en===== d se VALUE         	(defaul.=32)d 	0====== ===  uNIUrh==== length========en=====d 	1 ====== ==  uYesrh==== length========en=====d 	2 ====== ==  uNorh==== length========en===== d se VALUE   ir g  	(defaul.=32)d 	0====== ===  uNIUrh==== length========en=====d 	1 ====== ==  uYesrh==== length========en=====d 	2 ====== ==  uNorh==== length========en===== d se VALUE mon  g  	(defaul.=32)d 	0====== ===  uNIUrh==== length========en=====d se VALUE uth  g  	(defaul.=32)d 	0====== ===  uNIUrh==== length========en=====d 	1 ====== ==  uYesrh==== length========en=====d 	2 ====== ==  uNorh==== length========en===== d se VALUE u   _1  	(defaul.=32)d 	0====== ===  uNorh==== length========en===== d 	1 ====== ==  uYesrh==== length========en=====d se VALUE u   _2  	(defaul.=32)d 	0====== ===  uNorh==== length========en===== d 	1 ====== ==  uYesrh==== length========en=====d se VALUE u   _3  	(defaul.=32)d 	0====== ===  uNorh==== length========en===== d 	1 ====== ==  uYesrh==== length========en=====d se VALUE u   _4  	(defaul.=32)d 	0====== ===  uNorh==== length========en===== d 	1 ====== ==  uYesrh==== length========en=====d se VALUE u   _5  	(defaul.=32)d 	0====== ===  uNorh==== length========en===== d 	1 ====== ==  uYesrh==== length========en=====d se VALUE u hstp m	(defaul.=32)d 	0====== ===  uNIUrh==== length========en=====d 	1 ====== ==  uYesrh==== length========en=====d 	2 ====== ==  uNorh==== length========en===== d se VALUE u hst  a	(defaul.=32)d 	0====== ===  uNIUrh==== length========en=====d 	1 ====== ==  uMedicar   gt =====   ===nh engtd 	2 ====== ==  uMedicaid"== th====== == === engd 	3 ====== ==  uCHAMPUSrh==== length========en=d 	4 ====== ==  uCHAMPVArh==== length========en=d 	5 ====== ==  uVA health car   gt =====   ===nd 	6 ====== ==  uMilit    health car   gt ===== d 	7 ====== ==  uStlaeiC under 's Healthrh==== ld 	8 ====== ==  uIndian health servic  h==gth===d 	9 ====== ==  uO  er gby mnmninahealth car   gd 	10===== ===  uEmployer/union-providnd"=== th=d 	11====== ==  uEmployer/union-providnd (as" ==
 	12====== ==  uPrivat ly purchasnd"=== th= ===
 	13====== ==  uPrivat ly purchasnd (as" == ===
 	14====== ==  uPla  of someon  Hunsidn   e"===d 	15====== ==  uO  er h==gth====== =====   ===nd se VALUE hea     	(defaul.=32)d 	0====== ===  uNIUrh==== length========en=====d 	1 ====== ==  uExcellest"== th====== == === end 	2 ====== ==  uVe   goo;"== ength===== th=====d 	3 ====== ==  uGbo;"== ength===== th==========d 	4 ====== ==  uFair h==gth====== =====   ===n=d 	5 ====== ==  uPoor h==gth====== =====   ===n=d se VALUE i_hi    	(defaul.=32)d 	0====== ===  uNorh==== length========en===== d 	1 ====== ==  uAllocate;"== ength===== th=====d se VALUE i_dephi 	(defaul.=32)d 	0====== ===  uNorh==== length========en===== d 	1 ====== ==  uAllocate;"== ength===== th=====d se VALUE i_pair g	(defaul.=32)d 	0====== ===  uNorh==== length========en===== d 	1 ====== ==  uAllocate;"== ength===== th=====d se VALUE i_hiuati	(defaul.=32)d 	0====== ===  uNorh==== length========en===== d 	1 ====== ==  uAllocate;"== ength===== th=====d se VALUE i_priv i	(defaul.=32)d 	0====== ===  uNorh==== length========en===== d 	1 ====== ==  uAllocate;"== ength===== th=====d se VALUE i_depriv	(defaul.=32)d 	0====== ===  uNorh==== length========en===== d 	1 ====== ==  uAllocate;"== ength===== th=====d se VALUE i_puati 	(defaul.=32)d 	0====== ===  uNorh==== length========en===== d 	1 ====== ==  uAllocate;"== ength===== th=====d se VALUE i_uati  	(defaul.=32)d 	0====== ===  uNorh==== length========en===== d 	1 ====== ==  uAllocate;"== ength===== th=====d se VALUE i_      	(defaul.=32)d 	0====== ===  uNorh==== length========en===== d 	1 ====== ==  uAllocate;"== ength===== th=====d 	2 ====== ==  uLogical imput ;"== ength===== td se VALUE i_  ir g	(defaul.=32)d 	0====== ===  uNorh==== length========en===== d 	1 ====== ==  uAllocate;"== ength===== th=====d 	2 ====== ==  uLogical imput ;"== ength===== td se VALUE i_mon  g	(defaul.=32)d 	0====== ===  uNorh==== length========en===== d 	1 ====== ==  uAllocate;"== ength===== th=====d se VALUE i_uth  g	(defaul.=32)d 	0====== ===  uNorh==== length========en===== d 	1 ====== ==  uAllocate;"== ength===== th=====d 	2 ====== ==  uLogical imput ;"== ength===== td se VALUE i_o     	(defaul.=32)d 	0====== ===  uNorh==== length========en===== d 	1 ====== ==  uAllocate;"== ength===== th=====d 	2 ====== ==  uLogical imput ;"== ength===== td se VALUE i_ostp m	(defaul.=32)d 	0====== ===  uNorh==== length========en===== d 	1 ====== ==  uAllocate;"== ength===== th=====d se VALUE i_us    	(defaul.=32)d 	0====== ===  uNorh==== length========en===== d 	1 ====== ==  uAllocate;"== ength===== th=====d se VALUE i_hea   	(defaul.=32)d 	0====== ===  uNorh==== length========en===== d 	1 ====== ==  uAllocate;"== ength===== th=====d se VALUE ssi_    	(defaul.=32)d 	0====== ===  uNon  H";no  in
   y ms  h==gth=d se VALUE ws_     	(defaul.=32)d 	0====== ===  uNon  H";no  in
   y ms  h==gth=d se VALUE se_     	(defaul.=32)d 	0====== ===  uNon  H";no  in
   y ms  h==gth=d se VALUE ihsflg  	(defaul.=32)d 	1 ====== ==  uYesrh==== length========en=====d 	2 ====== ==  uNorh==== length========en===== d se VALUE tsurvala	(defaul.=32)d 	0====== ===  uNo  topcode;"== ength===== th==d 	1 ====== ==  uTopcode;"== ength===== th======d se VALUE tsurvalb	(defaul.=32)d 	0====== ===  uNo  topcode;"== ength===== th==d 	1 ====== ==  uTopcode;"== ength===== th======d se VALUE tdisvala	(defaul.=32)d 	0====== ===  uNo  topcode;"== ength===== th==d 	1 ====== ==  uTopcode;"== ength===== th======d se VALUE tdisvalb	(defaul.=32)d 	0====== ===  uNo  topcode;"== ength===== th==d 	1 ====== ==  uTopcode;"== ength===== th======d se VALUE tret   a	(defaul.=32)d 	0====== ===  uNo  topcode;"== ength===== th==d 	1 ====== ==  uTopcode;"== ength===== th======d se VALUE tret   b	(defaul.=32)d 	0====== ===  uNo  topcode;"== ength===== th==d 	1 ====== ==  uTopcode;"== ength===== th======d se VALUE tint_   	(defaul.=32)d 	0====== ===  uNo  topcode;"== ength===== th==d 	1 ====== ==  uTopcode;"== ength===== th======d se VALUE tdiv_   	(defaul.=32)d 	0====== ===  uNo  topcode;"== ength===== th==d 	1 ====== ==  uTopcode;"== ength===== th======d se VALUE trnt_   	(defaul.=32)d 	0====== ===  uNo  topcode;"== ength===== th==d 	1 ====== ==  uTopcode;"== ength===== th======d se VALUE ted_    	(defaul.=32)d 	0====== ===  uNo  topcode;"== ength===== th==d 	1 ====== ==  uTopcode;"== ength===== th======d se VALUE tcsp_   	(defaul.=32)d 	0====== ===  uNo  topcode;"== ength===== th==d 	1 ====== ==  uTopcode;"== ength===== th======d se VALUE talm_   	(defaul.=32)d 	0====== ===  uNo  topcode;"== ength===== th==d 	1 ====== ==  uTopcode;"== ength===== th======d se VALUE tfin_   	(defaul.=32)d 	0====== ===  uNo  topcode;"== ength===== th==d 	1 ====== ==  uTopcode;"== ength===== th======d se VALUE nxtres  	(defaul.=32)d 	0====== ===  uNIUrh==== length========en=====d 	1 ====== ==  uChang  in
marital stltusrh==== d 	2 ====== ==  uTo estlblish ow  huaseof";"h=n=d 	3 ====== ==  uO  er family reason"gth=nh==== d 	4 ====== ==  uNew job or job nraisfer h==gth=d 	5 ====== ==  uTo look;for work or lus  job h=d 	6 ====== ==  uTo be closerabomwork/easier h==d 	7 ====== ==  uRetire;"h=length========en=====d 	8 ====== ==  uO  er job-relate;mreason"gth=nhd 	9 ====== ==  uWantedabomow  hume, no  rest"==d 	10===== ===  uWantedanew or bett m huase/"===d 	11===== ===  uWantedabett m neighborhbo;"== e
 	12====== ==  uCheap m huasing" =gggggggggggggd 	13====== ==  uO  er huasing reason"gth=nh====
 	14====== ==  uAtt nd/leay  colleg   gt ===== d 	15====== ==  uChang  of climlaerh==== length=
 	16====== ==  uHealth reasons  gt =====   ===nd 	17====== ==  uNltumal disast m h==gth===== =t
 	18====== ==  uO  er reason"gth=n==gth===== =t
 se VALUE i_nxtres	(defaul.=32)d 	0====== ===  uNIU, H";no  chang d"=== th= ===
 	1====== ===  uAssigned from huaseof";er"gth=nd 	2 ====== ==  uAssigned from spuase"== th=====d 	3 ====== ==  uAssigned from mo  er h==gth====
 	4 ====== ==  uAssigned from fa  er h==gth====
 	5 ====== ==  uAllocate; from matrix h==gth===d se VALUE frm_    	(defaul.=32)d 	0====== ===  uNon  H";no  in
   y ms  h==gth=d se VALUE nrai    	(defaul.=32)d 	0====== ===  uNIUrh==== length========en=====d 	1 ====== ==  uYesrh==== length========en=====d 	2 ====== ==  uNorh==== length========en===== d se VALUE nrai  a 	(defaul.=32)d 	0====== ===  uNo  imput ; H";NIUrh==== lengthd 	1 ====== ==  uImput ;"== ength===== ten===== d se VALUE ccayn  g	(defaul.=32)d 	0====== ===  uNIUrh==== length========en=====d 	1 ====== ==  uYesrh==== length========en=====d 	2 ====== ==  unorh==== length========en===== d se VALUE  cayna  	(defaul.=32)d 	0====== ===  uNo  imput ; H";NIUrh==== lengthd 	1 ====== ==  uImput ;"== ength===== ten===== d se VALUE pairccyn	(defaul.=32)d 	0====== ===  uNIUrh==== length========en=====d 	1 ====== ==  uYesrh==== length========en=====d 	2 ====== ==  uNorh==== length========en===== d se VALUE paircyna	(defaul.=32)d 	0====== ===  uNo  imput ; H";NIUrh==== lengthd 	1 ====== ==  uImput ;"== ength===== ten===== d se VALUE ahip m  	(defaul.=32)d 	0====== ===  uNIUrh==== length========en=====d 	1 ====== ==  uYesrh==== length========en=====d 	2 ====== ==  uNorh==== length========en===== d se VALUE iahip m 	(defaul.=32)d 	0====== ===  uNo  imput ; OR;NIUrh==== lengthd 	1 ====== ==  uImput ;"== ength===== ten===== d se VALUE ahityp6 	(defaul.=32)d 	0====== ===  uNIUrh==== length========en=====d 	1 ====== ==  uMedicar   gt =====   ===nh engtd 	2 ====== ==  uMedicaid"== th====== == === engd 	3 ====== ==  uTricar  H";o ampusrh==== lengthd 	4 ====== ==  uCAMPVA ('CHAMPVA' is   e"=== ==
 	5 ====== ==  uVa health car   gt =====   ===nd 	6 ====== ==  uMilit    health car   gt ===== d 	7 ====== ==  uC under 's health insumance"===d 	8 ====== ==  uIndian health servic  h==gth===d 	9 ====== ==  uO  er gby mnmninahealth car   gd 	10===== ===  uEmployer/union-providnd"=== th=d 	11====== ==  uEmployer/union-providnd (as" ==
 	12====== ==  uPrivat ly purchasnd"=== th= ===
 	13====== ==  uPrivat ly purchasnd (as" == ===
 	14====== ==  uPla  of someon  Hunsidn   e"===d 	15====== ==  uO  er h==gth====== =====   ===nd se VALUE iahityp 	(defaul.=32)d 	0====== ===  uNo  imput ; OR;NIUrh==== lengthd 	1 ====== ==  uNIUrh==== length========en=====d se VALUE pchip   	(defaul.=32)d 	0====== ===  uNIUrh==== length========en=====d 	1 ====== ==  uYesrh==== length========en=====d 	2 ====== ==  uNorh==== length========en===== d se VALUE i_pchip 	(defaul.=32)d 	0====== ===  uNo  imput ; H";NIUrh==== lengthd 	1 ====== ==  uImput ;"== ength===== ten===== d se VALUE resnss1 	(defaul.=32)d 	0====== ===  uNIUrh==== length========en=====d 	1 ====== ==  uRetire;"h=length========en=====d 	2 ====== ==  uDisable; (adul. H";o und)"gth=nd 	3 ====== ==  uWidowe;"h=length========en=====d 	4 ====== ==  uSpuase"== th====== == === eng =d 	5 ====== ==  uSurviving c undrh==== length===d 	6 ====== ==  uDependnin c undrh==== length===d 	7 ====== ==  uonabehalf of surviving," == ===
 	8 ====== ==  uO  er (adul. H";o und)"gth=n = d se VALUE resnss2 	(defaul.=32)d 	0====== ===  uNIUrh==== length========en=====d 	1 ====== ==  uRetire;"h=length========en=====d 	2 ====== ==  uDisable; (adul. H";o und)"gth=nd 	3 ====== ==  uWidowe;"h=length========en=====d 	4 ====== ==  uSpuase"== th====== == === eng =d 	5 ====== ==  uSurviving c undrh==== length===d 	6 ====== ==  uDependnin c undrh==== length===d 	7 ====== ==  uOnabehalf of surviving," == ===
 	8 ====== ==  uO  er (adul. H";o und)"gth=n = d se VALUE resnssa 	(defaul.=32)d 	0====== ===  uNo  imput ; H";no  in
   y ms  d 	1 ====== ==  uImput ;"== ength===== ten===== d se VALUE resnssia	(defaul.=32)d 	0====== ===  uNIUrh==== length========en=====d 	1 ====== ==  uDisable; (adul. H";o und)"gth=nd 	2 ====== ==  uBlin; (adul. H";o und)"gth=n n=d 	3 ====== ==  uOnabehalf of a disable; c undrhd 	4 ====== ==  uOnabehalf of a blin; c undrh===d 	5 ====== ==  uO  er (adul. H";o und)"gth=n = d se VALUE resnssib	(defaul.=32)d 	0====== ===  uNIUrh==== length========en=====d 	1 ====== ==  uDisable; (adul. H";o und)"gth=nd 	2 ====== ==  uBlin; (adul. H";o und)"gth=n n=d 	3 ====== ==  uOnabehalf of a disable; c undrhd 	4 ====== ==  uOnabehalf of a blin; c undrh===d 	5 ====== ==  uO  er (adul. H";o und)"gth=n = d se VALUE resnssix	(defaul.=32)d 	0====== ===  uNo  imput ; H";no  in
   y ms  d 	1 ====== ==  uImput ;"== ength===== ten===== d se VALUE ssikidyn	(defaul.=32)d 	0====== ===  uNIUrh==== length========en=====d 	1 ====== ==  uRece y d SSI"== ength===== th==d 	2 ====== ==  uDid no  rece y  SSI"== ength===d se VALUE ssikdyna	(defaul.=32)d 	0====== ===  uNo  imput ; H";no  in
   y ms  d 	1 ====== ==  uImput ;"== ength===== ten===== d se VALUE sskidyn 	(defaul.=32)d 	0====== ===  uNIUrh==== length========en=====d 	1 ====== ==  uRece y d SSrh==== length=======d 	2 ====== ==  uDid no  rece y  SSrh==== lengthd se VALUE sskidyna	(defaul.=32)d 	0====== ===  uNo  imput ; H";no  in
   y ms  d 	1 ====== ==  uImput ;"== ength===== ten===== d se VALUE jcyn  g 	(defaul.=32)d 	0====== ===  uNIUrh==== length========en=====d 	1 ====== ==  uAtt nde; a job search program"=d 	2 ====== ==  uDid no "== ength===== ten===== d se VALUE jcyna   	(defaul.=32)d 	0====== ===  uNo  imput ; H";no  in
   y ms  d 	1 ====== ==  uImput ;"== ength===== ten===== d se VALUE jryn  g 	(defaul.=32)d 	0====== ===  uNIUrh==== length========en=====d 	1 ====== ==  uAtt nde; job readiness"nen=====d 	2 ====== ==  uDid no  att nd  gt =====   ===nd se VALUE jryna   	(defaul.=32)d 	0====== ===  uNo  imput ; H";no  in
   y ms  d 	1 ====== ==  uImput ;"== ength===== ten===== d se VALUE jtyn  g 	(defaul.=32)d 	0====== ===  uNIUrh==== length========en=====d 	1 ====== ==  uAtt nde; a nraining program tord 	2 ====== ==  uDid no  att nd  gt =====   ===nd se VALUE jtyna   	(defaul.=32)d 	0====== ===  uNo  imput ; H";no  in
   y ms  d 	1 ====== ==  uImput ;"== ength===== ten===== d se VALUE schoolyn	(defaul.=32)d 	0====== ===  uNIUrh==== length========en=====d 	1 ====== ==  uAtt nde; GED classes or h==gth=d 	2 ====== ==  uDid no  att nd  gt =====   ===nd se VALUE scholyna	(defaul.=32)d 	0====== ===  uNo  imput ; H";no  in
   y ms  d 	1 ====== ==  uImput ;"== ength===== ten===== d se VALUE wicyn  g	(defaul.=32)d 	0====== ===  uNIUrh==== length========en=====d 	1 ====== ==  uRece y d WIC"== ength===== th==d 	2 ====== ==  uDid no  rece y  WIC"== ength===d se VALUE wicyna  	(defaul.=32)d 	0====== ===  uNo  imput ; H";no  in
   y ms  d 	1 ====== ==  uImput ;"== ength===== ten===== d se VALUE comsrvyn	(defaul.=32)d 	0====== ===  uNIUrh==== length========en=====d 	1 ====== ==  uParnicipate; in
work programs"=d 	2 ====== ==  uDid no aparticipate"== ength===d se VALUE cmsrvyna	(defaul.=32)d 	0====== ===  uNo  imput ; H";no  in
   y ms  d 	1 ====== ==  uImput ;"== ength===== ten===== d se VALUE industry	(defaul.=32)d 	0====== ===  uNo  in
   y ms  H";o under "= td se VALUE uccu    	(defaul.=32)d 	0====== ===  uNo  in
   y ms  H";o under "= td se VALUE fedtax_b 	(defaul.=32)d 	0====== ===  uNon   gt =====   ===nh ength=n d se VALUE fedtax_a 	(defaul.=32)d 	0====== ===  uNon   gt =====   ===nh ength=n d se VALUE stlaetax_b 	(defaul.=32)d 	0====== ===  uNon   gt =====   ===nh ength=n d se VALUE stlaetax_a 	(defaul.=32)d 	0====== ===  uNon   gt =====   ===nh ength=n d se VALUE pecohab 	(defaul.=32)d 	-1====== ==  uNo Partn m presest"== th====== d se VALUE pelnmom 	(defaul.=32)d 	-1====== ==  uNo Mo  er presest"== th====== =d 	1 ====== ==  uMin
Valu "=== == === eng ==== =d 	16====== ==  uMax
Valu "=== == === eng ==== =d se VALUE pelndad 	(defaul.=32)d 	-1====== ==  uNo Fa  er presest"== th====== =d se VALUE pemom   	(defaul.=32)d 	-1====== ==  uNo Mo  er presest"== th====== =d 	1 ====== ==  uBiological"=== == === eng ==== d 	2 ====== ==  uStep  gt =====   ===nh ength=n d 	3 ====== ==  uAdopt ;"== ength===== ten===== d se VALUE pedad   	(defaul.=32)d 	-1====== ==  uNo Fa  er presest"== th====== =d 	1 ====== ==  uBiological"=== == === eng ==== d 	2 ====== ==  uStep  gt =====   ===nh ength=n d 	3 ====== ==  uAdopt ;"== ength===== ten===== d se VALUE pxcohab 	(defaul.=32)d 	-1====== ==  uNo  allocate;"== ength===== th=d 	0====== ===  uValu a- No chang "=== == === end 	1 ====== ==  uBla ka- No chang "=== == === end 	2 ====== ==  uDon't knowa- No chang "=== == =d 	3 ====== ==  uRefaseda- No chang "=== == === d 	10===== ===  uValu abomValu "=== == === eng =d 	11====== ==  uBla kabomValu "=== == === eng =d 	12====== ==  uDon't knowabomValu "=== == === 
 	13====== ==  uRefasedabomValu "=== == === eng
 	20====== ==  uValu abomLongitudinalmvalu "===d 	21====== ==  uBla kabomLongitudinalmvalu "===d 	22====== ==  uDon't knowabomLongitudinalmvalu "
 	23====== ==  uRefasedabomLongitudinalmvalu "=
 	30====== ==  uValu abomAllocate;mvalu mlong. d 	31====== ==  uBla kabomAllocate;mvalu mlong. d 	32====== ==  uDon't knowabomAllocate;mvalu " d 	33====== ==  uRefasedabomAllocate;mvalu mlong. d 	40====== ==  uValu abomAllocate;mvalu " = eng
 	41====== ==  uBla kabomAllocate;mvalu " = eng
 	42====== ==  uDon't knowabomAllocate;mvalu " d 	43====== ==  uRefasedabomAllocate;mvalu " = e
 	50====== ==  uValu abomBla k"=== == === eng =d 	52====== ==  uDon't knowabomBla k"=== == === 
 	53====== ==  uRefasedabomBla k"=== == === engd se VALUE pxlndad 	(defaul.=32)d 	0====== ===  uValu a- No chang "=== == === end 	1 ====== ==  uBla ka- No chang "=== == === end 	2 ====== ==  uDon't knowa- No chang "=== == =d 	3 ====== ==  uRefaseda- No chang "=== == === d 	10===== ===  uValu abomValu "=== == === eng =d 	11====== ==  uBla kabomValu "=== == === eng =d 	12====== ==  uDon't knowabomValu "=== == === 
 	13====== ==  uRefasedabomValu "=== == === eng
 	20====== ==  uValu abomLongitudinalmvalu "===d 	21====== ==  uBla kabomLongitudinalmvalu "===d 	22====== ==  uDon't knowabomLongitudinal" engd 	23====== ==  uRefasedabomLongitudinalmvalu "=
 	30====== ==  uValu abomAllocate;mvalu mlong. d 	31====== ==  uBla kabomAllocate;mvalu mlong. d 	32====== ==  uDon't knowabomAllocate;mvalu " d 	33====== ==  uRefasedabomAllocate;mvalu " engd 	40====== ==  uValu abomAllocate;mvalu " = eng
 	41====== ==  uBla kabomAllocate;mvalu " = eng
 	42====== ==  uDon't knowabomAllocate;mvalu " d 	43====== ==  uRefasedabomAllocate;mvalu " = e
 	50====== ==  uValu abomBla k"=== == === eng =d 	52====== ==  uDon't knowabomBla k"=== == === 
 	53====== ==  uRefasedabomBla k"=== == === engd se 
proc print data=libr   .cpsmar07 (obs=6)se 

FORMAT
 	hrecorr g  hrecorr.= 
 	h   ts= engh   ts. = 
 	h famincengh faminc. 
 	h_respnmengh_respnm. 
 	h_hh    engh_hh    . 
 	h_nump m   h_nump m. 
 	hnumfam enghnumfam.= 
 	h_    eng  h_    . = 
 	h_month  g h_month.= 
 	h_hhnum engh_hhnum.= 
 	h_livqrtengh_livqrt. 
 	h_    bcg  h_    bc. 
 	h_tenur engh_tenur . 
 	h_telhhdengh_telhhd. 
 	h_telavlengh_telavl. 
 	h_telint ngh_telint. 
 	gereg== enggereg.=== 
 	gestcen enggestcen.= 
 	gtcbsa     gtcbsa. = 
 	gtco=== enggtco. === 
 	gtcbsast   gtcbsast. 
 	gtmetstl   gtmetstl. 
 	gtindvpc   gtindvpc. 
 	gtcbsasz   gtcbsasz. 
 	gtcsa      gtcsa.=== 
 	h  der15===h  der1 . 
 	hcm        hcm    .= 
 	hcm eno    hcm eno.= 
 	hchi       hchi. === 
 	hchino     hchino.== 
 	hchinrh    hchinrh.= 
 	hchinno    hchinno.= 
 	hh5to18====hh5to18l. 
 	hhotlun====hhotlun.= 
 	hhotno     hhotno.== 
 	hflunch    hflunch.= 
 	hflunno    hflunno.= 
 	hpublic    hpublic.= 
 	hlorest    hlorest.= 
 	hfoodsp    hfoodsp.= 
 	hfoodno    hfoodno.= 
 	hfoodmo    hfoodmo.= 
 	hfd        hfd   .== 
 	hengast    hengast.= 
 	heng       heng   .= 
 	hinc_ws= enhinc_ws.= 
 	hws        hws   .== 
 	hinc_se= enhinc_s .= 
 	hse        hse   .== 
 	hinc_fr= enhinc_fr.= 
 	hfr        hfr   .== 
 	hinc_uc= enhinc_uc.= 
 	huc        huc   .== 
 	hinc_wc= enhinc_wc.= 
 	hwc        hwc   .== 
 	hss_yn  g  hss_yn.== 
 	hss        hss   .== 
 	hssi_yn  g hssi_yn.= 
 	hssi       hssi   .= 
 	hpaw_yn  g hpaw_yn.= 
 	hpaw       hpaw   .= 
 	hvet_yn  g hvet_yn.= 
 	hvet       hvet   .= 
 	hsur_yn  g hsur_yn.= 
 	hsur       hsur   .= 
 	hdis_yn  g hdis_yn.= 
 	hdis       hdis   .= 
 	hret_yn  g hret_yn.= 
 	hret       hret   .= 
 	hint_yn  g hint_yn.= 
 	hint       hint   .= 
 	hdiv_yn  g hdiv_yn.= 
 	hdiv       hdiv   .= 
 	hrnt_yn  g hrnt_yn.= 
 	hrnt       hrnt   .= 
 	hed_yn  g  hed_yn.== 
 	hed        hed   .== 
 	hcsp_yn  g hcsp_yn.= 
 	hcsp       hcsp   .= 
 	halm_yn  g halm_yn.= 
 	halm       halm   .= 
 	hfin_yn  g hfin_yn.= 
 	hfin       hfin   .= 
 	hoi_yn  g  hoi_yn.== 
 	hoi        hoi   .== 
 	htot       htot   .= 
 	hearn      hearn   . 
 	hoth       hoth   .= 
 	hhinceng   hhinc. == 
 	hm         hm    .=  
 	hm  ir g   hm  ir.== 
 	hchamp g   hchamp.== 
 	hhi_yn  g  hhi_yn.== 
 	hhstltusg  hhstltus. 
 	h  der18 ==h  der1h. 
 	htop5pct   htop5pct. 
 	hpctcati   hpctcat.= 
 	h1tenur engh1tenur . 
 	h1livqrtengh1livqrt. 
 	h1telhhdengh1telhhd. 
 	h1telavlengh1telavl. 
 	h1telint ngh1telint. 
 	i_hhotlu ngi_hhotlu. 
 	i_hhotno   i_hhotno. 
 	i_hflunc   i_hflunc. 
 	i_hflunn   i_hflunn. 
 	i_hpubli   i_hpubli. 
 	i_hlores   i_hlores. 
 	i_hfoods   i_hfoods. 
 	i_hfd      i_hfd   . 
 	i_hfoodn   i_hfoods. 
 	i_hfoodm   i_hfoodm. 
 	i_hengas   i_hengas. 
 	i_hengva   i_hengvl. 
 	prop_tax   prop_tax. 
 	housret    housret.= 
 	hrh    eng hrh    .= 
 	i_h   ts= ei_h   ts. 
 	hrtayn  g  hrtayn.== 
 	hrnumtl    hrnumtl.= 
 	hrccayn  g hrccayn.= 
 	hrnumcc    hrnumcc.= 
 	hrpaircc   hrpaircc. 
 	hrcmsryn  ghrcmsryn. 
 	hrjcyn  g  hrjcyn.== 
 	hrjryn  g  hrjryn.== 
 	hrjtyn  g  hrjtyn.== 
 	hrschlyn  ghrschlyn. 
 	hrwicyn  g hrwicyn.= 
 	frecorr g  frecorr.= 
 	fkin;      fkin;. == 
 	f    eng   f    . =  
 	fwifeidx   fwifeidx. 
 	fhusbidx   fhusbidx. 
 	fspuaidx   fspuaidx. 
 	fownu6=====fownu6 .= 
 	fownu18====fownu18 . 
 	frelu6=====frelu6l.= 
 	frelu18====frelu18 . 
 	fpctcati   fpctcat.= 
 	famlis= engfamlis.== 
 	povl       povl . =  
 	frspuv=====frspuv.== 
 	finc_ws= enfinc_ws.= 
 	finc_se= enfinc_s .= 
 	fse        fse   .== 
 	finc_fr= enfinc_fr.= 
 	ffr        ffr   .== 
 	finc_uc= enfinc_uc.= 
 	fuc        fuc   .== 
 	finc_wc= enfinc_wc.= 
 	fwc        fwc   .== 
 	finc_ss= enfinc_ss.= 
 	fss        fss   .== 
 	finc_ssi enfinc_ssi. 
 	fssi       fssi   .= 
 	finc_paw enfinc_paw. 
 	fpaw       fpaw   .= 
 	finc_vet   finc_vet. 
 	fvet       fvet   .= 
 	finc_sur enfinc_sur. 
 	fsur       fsur   .= 
 	finc_dis= efinc_dis. 
 	fdis       fdis   .= 
 	finc_ret   finc_ret. 
 	fret       fret   .= 
 	finc_int ngfinc_int. 
 	fint       fint   .= 
 	finc_div= efinc_div. 
 	fdiv       fdiv   .= 
 	finc_rnt ngfinc_rnt. 
 	frnt       frnt   .= 
 	finc_ed= enfinc_er.= 
 	fed        fed   .== 
 	finc_csp   finc_csp. 
 	fcsp       fcsp   .= 
 	finc_alm   finc_alm. 
 	falm       falm   .= 
 	finc_fin enfinc_fin. 
 	ffin       ffin   .= 
 	finc_oi= enfinc_oi.= 
 	foi        foi   .== 
 	ftot       ftot   .= 
 	fearn      fearn   . 
 	foth       foth   .= 
 	ftot_r     ftot_r.== 
 	fspanish   fspanish. 
 	f_mv_fs= enf_mv_fs.= 
 	f_mv_sl= enf_mv_s .= 
 	ffng       ffng    . 
 	ffng  ir g ffng  ir. 
 	fhoussub   fhoussub. 
 	ffoodreq g ffoodreq. 
 	fhousreq g fhousreq. 
 	precorr g  precorr.= 
 	a_parest   a_parest. 
 	a_exprrp   a_exprrp. 
 	a_ag eng   a_ag . =  
 	a_maritl   a_maritl. 
 	a_spuase   a_spuase. 
 	a_sexeng   a_sex. =  
 	a_hgaeng   a_hga. =  
 	prdtrace=  prdtrace. 
 	p_stltng   p_stlt.== 
 	pehspnon  gpehspnon. 
 	prdthsp    prdthsp.= 
 	a_famnum ena_famnum. 
 	a_fam      a_fam   . 
 	a_famrel   a_famrel. 
 	a_pfrel    a_pfrel.= 
 	hhdrel     hhdrel.== 
 	famrel   ngfamrel.== 
 	hhdfmx     hhdfmx.== 
 	parest     parest. = 
 	age1====== age1l. =  
 	a_fnlwgt   a_fnlwgt. 
 	a_ernlwt   a_ernlwt. 
 	a_hrs1ng   a_hrs1l.= 
 	a_uslftg   a_uslft.= 
 	a_whyabs   a_whyabs. 
 	a_payabs   a_payabs. 
 	peioin;    peioin;.  
 	peioocc    peioocc.= 
 	a_wkslkg   a_wkslk.= 
 	a_whenlj   a_whenlj. 
 	a_clswkr   a_clswkr. 
 	a_nlflj    a_nlflj.= 
 	a_wantjb   a_wantjb. 
 	peafev m   peafev m. 
 	peafwhn1   peafwhna. 
 	peafwhn2   peafwhnb. 
 	peafwhn3   peafwhnc. 
 	peafwhn4   peafwhnd. 
 	a_uslhrs   a_uslhrs. 
 	a_hrlywk   a_hrlywk. 
 	a_hrspay   a_hrspay. 
 	a_grswkg   a_grswk.= 
 	a_unmemg   a_unmem.= 
 	a_uncuv====a_uncuv.= 
 	a_enrlw====a_enrlw.= 
 	a_hscol    a_hscol.= 
 	a_ftptng   a_ftpt. = 
 	a_lfsrng   a_lfsr. = 
 	a_un  pe===a_un    . 
 	a_wkstltng a_wkstlt. 
 	a_explf    a_explf.= 
 	a_wksch    a_wksch.= 
 	a_civlf    a_civlf.= 
 	a_ftlf     a_ftlf. = 
 	a_mjin;    a_mjin;.= 
 	a_dtin;    a_dtin;.= 
 	mjocc      mjocc. =  
 	a_dtocc    a_dtocc.  
 	prerelg    prerelg.  
 	workyn  g  workyn. = 
 	wtemp g    wtemp. =  
 	nwlook;;;;;nwlook.=  
 	nwlkwk;;;;;nwlkwk.=  
 	rsnnotw====rsnnotw.  
 	wkswork    wkswork.  
 	wkcheck    wkcheck.  
 	losewks    losewks.  
 	lknon      lknon .=  
 	lkweeks    lkweeks.  
 	lkstrch    lkstrch.  
 	pyrsn g    pyrsn. =  
 	phmemprs   phmemprs. 
 	hrswkg    ghrswk.=   
 	hrcheck    hrcheck.  
 	ptyn  g    ptyn.==   
 	ptweeks    ptweeks.  
 	ptrsn g    ptrsn. =  
 	ljcw  g    ljcw.==   
 	wexp  g    wexp.==   
 	wewkrsg    wewkrs. = 
 	welknwg    welknw. = 
 	weuemp g   weuemp. = 
 	earnerng   earner. = 
 	clwkg    g clwk.==   
 	weclw g    weclw. =  
 	mig_cbst   mig_cbst. 
 	migsam     migsam .  
 	mig_reg== emig_reg.  
 	mig_st     mig_st.=  
 	mig_dscp   mig_dscp. 
 	gediv= e nggediv. =  
 	mig_div= e mig_div.  
 	mig_mtr1 e mig_mtra. 
 	mig_mtr3 e mig_mtrc. 
 	mig_mtr4 e mig_mtrd. 
 	noemp g    noemp. =  
 	ern_yn  g  ern_yn.=  
 	ern_       ern_   .  
 	ern_srce=  ern_srce. 
 	ern_otr    ern_otr.  
 	wageotr    wageotr.  
 	wsal_yn  g wsal_yn.  
 	wsal_      wsal_   . 
 	seotr      seotr.    
 	semp_yn  g semp_yn.  
 	semp_      semp_   . 
 	frmotr     frmotr.== 
 	frse_yn  g frse_yn.= 
 	frse_      frse_   . 
 	uc_yn  g   uc_yn.    
 	subuc      subuc.    
 	strkuc     strkuc.== 
 	uc_        uc_   . = 
 	wc_yn  g   wc_yn.    
 	wc_    eng wc_    .  
 	wc_        wc_   . = 
 	ss_yn  g   ss_yn.==  
 	ss_        ss_   . = 
 	ssi_yn  g  ssi_yn.=  
 	paw_yn  g  paw_yn.=  
 	paw_       paw_   .  
 	paw_mon  g paw_mon.  
 	paw_       paw_   .  
 	vet_yn  g  vet_yn.=  
 	vet_   1g  vet_t  a. 
 	vet_   2g  vet_t  b. 
 	vet_   3g  vet_t  c. 
 	vet_   4g  vet_t  d. 
 	vet_   5g  vet_t  e. 
 	vet_qva    vet_qva.  
 	vet_       vet_   .  
 	sur_yn  g  sur_yn.=  
 	sur_sc1 g  sur_sc1 . 
 	sur_   1g  sur_   a. 
 	sur_   2g  sur_   b. 
 	srvs_      srvs_   . 
 	dis_hp g   dis_hp.=  
 	dis_cs g   dis_cs.=  
 	dis_yn  g  dis_yn.=  
 	dis_sc1 g  dis_sc1 . 
 	dis_   1g  dis_   a. 
 	dis_   2g  dis_   b. 
 	dsab_      dsab_   . 
 	ret_yn  g  ret_yn.=  
 	ret_sc1 g  ret_sc1 . 
 	ret_   1g  ret_   a. 
 	ret_   2g  ret_   b. 
 	rtm_       rtm_   .  
 	int_yn  g  int_yn.=  
 	int_       int_   .  
 	div_yn  g  div_yn.=  
 	div_non  g div_non.  
 	div_       div_   .  
 	rnt_yn  g  rnt_yn.=  
 	rnt_       rnt_   .  
 	ed_yn  g   ed_yn.==  
 	oed_   1g  oed_   a. 
 	oed_   2g  oed_   b. 
 	oed_   3g  oed_   c. 
 	ed_    g   ed_   . = 
 	csp_yn  g  csp_yn.=  
 	csp_    g  csp_   .= 
 	alm_yn  g  alm_yn.=  
 	alm_    g  alm_   .= 
 	fin_yn  g  fin_yn.=  
 	fin_       fin_   .= 
 	oi_off     oi_off.=  
 	oi_yn  g   oi_yn.==  
 	oi_    g   oi_   .=  
 	ptot       ptot   .= 
 	pearn      pearn   . 
 	poth       poth   .= 
 	fl_665 ====fl_665 .= 
 	ptot_r     ptot_r.== 
 	perlis= engperlis.=  
 	m          m    .=   
 	m  ir g    m  ir.==  
 	champ g    champ.==  
 	hi_yn  g   hi_yn.==  
 	hiow   g   hiow .==  
 	hiemp g    hiemp.==  
 	hip ir g   hip ir. = 
 	wrk_ck     wrk_ck.== 
 	penpla  engpenpla .= 
 	penincl engpenincl.= 
 	cuv_gh  g  cuv_gh.=  
 	cuv_hi     cuv_hi.=  
 	ch_mc g    ch_mc.==  
 	ch_hi      ch_hi.==  
 	a1rrp   g  a1rrp. =  
 	a1parest   a1parest. 
 	a1ag eng   a1ag . =  
 	a1maritl   a1maritl. 
 	a1spuase   a1spuase. 
 	a1sexeng   a1sex. =  
 	a1hgaeng   a1hga. =  
 	a1lfsrng   a1lfsr. = 
 	a1hrsg     a1hrs. =  
 	pxafev m   pxafev m. 
 	pxafwhn1   pxafwhna. 
 	a1whyabs   a1whyabs. 
 	a1payabs   a1payabs. 
 	a1clswkr   a1clswkr. 
 	a1nlflj    a1nlflj.= 
 	a1uslhrs   a1uslhrs. 
 	a1hrlywk   a1hrlywk. 
 	prwern     prwern  . 
 	prhern     prhern  . 
 	a1unmemg   a1unmem.= 
 	a1uncuv====a1uncuv.= 
 	a1enrlw====a1enrlw.= 
 	a1hscol    a1hscol.= 
 	a1ftptng   a1ftpt. = 
 	i_ernyn  g i_ernyn.= 
 	i_ern      i_ern   . 
 	i_wsyn  g  i_wsyn. = 
 	i_ws       i_ws   .= 
 	i_seyn  g  i_seyn. = 
 	i_se       i_se   .= 
 	i_frmyn  g i_frmyn.= 
 	i_frm      i_frm   . 
 	i_ucyn  g  i_ucyn. = 
 	i_uc       i_uc   .= 
 	i_wcyn  g  i_wcyn. = 
 	i_wc       i_wc   .= 
 	i_wc       i_wc   .= 
 	i_ssyn  g  i_ssyn. = 
 	i_ss       i_ss   .= 
 	i_ssiyn  g i_ssiyn.= 
 	i_ssi      i_ssi   .=
 	i_pawyn  g i_pawyn.= 
 	i_paw      i_paw   .=
 	i_paw      i_paw   .=
 	i_pawmo    i_pawmo.= 
 	i_vetyn  g i_vetyn.= 
 	i_vet      i_vet   . 
 	i_vet      i_vet   .=
 	i_vetqva   i_vetqva.=
 	i_suryn  g i_suryn.= 
 	i_sursc1 g i_sursca.=
 	i_sursc2 g i_surscb.=
 	i_survl1 g i_survla.=
 	i_survl2 g i_survlb.=
 	i_dissc1 g i_dissca.=
 	i_dissc2 g i_disscb.=
 	i_dish     i_dish .= 
 	i_discs g  i_discs.= 
 	i_disyn  g i_disyn.= 
 	toi_    g  toi_   .= 
 	i_disvl1 g i_disvla.=
 	i_disvl2 g i_disvlb.=
 	i_retyn  g i_retyn.= 
 	i_retsc1 g i_retsca. 
 	i_retsc2 g i_retscb.=
 	i_retvl1 g i_retvla.=
 	i_retvl2 g i_retvlb.=
 	i_intyn  g i_intyn.= 
 	i_int      i_int   .=
 	i_divyn  g i_divyn.= 
 	i_div      i_div   .=
 	i_rntyn  g i_rntyn.= 
 	i_rnt      i_rnt   .=
 	i_edyn  g  i_edyn. = 
 	i_ed   1g  i_ed   a. 
 	i_ed   2g  i_ed   b.=
 	i_oed      i_oed   . 
 	i_cspyn  g i_cspyn.= 
 	i_csp      i_csp   . 
 	i_almyn  g i_almyn.= 
 	i_alm      i_alm   . 
 	i_finyn  g i_finyn.= 
 	i_fin      i_fin   .=
 	i_oi       i_oi   .= 
 	i_nwlook;;;i_nwlook. 
 	i_nwlkwk;;;i_nwlkwk.=
 	i_rsnnot   i_rsnnot.=
 	i_losewk   i_losewk.=
 	i_lkweek   i_lkweek.=
 	i_lkstr    i_lkstr.= 
 	i_pyrsn g  i_pyrsn.= 
 	i_phmempg  i_phmemp.=
 	i_hrswkg   i_hrswk.= 
 	i_hrchkg   i_hrchk.= 
 	i_ptyn  g  i_ptyn. = 
 	i_ptwks    i_ptwks.= 
 	i_ptrsn g  i_ptrsn.= 
 	i_ljcw  g  i_ljcw. = 
 	i_indus  g i_indus.= 
 	i_uccu     i_uccu .= 
 	i_workyn  gi_workyn. 
 	i_wtemp g  i_wtemp.= 
 	i_wkswkg   i_wkswk.= 
 	i_wkchkg   i_wkchk.= 
 	i_ernsrc   i_ernsrc. 
 	i_noemp g  i_noemp. =
 	i_mig2  g  i_mig2 .= 
 	i_penplag  i_penpla. 
 	i_peninc   i_peninc.=
 	i_mig1  g  i_mig1l.= 
 	p_mv       p_mv    . 
 	p_mv  ir g p_mv  ir. 
 	emcontrb   emcontrb. 
 	filestltng filestlt. 
 	dep_stltng dep_stlt. 
 	ctc_crr g  ctc_crr.  
 	eit_cred= eeit_cred. 
 	actc_crr g actc_crr. 
 	ficaeng    fica. =   
 	fed_ret    fed_ret.= 
 	agi        agi. =    
 	cap_gain encap_gain. 
 	cap_loss encap_loss. 
 	tax_inceng tax_inc.= 
 	marg_tax   marg_tax. 
 	pemlr      pemlr. =  
 	prun  pe===prun  pe. 
 	prwkstltng prwkstlt. 
 	prptrea    prptrea.= 
 	prdisc     prdisc.== 
 	prcow1     prcow1l.= 
 	prper      prper   . 
 	peabsrsn g peabsrsn. 
 	peio1cow   peio1cow. 
 	prnlfsch   prnlfsch. 
 	pehrusltng pehruslt. 
 	peinusym   peinusym. 
 	prcitsh    prcitsh . 
 	pxnatvty   pxnatvty. 
 	perrp   g  perrp. =  
 	i_mig3  g  i_mig3 .= 
 	hi         hi. === = 
 	hi         hi   .=   
 	dephi      dephi.==  
 	hilin1     hilin1 .  
 	hilin2     hilin2 .= 
 	p ir g     p ir. =   
 	hioati     hiuat. =  
 	priv= e ng priv. =   
 	pri     ng pri   .=  
 	depriv= e ndepriv.== 
 	pilin1     pilin1 .  
 	pilin2     pilin2 .= 
 	poati      puat. =   
 	oati       uat. =    
 	ca             .=    
 	cair g     c ir. =   
 	mon  g     mon.  =   
 	oth  g     uth.= =   
 	ot  _1     ut  _1 .  
 	ot  _2     ut  _2 .  
 	ot  _3     ut  _3 .  
 	ot  _4     ut  _4 .  
 	ot  _5     ut  _5 .  
 	othstp m   uthstp m. 
 	othst  1g  o hst  a. 
 	heaeng     hea.= =   
 	i_hi       i_hi. =   
 	i_dephi    i_dephi.= 
 	i_pair g   i_pair.   
 	i_hioati   i_hioat.= 
 	i_priv= e ni_priv.   
 	i_depriv= ei_depriv. 
 	i_poati    i_poat.   
 	i_oati     i_oat. =  
 	i_ca       i_ca  .=  
 	i_cair g   i_cair.   
 	i_mon  g   i_mon.  = 
 	i_oth  g   i_oth.  = 
 	i_ot    ng i_ot  .   
 	i_ostp m   i_ostp m. 
 	i_ost      i_ost  .= 
 	i_heaeng   i_hea.  = 
 	ssi_       ssi_   .= 
 	ws_        ws_   . = 
 	se_        se_   . = 
 	ihsflg     ihsflg. = 
 	tsurval1g  tsurvala. 
 	tsurval2g  tsurvalb. 
 	tdisval1g  tdisvala. 
 	tdisval2g  tdisvalb. 
 	tret   1g  tret   a. 
 	tret   2g  tret   b. 
 	tint_      tint_   . 
 	tdiv_      tdiv_   . 
 	trnt_      trnt_   . 
 	ted_    g  ted_   . =
 	tcsp_    g tcsp_   .=
 	talm_    g talm_   .=
 	tfin_      tfin_   .=
 	nxtres     nxtres.   
 	i_nxtres   i_nxtres. 
 	frm_       frm_   .= 
 	nrai       tranyn. = 
 	nrai  a    tranyna.= 
 	ccayn  g   ccayn.= = 
 	ccayna g   ccayna. = 
 	pairccyn   pairccyn. 
 	paircyna g paircyna. 
 	ahip m     ahip m.   
 	iahip m    iahip m.  
 	ahityp6    ahityp6 . 
 	iahit      iahi   .= 
 	pchip    g pchip.  = 
 	i_pchip    i_pchip.= 
 	resnss1    resnss1 . 
 	resnss2    resnss2 . 
 	resnssa    resnssa.= 
 	resnssi1   resnssia. 
 	resnssi2   resnssib. 
 	resnssia   resnssix. 
 	ssikidyn   ssikidyn. 
 	ssikdyna g ssikdyna. 
 	sskidyn    sskidyn.  
 	sskidyna   sskidyna. 
 	jcyn  g    jcyn.==   
 	jcyna g    jcyna.  = 
 	jryn  g    jryn.== = 
 	jryna g    jryna.  = 
 	jtyn  g    jtyn.==   
 	jtyna      jtyna.  = 
 	schoolyn   schoolyn. 
 	scholyna   scholyna. 
 	wicyn  g   wicyn.=   
 	wicyna g   wicyna. = 
 	comsrvyn   comsrvyn. 
 	cmsrvyna   cmsrvyna. 
 	industry   industry. 
 	occu       uccu .=   
 	fedtax_b   fedtax_b .
 	fedtax_a   fedtax_a .
 	stlaetax_b  stlaetax_b .
 	stlaetax_ac stlaetax_a .
 	pecohab  g pecohab.= 
 	pelnmom  g pelnmom.= 
 	pelndad  g pelndad.= 
 	pemom    g pemom   . 
 	pedad    g pedad   . 
 	pxcohab  g pxcohab.= 
 	pxlndad  g pxlndad.= 
 ;
runse 
proc contents data=libr   .cpsmar07 varnum;
runse 
proc freq data=libr   .cpsmar07se   weight marsupwtse   tlbles p_stltna_exprrp hhdfmx /list nop mcent;
runse 

endsasse 
/*
Copyright 2007 shared                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              